/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.net.ssl.SSLException;

final class CipherSuiteList {
    private static CipherSuiteList a;
    private static CipherSuiteList b;
    private final Collection c;
    private String[] d;

    private CipherSuiteList(Collection collection) {
        this.c = collection;
    }

    CipherSuiteList(CipherSuite cipherSuite) {
        this.c = new ArrayList(1);
        this.c.add(cipherSuite);
    }

    CipherSuiteList(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("CipherSuites may not be null");
        }
        this.c = new ArrayList(stringArray.length);
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            CipherSuite cipherSuite = CipherSuite.a(string);
            if (!cipherSuite.a()) {
                if (!bl) {
                    CipherSuiteList.d();
                    bl = true;
                }
                if (!cipherSuite.a()) {
                    throw new IllegalArgumentException("Cannot support " + string + " with currently installed providers");
                }
            }
            this.c.add(cipherSuite);
            ++n;
        }
    }

    CipherSuiteList(HandshakeInStream handshakeInStream) throws IOException {
        byte[] byArray = handshakeInStream.g();
        if ((byArray.length & 1) != 0) {
            throw new SSLException("Invalid ClientHello message");
        }
        this.c = new ArrayList(byArray.length >> 1);
        int n = 0;
        while (n < byArray.length) {
            this.c.add(CipherSuite.a(byArray[n], (int)byArray[n + 1]));
            n += 2;
        }
    }

    boolean a(CipherSuite cipherSuite) {
        return this.c.contains(cipherSuite);
    }

    Iterator a() {
        return this.c.iterator();
    }

    int b() {
        return this.c.size();
    }

    synchronized String[] c() {
        if (this.d == null) {
            this.d = new String[this.c.size()];
            Iterator iterator = this.c.iterator();
            int n = 0;
            while (n < this.d.length) {
                CipherSuite cipherSuite = (CipherSuite)iterator.next();
                this.d[n] = cipherSuite.e;
                ++n;
            }
        }
        return (String[])this.d.clone();
    }

    public String toString() {
        return this.c.toString();
    }

    void a(HandshakeOutStream handshakeOutStream) throws IOException {
        byte[] byArray = new byte[this.c.size() * 2];
        int n = 0;
        Iterator iterator = this.c.iterator();
        while (iterator.hasNext()) {
            CipherSuite cipherSuite = (CipherSuite)iterator.next();
            byArray[n] = (byte)(cipherSuite.f >> 8);
            byArray[n + 1] = (byte)cipherSuite.f;
            n += 2;
        }
        handshakeOutStream.b(byArray);
    }

    static synchronized void d() {
    }

    private static void g() {
        TreeSet<CipherSuite> treeSet = new TreeSet<CipherSuite>();
        TreeSet<CipherSuite> treeSet2 = new TreeSet<CipherSuite>();
        Collection collection = CipherSuite.b();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CipherSuite cipherSuite = (CipherSuite)iterator.next();
            if (!cipherSuite.l || !cipherSuite.i.a()) continue;
            treeSet.add(cipherSuite);
            if (cipherSuite.g < 300) continue;
            treeSet2.add(cipherSuite);
        }
        a = new CipherSuiteList(treeSet);
        b = new CipherSuiteList(treeSet2);
    }

    static synchronized CipherSuiteList e() {
        if (a == null) {
            CipherSuiteList.g();
        }
        return a;
    }

    static synchronized CipherSuiteList f() {
        if (b == null) {
            CipherSuiteList.g();
        }
        return b;
    }
}

