/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SecureKey;
import com.sun.net.ssl.internal.ssl.SessionId;
import com.sun.net.ssl.internal.ssl.SunJSSE_g;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

final class SSLSessionImpl
implements SSLSession {
    static final SSLSessionImpl a = new SSLSessionImpl();
    private static final byte b = 0;
    private final ProtocolVersion c;
    private final SessionId d;
    private java.security.cert.X509Certificate[] e;
    private byte f;
    private final CipherSuite g;
    private byte[] h;
    private final long i = System.currentTimeMillis();
    private long j = 0L;
    private final String k;
    private final int l;
    private SSLSessionContextImpl m;
    private int n;
    private boolean o;
    private boolean p;
    private java.security.cert.X509Certificate[] q;
    private static int r = 0;
    private static boolean s = true;
    private static final Debug t = Debug.getInstance("ssl");
    private Hashtable u = new Hashtable();

    private SSLSessionImpl() {
        this(ProtocolVersion.a, SunJSSE_g.C_NULL, new SessionId(false, null), null, -1);
    }

    SSLSessionImpl(ProtocolVersion protocolVersion, CipherSuite cipherSuite, SecureRandom secureRandom, String string, int n) {
        this(protocolVersion, cipherSuite, new SessionId(s, secureRandom), string, n);
    }

    SSLSessionImpl(ProtocolVersion protocolVersion, CipherSuite cipherSuite, SessionId sessionId, String string, int n) {
        this.c = protocolVersion;
        this.d = sessionId;
        this.e = null;
        this.f = 0;
        this.g = cipherSuite;
        this.h = null;
        this.k = string;
        this.l = n;
        this.n = ++r;
        if (t != null && Debug.isOn("session")) {
            System.out.println("%% Created:  " + this);
        }
    }

    void a(byte[] byArray) {
        if (this.h == null) {
            this.h = byArray;
        }
    }

    byte[] a() {
        return this.h;
    }

    void a(java.security.cert.X509Certificate[] x509CertificateArray) {
        if (this.e == null) {
            this.e = x509CertificateArray;
        }
    }

    void b(java.security.cert.X509Certificate[] x509CertificateArray) {
        this.q = x509CertificateArray;
    }

    boolean b() {
        return this.d != null && this.d.a() != 0 && !this.p;
    }

    public byte[] getId() {
        return this.d.b();
    }

    boolean c() {
        return this.o;
    }

    void a(boolean bl) {
        this.o = bl;
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.m;
    }

    SessionId d() {
        return this.d;
    }

    CipherSuite e() {
        return this.g;
    }

    public String getCipherSuite() {
        return this.e().e;
    }

    ProtocolVersion f() {
        return this.c;
    }

    public String getProtocol() {
        return this.f().l;
    }

    byte g() {
        return this.f;
    }

    public int hashcode() {
        return this.d.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SSLSessionImpl) {
            SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)object;
            return this.d != null && this.d.equals(sSLSessionImpl.d());
        }
        return false;
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.e == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return (Certificate[])this.e.clone();
    }

    public Certificate[] getLocalCertificates() {
        return this.q == null ? null : (Certificate[])this.q.clone();
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.e == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[this.e.length];
        int n = 0;
        while (n < this.e.length) {
            byte[] byArray = null;
            try {
                byArray = this.e[n].getEncoded();
                x509CertificateArray[n] = X509Certificate.getInstance(byArray);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new SSLPeerUnverifiedException(certificateEncodingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new SSLPeerUnverifiedException(certificateException.getMessage());
            }
            ++n;
        }
        return x509CertificateArray;
    }

    public java.security.cert.X509Certificate[] getCertificateChain() throws SSLPeerUnverifiedException {
        if (this.e != null) {
            return (java.security.cert.X509Certificate[])this.e.clone();
        }
        throw new SSLPeerUnverifiedException("peer not authenticated");
    }

    public long getCreationTime() {
        return this.i;
    }

    public long getLastAccessedTime() {
        return this.j != 0L ? this.j : this.i;
    }

    void a(long l) {
        this.j = l;
    }

    public InetAddress getPeerAddress() {
        try {
            return InetAddress.getByName(this.k);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public String getPeerHost() {
        return this.k;
    }

    int h() {
        return this.l;
    }

    void a(SSLSessionContextImpl sSLSessionContextImpl) {
        if (this.m == null) {
            this.m = sSLSessionContextImpl;
        }
    }

    public synchronized void invalidate() {
        if (this == a) {
            return;
        }
        this.p = true;
        if (t != null && Debug.isOn("session")) {
            System.out.println("%% Invalidated:  " + this);
        }
        if (this.m != null) {
            this.m.a(this.d);
            this.m = null;
        }
    }

    public void putValue(String string, Object object) {
        SSLSessionBindingEvent sSLSessionBindingEvent;
        if (string == null || object == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        Object object2 = this.u.put(secureKey, object);
        if (object2 instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object2).valueUnbound(sSLSessionBindingEvent);
        }
        if (object instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueBound(sSLSessionBindingEvent);
        }
    }

    public Object getValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        return this.u.get(secureKey);
    }

    public void removeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        Object v = this.u.remove(secureKey);
        if (v instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)v).valueUnbound(sSLSessionBindingEvent);
        }
    }

    public String[] getValueNames() {
        Vector<Object> vector = new Vector<Object>();
        Object object = SecureKey.a();
        Enumeration enumeration = this.u.keys();
        while (enumeration.hasMoreElements()) {
            SecureKey secureKey = (SecureKey)enumeration.nextElement();
            if (!object.equals(secureKey.c())) continue;
            vector.addElement(secureKey.b());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        return "[Session-" + this.n + ", " + this.getCipherSuite() + "]";
    }

    public void finalize() {
        String[] stringArray = this.getValueNames();
        int n = 0;
        while (n < stringArray.length) {
            this.removeValue(stringArray[n]);
            ++n;
        }
    }
}

