/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import sun.plugin.security.CertificateStore;
import sun.plugin.security.DeniedCertificateStore;
import sun.plugin.security.HttpsRootCACertStore;
import sun.plugin.security.PluginHttpsCertStore;
import sun.plugin.security.RootCACertificateStore;
import sun.plugin.security.SessionCertificateStore;
import sun.plugin.security.TrustDeciderDialog;
import sun.plugin.usability.PluginSysAction;
import sun.plugin.usability.PluginSysUtil;
import sun.plugin.usability.Trace;

public final class X509PluginTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager = null;
    private static CertificateStore rootStore;
    private static CertificateStore httpsRootStore;
    private static CertificateStore permanentStore;
    private static CertificateStore sessionStore;
    private static CertificateStore deniedStore;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$plugin$security$X509PluginTrustManager;

    public static void reset() {
        rootStore = new RootCACertificateStore();
        httpsRootStore = new HttpsRootCACertStore();
        permanentStore = new PluginHttpsCertStore();
        sessionStore = new SessionCertificateStore();
        deniedStore = new DeniedCertificateStore();
    }

    public X509PluginTrustManager() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        this.trustManager = (X509TrustManager)trustManagerArray[0];
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void checkClientTrusted(final X509Certificate[] var1_1, String var2_2) throws CertificateException {
        var3_3 = false;
        var4_4 = false;
        if (!X509PluginTrustManager.$assertionsDisabled && this.trustManager == null) {
            throw new AssertionError();
        }
        var5_5 = 1;
        try {
            X509PluginTrustManager.rootStore.load();
            X509PluginTrustManager.httpsRootStore.load();
            X509PluginTrustManager.permanentStore.load();
            X509PluginTrustManager.sessionStore.load();
            X509PluginTrustManager.deniedStore.load();
            if (X509PluginTrustManager.deniedStore.contains(var1_1[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkClientTrusted(var1_1, var2_2);
                return;
            }
            catch (CertificateException var6_6) {
                if (X509PluginTrustManager.sessionStore.contains(var1_1[0])) {
                    return;
                }
                if (X509PluginTrustManager.permanentStore.contains(var1_1[0])) {
                    return;
                }
                var6_7 = 0;
                ** while (var6_7 < var1_1.length)
            }
lbl-1000:
            // 1 sources

            {
                if (!X509PluginTrustManager.rootStore.verify(var1_1[var6_7]) && !X509PluginTrustManager.httpsRootStore.verify(var1_1[var6_7])) {
                    var3_3 = true;
                }
                try {
                    var1_1[var6_7].checkValidity();
                }
                catch (CertificateExpiredException var7_9) {
                    var4_4 = true;
                }
                catch (CertificateNotYetValidException var8_13) {
                    var4_4 = true;
                }
                ++var6_7;
                continue;
            }
lbl36:
            // 1 sources

            if (!Trace.isAutomationEnabled()) {
                try {
                    var7_10 = var3_3;
                    var8_14 = var4_4;
                    var5_5 = (Integer)PluginSysUtil.execute(new PluginSysAction(){

                        public Object execute() throws Exception {
                            TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(var1_1, 0, var1_1.length, var7_10, var8_14);
                            trustDeciderDialog.setHttpsDialog(true);
                            return new Integer(trustDeciderDialog.DoModal());
                        }
                    });
                }
                catch (Exception var7_11) {
                    if (!X509PluginTrustManager.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            } else {
                Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreclientcert");
                var5_5 = 0;
            }
            if (var5_5 == 0) {
                X509PluginTrustManager.sessionStore.add(var1_1[0]);
                X509PluginTrustManager.sessionStore.save();
            } else if (var5_5 == 2) {
                X509PluginTrustManager.permanentStore.add(var1_1[0]);
                X509PluginTrustManager.permanentStore.save();
            } else {
                X509PluginTrustManager.deniedStore.add(var1_1[0]);
                X509PluginTrustManager.deniedStore.save();
            }
        }
        catch (CertificateException var6_8) {
            throw var6_8;
        }
        catch (Throwable var7_12) {
            var7_12.printStackTrace();
        }
        if (var5_5 != 0 && var5_5 != 2) {
            throw new CertificateException("Plugin couldn't trust Client");
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void checkServerTrusted(final X509Certificate[] var1_1, String var2_2) throws CertificateException {
        var3_3 = false;
        var4_4 = false;
        if (!X509PluginTrustManager.$assertionsDisabled && this.trustManager == null) {
            throw new AssertionError();
        }
        var5_5 = 1;
        try {
            X509PluginTrustManager.rootStore.load();
            X509PluginTrustManager.httpsRootStore.load();
            X509PluginTrustManager.permanentStore.load();
            X509PluginTrustManager.sessionStore.load();
            X509PluginTrustManager.deniedStore.load();
            if (X509PluginTrustManager.deniedStore.contains(var1_1[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkServerTrusted(var1_1, var2_2);
                return;
            }
            catch (CertificateException var6_6) {
                if (X509PluginTrustManager.sessionStore.contains(var1_1[0])) {
                    return;
                }
                if (X509PluginTrustManager.permanentStore.contains(var1_1[0])) {
                    return;
                }
                var6_7 = 0;
                ** while (var6_7 < var1_1.length)
            }
lbl-1000:
            // 1 sources

            {
                if (!X509PluginTrustManager.rootStore.verify(var1_1[var6_7]) && !X509PluginTrustManager.httpsRootStore.verify(var1_1[var6_7])) {
                    var3_3 = true;
                }
                try {
                    var1_1[var6_7].checkValidity();
                }
                catch (CertificateExpiredException var7_9) {
                    var4_4 = true;
                }
                catch (CertificateNotYetValidException var8_13) {
                    var4_4 = true;
                }
                ++var6_7;
                continue;
            }
lbl36:
            // 1 sources

            if (!Trace.isAutomationEnabled()) {
                try {
                    var7_10 = var3_3;
                    var8_14 = var4_4;
                    var5_5 = (Integer)PluginSysUtil.execute(new PluginSysAction(){

                        public Object execute() throws Exception {
                            TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(var1_1, 0, var1_1.length, var7_10, var8_14);
                            trustDeciderDialog.setHttpsDialog(true);
                            return new Integer(trustDeciderDialog.DoModal());
                        }
                    });
                }
                catch (Exception var7_11) {
                    if (!X509PluginTrustManager.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            } else {
                Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreservercert");
                var5_5 = 0;
            }
            if (var5_5 == 0) {
                X509PluginTrustManager.sessionStore.add(var1_1[0]);
                X509PluginTrustManager.sessionStore.save();
            } else if (var5_5 == 2) {
                X509PluginTrustManager.permanentStore.add(var1_1[0]);
                X509PluginTrustManager.permanentStore.save();
            } else {
                X509PluginTrustManager.deniedStore.add(var1_1[0]);
                X509PluginTrustManager.deniedStore.save();
            }
        }
        catch (CertificateException var6_8) {
            throw var6_8;
        }
        catch (Throwable var7_12) {
            var7_12.printStackTrace();
        }
        if (var5_5 != 0 && var5_5 != 2) {
            throw new CertificateException("Plugin couldn't trust Server");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$plugin$security$X509PluginTrustManager == null ? (class$sun$plugin$security$X509PluginTrustManager = X509PluginTrustManager.class$("sun.plugin.security.X509PluginTrustManager")) : class$sun$plugin$security$X509PluginTrustManager).desiredAssertionStatus();
        rootStore = null;
        httpsRootStore = null;
        permanentStore = null;
        sessionStore = null;
        deniedStore = null;
        X509PluginTrustManager.reset();
    }
}

