/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.PCosNaming;

import com.sun.corba.se.internal.CosNaming.InterOperableNamingImpl;
import com.sun.corba.se.internal.CosNaming.NamingContextDataStore;
import com.sun.corba.se.internal.CosNaming.NamingUtils;
import com.sun.corba.se.internal.PCosNaming.InternalBindingKey;
import com.sun.corba.se.internal.PCosNaming.InternalBindingValue;
import com.sun.corba.se.internal.PCosNaming.NameService;
import com.sun.corba.se.internal.PCosNaming.PersistentBindingIterator;
import com.sun.corba.se.internal.PCosNaming.ServantManagerImpl;
import com.sun.corba.se.internal.POA.POAORB;
import com.sun.corba.se.internal.corba.CorbaName;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class NamingContextImpl
extends NamingContextExtPOA
implements NamingContextDataStore,
Serializable {
    private transient POAORB orb;
    private final String objKey;
    private final Hashtable theHashtable = new Hashtable();
    private transient NameService theNameServiceHandle;
    private transient ServantManagerImpl theServantManagerImplHandle;
    private transient InterOperableNamingImpl insImpl;
    private static POA biPOA = null;
    public static final boolean debug = false;

    public NamingContextImpl(POAORB pOAORB, String string, NameService nameService, ServantManagerImpl servantManagerImpl) throws Exception {
        this.orb = pOAORB;
        this.objKey = string;
        this.theNameServiceHandle = nameService;
        this.theServantManagerImplHandle = servantManagerImpl;
        this.insImpl = new InterOperableNamingImpl();
    }

    InterOperableNamingImpl getINSImpl() {
        if (this.insImpl == null) {
            this.insImpl = new InterOperableNamingImpl();
        }
        return this.insImpl;
    }

    public void setRootNameService(NameService nameService) {
        this.theNameServiceHandle = nameService;
    }

    public void setORB(POAORB pOAORB) {
        this.orb = pOAORB;
    }

    public void setServantManagerImpl(ServantManagerImpl servantManagerImpl) {
        this.theServantManagerImplHandle = servantManagerImpl;
    }

    public POA getNSPOA() {
        return this.theNameServiceHandle.getNSPOA();
    }

    public void bind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (object == null) {
            throw new INTERNAL(1398080192, CompletionStatus.COMPLETED_NO);
        }
        NamingContextImpl namingContextImpl = this;
        NamingContextImpl.doBind(namingContextImpl, nameComponentArray, object, false, BindingType.nobject);
    }

    public void bind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (namingContext == null) {
            throw new BAD_PARAM("Naming Context should not be null ");
        }
        NamingContextImpl namingContextImpl = this;
        NamingContextImpl.doBind(namingContextImpl, nameComponentArray, namingContext, false, BindingType.ncontext);
    }

    public void rebind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName {
        if (object == null) {
            throw new INTERNAL(1398080192, CompletionStatus.COMPLETED_NO);
        }
        try {
            NamingContextImpl namingContextImpl = this;
            NamingContextImpl.doBind(namingContextImpl, nameComponentArray, object, true, BindingType.nobject);
        }
        catch (AlreadyBound alreadyBound) {
            throw new INTERNAL(1398080088, CompletionStatus.COMPLETED_NO);
        }
    }

    public void rebind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName {
        try {
            NamingContextImpl namingContextImpl = this;
            NamingContextImpl.doBind(namingContextImpl, nameComponentArray, namingContext, true, BindingType.ncontext);
        }
        catch (AlreadyBound alreadyBound) {
            throw new INTERNAL(1398080089, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object resolve(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        NamingContextImpl namingContextImpl = this;
        return NamingContextImpl.doResolve(namingContextImpl, nameComponentArray);
    }

    public void unbind(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        NamingContextImpl namingContextImpl = this;
        NamingContextImpl.doUnbind(namingContextImpl, nameComponentArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list(int n2, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) {
        NamingContextImpl namingContextImpl;
        NamingContextImpl namingContextImpl2 = namingContextImpl = this;
        synchronized (namingContextImpl2) {
            namingContextImpl.List(n2, bindingListHolder, bindingIteratorHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NamingContext new_context() {
        NamingContextImpl namingContextImpl;
        NamingContextImpl namingContextImpl2 = namingContextImpl = this;
        synchronized (namingContextImpl2) {
            return namingContextImpl.NewContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingContext bind_new_context(NameComponent[] nameComponentArray) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        NamingContext namingContext = null;
        NamingContext namingContext2 = null;
        try {
            namingContext = this.new_context();
            this.bind_context(nameComponentArray, namingContext);
            namingContext2 = namingContext;
            namingContext = null;
            java.lang.Object var5_4 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var5_5 = null;
            try {
                if (namingContext != null) {
                    namingContext.destroy();
                }
            }
            catch (NotEmpty notEmpty) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (namingContext != null) {
                namingContext.destroy();
            }
        }
        catch (NotEmpty notEmpty) {}
        return namingContext2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws NotEmpty {
        NamingContextImpl namingContextImpl;
        NamingContextImpl namingContextImpl2 = namingContextImpl = this;
        synchronized (namingContextImpl2) {
            if (!namingContextImpl.IsEmpty()) {
                throw new NotEmpty();
            }
            namingContextImpl.Destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doBind(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray, Object object, boolean bl2, BindingType bindingType) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (nameComponentArray.length < 1) {
            throw new InvalidName();
        }
        if (nameComponentArray.length == 1) {
            if (nameComponentArray[0].id.length() == 0 && nameComponentArray[0].kind.length() == 0) {
                throw new InvalidName();
            }
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
                if (bl2) {
                    Object object2 = namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder);
                    if (object2 != null) {
                        if (bindingTypeHolder.value.value() == BindingType.nobject.value()) {
                            if (bindingType.value() == BindingType.ncontext.value()) {
                                throw new NotFound(NotFoundReason.not_context, nameComponentArray);
                            }
                        } else if (bindingType.value() == BindingType.nobject.value()) {
                            throw new NotFound(NotFoundReason.not_object, nameComponentArray);
                        }
                        namingContextDataStore.Unbind(nameComponentArray[0]);
                    }
                } else if (namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder) != null) {
                    throw new AlreadyBound();
                }
                namingContextDataStore.Bind(nameComponentArray[0], object, bindingType);
            }
        } else {
            NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray);
            NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
            System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
            switch (bindingType.value()) {
                case 0: {
                    if (bl2) {
                        namingContext.rebind(nameComponentArray2, object);
                        break;
                    }
                    namingContext.bind(nameComponentArray2, object);
                    break;
                }
                case 1: {
                    NamingContext namingContext2 = (NamingContext)object;
                    if (bl2) {
                        namingContext.rebind_context(nameComponentArray2, namingContext2);
                        break;
                    }
                    namingContext.bind_context(nameComponentArray2, namingContext2);
                    break;
                }
                default: {
                    throw new INTERNAL(1398080090, CompletionStatus.COMPLETED_NO);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doResolve(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        Object object = null;
        BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
        if (nameComponentArray.length < 1) {
            throw new InvalidName();
        }
        if (nameComponentArray.length == 1) {
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                object = namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder);
            }
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            return object;
        }
        if (nameComponentArray[1].id.length() == 0 && nameComponentArray[1].kind.length() == 0) {
            throw new InvalidName();
        }
        NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray);
        NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
        System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
        return namingContext.resolve(nameComponentArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doUnbind(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        if (nameComponentArray.length < 1) {
            throw new InvalidName();
        }
        if (nameComponentArray.length == 1) {
            if (nameComponentArray[0].id.length() == 0 && nameComponentArray[0].kind.length() == 0) {
                throw new InvalidName();
            }
            Object object = null;
            NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
            synchronized (namingContextDataStore2) {
                object = namingContextDataStore.Unbind(nameComponentArray[0]);
            }
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            return;
        }
        NamingContext namingContext = NamingContextImpl.resolveFirstAsContext(namingContextDataStore, nameComponentArray);
        NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
        System.arraycopy(nameComponentArray, 1, nameComponentArray2, 0, nameComponentArray.length - 1);
        namingContext.unbind(nameComponentArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static NamingContext resolveFirstAsContext(NamingContextDataStore namingContextDataStore, NameComponent[] nameComponentArray) throws NotFound {
        Object object = null;
        BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
        NamingContext namingContext = null;
        NamingContextDataStore namingContextDataStore2 = namingContextDataStore;
        synchronized (namingContextDataStore2) {
            object = namingContextDataStore.Resolve(nameComponentArray[0], bindingTypeHolder);
            if (object == null) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
        }
        if (bindingTypeHolder.value != BindingType.ncontext) {
            throw new NotFound(NotFoundReason.not_context, nameComponentArray);
        }
        try {
            namingContext = NamingContextHelper.narrow(object);
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new NotFound(NotFoundReason.not_context, nameComponentArray);
        }
        return namingContext;
    }

    public static String nameToString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer("{");
        if (nameComponentArray != null || nameComponentArray.length > 0) {
            int n2 = 0;
            while (n2 < nameComponentArray.length) {
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("[").append(nameComponentArray[n2].id).append(",").append(nameComponentArray[n2].kind).append("]");
                ++n2;
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static void dprint(String string) {
        NamingUtils.dprint("NamingContextImpl(" + Thread.currentThread().getName() + " at " + System.currentTimeMillis() + " ems): " + string);
    }

    public void Bind(NameComponent nameComponent, Object object, BindingType bindingType) throws SystemException {
        if (object == null) {
            return;
        }
        InternalBindingKey internalBindingKey = new InternalBindingKey(nameComponent);
        try {
            java.lang.Object object2;
            InternalBindingValue internalBindingValue;
            if (bindingType.value() == 0) {
                internalBindingValue = new InternalBindingValue(bindingType, this.orb.object_to_string(object));
                internalBindingValue.setObjectRef(object);
            } else {
                object2 = this.theNameServiceHandle.getObjectKey(object);
                internalBindingValue = new InternalBindingValue(bindingType, (String)object2);
                internalBindingValue.setObjectRef(object);
            }
            object2 = (InternalBindingValue)this.theHashtable.put(internalBindingKey, internalBindingValue);
            if (object2 != null) {
                throw new INTERNAL(1398080088, CompletionStatus.COMPLETED_NO);
            }
            try {
                this.theServantManagerImplHandle.updateContext(this.objKey, this);
            }
            catch (Exception exception) {
                throw new UNKNOWN(3, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        catch (Exception exception) {
            throw new UNKNOWN(3, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public Object Resolve(NameComponent nameComponent, BindingTypeHolder bindingTypeHolder) throws SystemException {
        Object object;
        block7: {
            if (nameComponent.id.length() == 0 && nameComponent.kind.length() == 0) {
                bindingTypeHolder.value = BindingType.ncontext;
                return this.theNameServiceHandle.getObjectReferenceFromKey(this.objKey);
            }
            InternalBindingKey internalBindingKey = new InternalBindingKey(nameComponent);
            InternalBindingValue internalBindingValue = (InternalBindingValue)this.theHashtable.get(internalBindingKey);
            if (internalBindingValue == null) {
                return null;
            }
            object = null;
            bindingTypeHolder.value = internalBindingValue.theBindingType;
            try {
                if (internalBindingValue.strObjectRef.startsWith("NC")) {
                    bindingTypeHolder.value = BindingType.ncontext;
                    return this.theNameServiceHandle.getObjectReferenceFromKey(internalBindingValue.strObjectRef);
                }
                object = internalBindingValue.getObjectRef();
                if (object != null) break block7;
                try {
                    object = this.orb.string_to_object(internalBindingValue.strObjectRef);
                    internalBindingValue.setObjectRef(object);
                }
                catch (Exception exception) {
                    throw new UNKNOWN(3, CompletionStatus.COMPLETED_MAYBE);
                }
            }
            catch (Exception exception) {
                throw new UNKNOWN(3, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return object;
    }

    public Object Unbind(NameComponent nameComponent) throws SystemException {
        try {
            InternalBindingKey internalBindingKey = new InternalBindingKey(nameComponent);
            InternalBindingValue internalBindingValue = null;
            try {
                internalBindingValue = (InternalBindingValue)this.theHashtable.remove(internalBindingKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.theServantManagerImplHandle.updateContext(this.objKey, this);
            if (internalBindingValue == null) {
                return null;
            }
            if (internalBindingValue.strObjectRef.startsWith("NC")) {
                this.theServantManagerImplHandle.readInContext(internalBindingValue.strObjectRef);
                Object object = this.theNameServiceHandle.getObjectReferenceFromKey(internalBindingValue.strObjectRef);
                return object;
            }
            Object object = internalBindingValue.getObjectRef();
            if (object == null) {
                object = this.orb.string_to_object(internalBindingValue.strObjectRef);
            }
            return object;
        }
        catch (Exception exception) {
            throw new UNKNOWN(3, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void List(int n2, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) throws SystemException {
        if (biPOA == null) {
            this.createbiPOA();
        }
        try {
            BindingIterator bindingIterator;
            PersistentBindingIterator persistentBindingIterator = new PersistentBindingIterator(this.orb, (Hashtable)this.theHashtable.clone(), biPOA);
            persistentBindingIterator.list(n2, bindingListHolder);
            byte[] byArray = biPOA.activate_object(persistentBindingIterator);
            Object object = biPOA.id_to_reference(byArray);
            bindingIteratorHolder.value = bindingIterator = BindingIteratorHelper.narrow(object);
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (Exception exception) {
            throw new INTERNAL(1398080189, CompletionStatus.COMPLETED_NO);
        }
    }

    private synchronized void createbiPOA() {
        if (biPOA != null) {
            return;
        }
        try {
            POA pOA = (POA)this.orb.resolve_initial_references("RootPOA");
            pOA.the_POAManager().activate();
            int n2 = 0;
            Policy[] policyArray = new Policy[3];
            policyArray[n2++] = pOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT);
            policyArray[n2++] = pOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID);
            policyArray[n2++] = pOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN);
            biPOA = pOA.create_POA("BindingIteratorPOA", null, policyArray);
            biPOA.the_POAManager().activate();
        }
        catch (Exception exception) {
            throw new INTERNAL("Exception While Creating Binding Iterator POA");
        }
    }

    public NamingContext NewContext() throws SystemException {
        try {
            return this.theNameServiceHandle.NewContext();
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (Exception exception) {
            throw new INTERNAL(1398080190, CompletionStatus.COMPLETED_NO);
        }
    }

    public void Destroy() throws SystemException {
    }

    public String to_string(NameComponent[] nameComponentArray) throws InvalidName {
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        String string = this.getINSImpl().convertToString(nameComponentArray);
        if (string == null) {
            throw new InvalidName();
        }
        return string;
    }

    public NameComponent[] to_name(String string) throws InvalidName {
        if (string == null || string.length() == 0) {
            throw new InvalidName();
        }
        NameComponent[] nameComponentArray = this.getINSImpl().convertToNameComponent(string);
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        int n2 = 0;
        while (n2 < nameComponentArray.length) {
            if (!(nameComponentArray[n2].id != null && nameComponentArray[n2].id.length() != 0 || nameComponentArray[n2].kind != null && nameComponentArray[n2].kind.length() != 0)) {
                throw new InvalidName();
            }
            ++n2;
        }
        return nameComponentArray;
    }

    public String to_url(String string, String string2) throws InvalidAddress, InvalidName {
        if (string2 == null || string2.length() == 0) {
            throw new InvalidName();
        }
        if (string == null) {
            throw new InvalidAddress();
        }
        String string3 = null;
        try {
            string3 = this.getINSImpl().createURLBasedAddress(string, string2);
        }
        catch (Exception exception) {
            string3 = null;
        }
        CorbaName corbaName = null;
        try {
            corbaName = this.orb.getInitialNamingClient().checkcorbanameGrammer(string3);
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new InvalidAddress();
        }
        if (corbaName == null) {
            throw new InvalidName();
        }
        return string3;
    }

    public Object resolve_str(String string) throws NotFound, CannotProceed, InvalidName {
        Object object = null;
        if (string == null || string.length() == 0) {
            throw new InvalidName();
        }
        NameComponent[] nameComponentArray = this.getINSImpl().convertToNameComponent(string);
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        object = this.resolve(nameComponentArray);
        return object;
    }

    public boolean IsEmpty() {
        return this.theHashtable.isEmpty();
    }

    public void printSize() {
        System.out.println("Hashtable Size = " + this.theHashtable.size());
        Enumeration enumeration = this.theHashtable.keys();
        while (enumeration.hasMoreElements()) {
            InternalBindingValue internalBindingValue = (InternalBindingValue)this.theHashtable.get(enumeration.nextElement());
            if (internalBindingValue == null) continue;
            System.out.println("value = " + internalBindingValue.strObjectRef);
        }
    }
}

