/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsContext;
import com.sun.jndi.dns.DnsUrl;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import sun.net.dns.ResolverConfiguration;

public class DnsContextFactory
implements InitialContextFactory {
    private static final String DEFAULT_URL = "dns:";

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        if (hashtable == null) {
            hashtable = new Hashtable(5);
        }
        return DnsContextFactory.urlToContext(DnsContextFactory.getInitCtxUrl(hashtable), hashtable);
    }

    public static Context getContext(String string, String[] stringArray, Hashtable hashtable) throws NamingException {
        return new DnsContext(string, stringArray, hashtable);
    }

    public static Context getContext(String string, DnsUrl[] dnsUrlArray, Hashtable hashtable) throws NamingException {
        return new DnsContext(string, DnsContextFactory.serversForUrls(dnsUrlArray), hashtable);
    }

    public static boolean platformServersAvailable() {
        return !ResolverConfiguration.open().nameservers().isEmpty();
    }

    private static Context urlToContext(String string, Hashtable hashtable) throws NamingException {
        DnsUrl[] dnsUrlArray;
        try {
            dnsUrlArray = DnsUrl.fromList(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException(malformedURLException.getMessage());
        }
        if (dnsUrlArray.length == 0) {
            throw new ConfigurationException("Invalid DNS pseudo-URL(s): " + string);
        }
        String string2 = dnsUrlArray[0].getDomain();
        int n2 = 1;
        while (n2 < dnsUrlArray.length) {
            if (!string2.equalsIgnoreCase(dnsUrlArray[n2].getDomain())) {
                throw new ConfigurationException("Conflicting domains: " + string);
            }
            ++n2;
        }
        return DnsContextFactory.getContext(string2, DnsContextFactory.serversForUrls(dnsUrlArray), hashtable);
    }

    private static String[] serversForUrls(DnsUrl[] dnsUrlArray) throws NamingException {
        if (dnsUrlArray.length == 0) {
            throw new ConfigurationException("DNS pseudo-URL required");
        }
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < dnsUrlArray.length) {
            List list;
            String string = dnsUrlArray[n2].getHost();
            int n3 = dnsUrlArray[n2].getPort();
            if (string == null && n3 < 0 && !(list = ResolverConfiguration.open().nameservers()).isEmpty()) {
                arrayList.addAll(list);
            } else {
                if (string == null) {
                    string = "localhost";
                }
                arrayList.add(n3 < 0 ? string : string + ":" + n3);
            }
            ++n2;
        }
        return (String[])arrayList.toArray(new String[arrayList.size()]);
    }

    private static String getInitCtxUrl(Hashtable hashtable) {
        String string = (String)hashtable.get("java.naming.provider.url");
        return string != null ? string : DEFAULT_URL;
    }
}

