/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import java.io.OutputStream;
import java.util.Arrays;
import javax.naming.ldap.Control;

class ClientId {
    private final int version;
    private final String hostname;
    private final int port;
    private final String protocol;
    private final Control[] bindCtls;
    private final OutputStream trace;
    private final int myHash;
    private final int ctlHash;

    ClientId(int n2, String string, int n3, String string2, Control[] controlArray, OutputStream outputStream) {
        this.version = n2;
        this.hostname = string.toLowerCase();
        this.port = n3;
        this.protocol = string2;
        this.bindCtls = controlArray != null ? (Control[])controlArray.clone() : null;
        this.trace = outputStream;
        this.ctlHash = ClientId.hashCodeControls(controlArray);
        this.myHash = n2 + n3 + (outputStream != null ? outputStream.hashCode() : 0) + (this.hostname != null ? this.hostname.hashCode() : 0) + (string2 != null ? string2.hashCode() : 0) + this.ctlHash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClientId)) {
            return false;
        }
        ClientId clientId = (ClientId)object;
        return this.myHash == clientId.myHash && this.version == clientId.version && this.port == clientId.port && this.trace == clientId.trace && (this.hostname == clientId.hostname || this.hostname != null && this.hostname.equals(clientId.hostname)) && (this.protocol == clientId.protocol || this.protocol != null && this.protocol.equals(clientId.protocol)) && this.ctlHash == clientId.ctlHash && ClientId.equalsControls(this.bindCtls, clientId.bindCtls);
    }

    public int hashCode() {
        return this.myHash;
    }

    private static int hashCodeControls(Control[] controlArray) {
        if (controlArray == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < controlArray.length) {
            n2 = n2 * 31 + controlArray[n3].getID().hashCode();
            ++n3;
        }
        return n2;
    }

    private static boolean equalsControls(Control[] controlArray, Control[] controlArray2) {
        if (controlArray == controlArray2) {
            return true;
        }
        if (controlArray == null || controlArray2 == null) {
            return false;
        }
        if (controlArray.length != controlArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < controlArray.length) {
            if (!controlArray[n2].getID().equals(controlArray2[n2].getID()) || controlArray[n2].isCritical() != controlArray2[n2].isCritical() || !Arrays.equals(controlArray[n2].getEncodedValue(), controlArray2[n2].getEncodedValue())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static String toStringControls(Control[] controlArray) {
        if (controlArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < controlArray.length) {
            stringBuffer.append(controlArray[n2].getID());
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.hostname + ":" + this.port + ":" + (this.protocol != null ? this.protocol : "") + ":" + ClientId.toStringControls(this.bindCtls);
    }
}

