/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import com.sun.security.auth.PolicyParser;
import com.sun.security.auth.PolicyPermissions;
import com.sun.security.auth.SubjectCodeSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.IdentityScope;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.Subject;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

public class PolicyFile
extends Policy {
    static final ResourceBundle rb = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });
    private static final Debug debug = Debug.getInstance("policy", "\t[Auth Policy]");
    private static final String AUTH_POLICY = "java.security.auth.policy";
    private static final String SECURITY_MANAGER = "java.security.manager";
    private static final String AUTH_POLICY_URL = "auth.policy.url.";
    private Vector policyEntries;
    private Hashtable aliasMapping;
    private boolean initialized = false;
    private boolean expandProperties = true;
    private boolean ignoreIdentityScope = false;
    private static final Class[] PARAMS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PolicyFile.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PolicyFile.class$("java.lang.String")) : class$java$lang$String};
    private static IdentityScope scope = null;
    static /* synthetic */ Class class$java$lang$String;

    public PolicyFile() {
        String string = System.getProperty(AUTH_POLICY);
        if (string == null) {
            string = System.getProperty(SECURITY_MANAGER);
        }
        if (string != null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.policyEntries = new Vector();
        this.aliasMapping = new Hashtable(11);
        this.initPolicyFile();
        this.initialized = true;
    }

    public synchronized void refresh() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("refreshPolicy"));
        }
        this.initialized = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PolicyFile.this.init();
                return null;
            }
        });
    }

    private KeyStore initKeyStore(URL uRL, String string, String string2) {
        if (string != null) {
            try {
                URL uRL2 = null;
                try {
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL2 = new URL(uRL, string);
                }
                if (debug != null) {
                    debug.println("reading keystore" + uRL2);
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getInputStream(uRL2));
                KeyStore keyStore = string2 != null ? KeyStore.getInstance(string2) : KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(bufferedInputStream, null);
                ((InputStream)bufferedInputStream).close();
                return keyStore;
            }
            catch (Exception exception) {
                if (debug != null) {
                    exception.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    private void initPolicyFile() {
        Object object;
        boolean bl2;
        String string;
        String string2;
        String string3;
        String string4 = Security.getProperty("policy.expandProperties");
        if (string4 != null) {
            this.expandProperties = string4.equalsIgnoreCase("true");
        }
        if ((string3 = Security.getProperty("policy.ignoreIdentityScope")) != null) {
            this.ignoreIdentityScope = string3.equalsIgnoreCase("true");
        }
        if ((string2 = Security.getProperty("policy.allowSystemProperty")) != null && string2.equalsIgnoreCase("true") && (string = System.getProperty(AUTH_POLICY)) != null) {
            block14: {
                bl2 = false;
                if (string.startsWith("=")) {
                    bl2 = true;
                    string = string.substring(1);
                }
                try {
                    string = PropertyExpander.expand(string);
                    File file = new File(string);
                    object = file.exists() ? new URL("file:" + file.getCanonicalPath()) : new URL(string);
                    if (debug != null) {
                        debug.println("reading " + object);
                    }
                    this.init((URL)object);
                }
                catch (Exception exception) {
                    if (debug == null) break block14;
                    debug.println("caught exception: " + exception);
                }
            }
            if (bl2) {
                if (debug != null) {
                    debug.println("overriding other policies!");
                }
                return;
            }
        }
        int n2 = 1;
        bl2 = false;
        while ((object = Security.getProperty(AUTH_POLICY_URL + n2)) != null) {
            block15: {
                try {
                    object = PropertyExpander.expand((String)object).replace(File.separatorChar, '/');
                    if (debug != null) {
                        debug.println("reading " + (String)object);
                    }
                    this.init(new URL((String)object));
                    bl2 = true;
                }
                catch (Exception exception) {
                    if (debug == null) break block15;
                    debug.println("error reading policy " + exception);
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        if (!bl2) {
            // empty if block
        }
    }

    private boolean checkForTrustedIdentity(Certificate certificate) {
        return false;
    }

    private void init(URL uRL) {
        block5: {
            PolicyParser policyParser = new PolicyParser(this.expandProperties);
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.getInputStream(uRL));
                policyParser.read(inputStreamReader);
                inputStreamReader.close();
                KeyStore keyStore = this.initKeyStore(uRL, policyParser.getKeyStoreUrl(), policyParser.getKeyStoreType());
                Enumeration enumeration = policyParser.grantElements();
                while (enumeration.hasMoreElements()) {
                    PolicyParser.GrantEntry grantEntry = (PolicyParser.GrantEntry)enumeration.nextElement();
                    this.addGrantEntry(grantEntry, keyStore);
                }
            }
            catch (PolicyParser.ParsingException parsingException) {
                System.err.println(AUTH_POLICY + rb.getString(": error parsing ") + uRL);
                System.err.println(AUTH_POLICY + rb.getString(": ") + parsingException.getMessage());
                if (debug != null) {
                    parsingException.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (debug == null) break block5;
                debug.println("error parsing " + uRL);
                debug.println(exception.toString());
                exception.printStackTrace();
            }
        }
    }

    private InputStream getInputStream(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            return new FileInputStream(string);
        }
        return uRL.openStream();
    }

    CodeSource getCodeSource(PolicyParser.GrantEntry grantEntry, KeyStore keyStore) throws MalformedURLException {
        Certificate[] certificateArray = null;
        if (grantEntry.signedBy != null && (certificateArray = this.getCertificates(keyStore, grantEntry.signedBy)) == null) {
            if (debug != null) {
                debug.println(" no certs for alias " + grantEntry.signedBy + ", ignoring.");
            }
            return null;
        }
        URL uRL = grantEntry.codeBase != null ? new URL(grantEntry.codeBase) : null;
        if (grantEntry.principals == null || grantEntry.principals.size() == 0) {
            return this.canonicalizeCodebase(new CodeSource(uRL, certificateArray), false);
        }
        return this.canonicalizeCodebase(new SubjectCodeSource(null, grantEntry.principals, uRL, certificateArray), false);
    }

    private void addGrantEntry(PolicyParser.GrantEntry grantEntry, KeyStore keyStore) {
        Object object;
        Object object2;
        if (debug != null) {
            debug.println("Adding policy entry: ");
            debug.println("  signedBy " + grantEntry.signedBy);
            debug.println("  codeBase " + grantEntry.codeBase);
            if (grantEntry.principals != null && grantEntry.principals.size() > 0) {
                object2 = grantEntry.principals.listIterator();
                while (object2.hasNext()) {
                    object = (PolicyParser.PrincipalEntry)object2.next();
                    debug.println("  " + ((PolicyParser.PrincipalEntry)object).principalClass + " " + ((PolicyParser.PrincipalEntry)object).principalName);
                }
            }
            debug.println();
        }
        try {
            object2 = this.getCodeSource(grantEntry, keyStore);
            if (object2 == null) {
                return;
            }
            object = new PolicyEntry((CodeSource)object2);
            Enumeration enumeration = grantEntry.permissionElements();
            while (enumeration.hasMoreElements()) {
                PolicyParser.PermissionEntry permissionEntry = (PolicyParser.PermissionEntry)enumeration.nextElement();
                try {
                    Permission permission = permissionEntry.permission.equals("javax.security.auth.PrivateCredentialPermission") && permissionEntry.name.endsWith(" self") ? PolicyFile.getInstance(permissionEntry.permission, permissionEntry.name + " \"self\"", permissionEntry.action) : PolicyFile.getInstance(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
                    ((PolicyEntry)object).add(permission);
                    if (debug == null) continue;
                    debug.println("  " + permission);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Certificate[] certificateArray = permissionEntry.signedBy != null ? this.getCertificates(keyStore, permissionEntry.signedBy) : null;
                    if (certificateArray == null && permissionEntry.signedBy != null) continue;
                    UnresolvedPermission unresolvedPermission = new UnresolvedPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action, certificateArray);
                    ((PolicyEntry)object).add(unresolvedPermission);
                    if (debug == null) continue;
                    debug.println("  " + unresolvedPermission);
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println(AUTH_POLICY + rb.getString(": error adding Permission ") + permissionEntry.permission + rb.getString(" ") + invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    System.err.println(AUTH_POLICY + rb.getString(": error adding Permission ") + permissionEntry.permission + rb.getString(" ") + exception);
                }
            }
            this.policyEntries.addElement(object);
        }
        catch (Exception exception) {
            System.err.println(AUTH_POLICY + rb.getString(": error adding Entry ") + grantEntry + rb.getString(" ") + exception);
        }
        if (debug != null) {
            debug.println();
        }
    }

    private static final Permission getInstance(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class clazz = Class.forName(string);
        Constructor constructor = clazz.getConstructor(PARAMS);
        return (Permission)constructor.newInstance(new Object[]{string2, string3});
    }

    Certificate[] getCertificates(KeyStore keyStore, String string) {
        Object[] objectArray;
        Vector vector = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken().trim();
            ++n2;
            Certificate certificate = null;
            certificate = (Certificate)this.aliasMapping.get(objectArray);
            if (certificate == null && keyStore != null) {
                try {
                    certificate = keyStore.getCertificate((String)objectArray);
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                if (certificate != null) {
                    this.aliasMapping.put(objectArray, certificate);
                    this.aliasMapping.put(certificate, objectArray);
                }
            }
            if (certificate == null) continue;
            if (vector == null) {
                vector = new Vector();
            }
            vector.addElement(certificate);
        }
        if (vector != null && n2 == vector.size()) {
            objectArray = new Certificate[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private final synchronized Enumeration elements() {
        return this.policyEntries.elements();
    }

    public PermissionCollection getPermissions(final Subject subject, final CodeSource codeSource) {
        return (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SubjectCodeSource subjectCodeSource = new SubjectCodeSource(subject, null, codeSource == null ? null : codeSource.getLocation(), codeSource == null ? null : codeSource.getCertificates());
                if (PolicyFile.this.initialized) {
                    return PolicyFile.this.getPermissions(new Permissions(), (CodeSource)subjectCodeSource);
                }
                return new PolicyPermissions(PolicyFile.this, subjectCodeSource);
            }
        });
    }

    PermissionCollection getPermissions(CodeSource codeSource) {
        if (this.initialized) {
            return this.getPermissions(new Permissions(), codeSource);
        }
        return new PolicyPermissions(this, codeSource);
    }

    Permissions getPermissions(Permissions permissions, CodeSource codeSource) {
        int n2;
        Certificate[] certificateArray;
        if (!this.initialized) {
            this.init();
        }
        CodeSource[] codeSourceArray = new CodeSource[]{null};
        codeSourceArray[0] = this.canonicalizeCodebase(codeSource, true);
        if (debug != null) {
            debug.println("evaluate(" + codeSourceArray[0] + ")\n");
        }
        int n3 = 0;
        while (n3 < this.policyEntries.size()) {
            certificateArray = (Certificate[])this.policyEntries.elementAt(n3);
            if (debug != null) {
                debug.println("PolicyFile CodeSource implies: " + certificateArray.codesource.toString() + "\n\n" + "\t" + codeSourceArray[0].toString() + "\n\n");
            }
            if (certificateArray.codesource.implies(codeSourceArray[0])) {
                n2 = 0;
                while (n2 < certificateArray.permissions.size()) {
                    Permission permission = (Permission)certificateArray.permissions.elementAt(n2);
                    if (debug != null) {
                        debug.println("  granting " + permission);
                    }
                    if (!this.addSelfPermissions(permission, certificateArray.codesource, codeSourceArray[0], permissions)) {
                        permissions.add(permission);
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        if (!this.ignoreIdentityScope && (certificateArray = codeSourceArray[0].getCertificates()) != null) {
            n2 = 0;
            while (n2 < certificateArray.length) {
                if (this.aliasMapping.get(certificateArray[n2]) == null && this.checkForTrustedIdentity(certificateArray[n2])) {
                    permissions.add(new AllPermission());
                }
                ++n2;
            }
        }
        return permissions;
    }

    private boolean addSelfPermissions(Permission permission, CodeSource codeSource, CodeSource codeSource2, Permissions permissions) {
        if (!(permission instanceof PrivateCredentialPermission)) {
            return false;
        }
        if (!(codeSource instanceof SubjectCodeSource)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)permission;
        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
        String[][] stringArray = privateCredentialPermission.getPrincipals();
        if (stringArray.length <= 0 || !stringArray[0][0].equalsIgnoreCase("self") || !stringArray[0][1].equalsIgnoreCase("self")) {
            return false;
        }
        if (subjectCodeSource.getPrincipals() == null) {
            return true;
        }
        ListIterator listIterator = subjectCodeSource.getPrincipals().listIterator();
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)listIterator.next();
            String[][] stringArray2 = this.getPrincipalInfo(principalEntry, codeSource2);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                PrivateCredentialPermission privateCredentialPermission2 = new PrivateCredentialPermission(privateCredentialPermission.getCredentialClass() + " " + stringArray2[n2][0] + " " + "\"" + stringArray2[n2][1] + "\"", "read");
                if (debug != null) {
                    debug.println("adding SELF permission: " + privateCredentialPermission2.toString());
                }
                permissions.add(privateCredentialPermission2);
                ++n2;
            }
        }
        return true;
    }

    private String[][] getPrincipalInfo(PolicyParser.PrincipalEntry principalEntry, CodeSource codeSource) {
        if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            String[][] stringArray = new String[1][2];
            stringArray[0][0] = principalEntry.principalClass;
            stringArray[0][1] = principalEntry.principalName;
            return stringArray;
        }
        if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            String[][] stringArray;
            Set set;
            block7: {
                SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
                set = null;
                try {
                    stringArray = Class.forName(principalEntry.principalClass, false, ClassLoader.getSystemClassLoader());
                    set = subjectCodeSource.getSubject().getPrincipals((Class)stringArray);
                }
                catch (Exception exception) {
                    if (debug == null) break block7;
                    debug.println("problem finding Principal Class when expanding SELF permission: " + exception.toString());
                }
            }
            if (set == null) {
                return new String[0][0];
            }
            stringArray = new String[set.size()][2];
            Iterator iterator = set.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Principal principal = (Principal)iterator.next();
                stringArray[n2][0] = principal.getClass().getName();
                stringArray[n2][1] = principal.getName();
                ++n2;
            }
            return stringArray;
        }
        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
        Set set = subjectCodeSource.getSubject().getPrincipals();
        String[][] stringArray = new String[set.size()][2];
        Iterator iterator = set.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            stringArray[n3][0] = principal.getClass().getName();
            stringArray[n3][1] = principal.getName();
            ++n3;
        }
        return stringArray;
    }

    Certificate[] getSignerCertificates(CodeSource codeSource) {
        Certificate[] certificateArray = null;
        certificateArray = codeSource.getCertificates();
        if (certificateArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < certificateArray.length) {
            if (!(certificateArray[n2] instanceof X509Certificate)) {
                return codeSource.getCertificates();
            }
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < certificateArray.length) {
            ++n4;
            while (n3 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n3]).getIssuerDN().equals(((X509Certificate)certificateArray[n3 + 1]).getSubjectDN())) {
                ++n3;
            }
            ++n3;
        }
        if (n4 == certificateArray.length) {
            return certificateArray;
        }
        ArrayList arrayList = new ArrayList();
        n3 = 0;
        while (n3 < certificateArray.length) {
            arrayList.add(certificateArray[n3]);
            while (n3 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n3]).getIssuerDN().equals(((X509Certificate)certificateArray[n3 + 1]).getSubjectDN())) {
                ++n3;
            }
            ++n3;
        }
        Object[] objectArray = new Certificate[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private CodeSource canonicalizeCodebase(CodeSource codeSource, boolean bl2) {
        CodeSource codeSource2;
        block15: {
            codeSource2 = codeSource;
            if (codeSource.getLocation() != null && codeSource.getLocation().getProtocol().equalsIgnoreCase("file")) {
                try {
                    String string = codeSource.getLocation().getFile().replace('/', File.separatorChar);
                    URL uRL = null;
                    if (string.endsWith("*")) {
                        string = string.substring(0, string.length() - 1);
                        boolean bl3 = false;
                        if (string.endsWith(File.separator)) {
                            bl3 = true;
                        }
                        if (string.equals("")) {
                            string = System.getProperty("user.dir");
                        }
                        File file = new File(string);
                        string = file.getCanonicalPath();
                        StringBuffer stringBuffer = new StringBuffer(string);
                        if (!string.endsWith(File.separator) && (bl3 || file.isDirectory())) {
                            stringBuffer.append(File.separatorChar);
                        }
                        stringBuffer.append('*');
                        string = stringBuffer.toString();
                    } else {
                        string = new File(string).getCanonicalPath();
                    }
                    uRL = new File(string).toURL();
                    if (codeSource instanceof SubjectCodeSource) {
                        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
                        codeSource2 = bl2 ? new SubjectCodeSource(subjectCodeSource.getSubject(), subjectCodeSource.getPrincipals(), uRL, this.getSignerCertificates(subjectCodeSource)) : new SubjectCodeSource(subjectCodeSource.getSubject(), subjectCodeSource.getPrincipals(), uRL, subjectCodeSource.getCertificates());
                        break block15;
                    }
                    if (bl2) {
                        codeSource2 = new CodeSource(uRL, this.getSignerCertificates(codeSource));
                        break block15;
                    }
                    codeSource2 = new CodeSource(uRL, codeSource.getCertificates());
                }
                catch (IOException iOException) {
                    if (!bl2) break block15;
                    if (!(codeSource instanceof SubjectCodeSource)) {
                        codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
                        break block15;
                    }
                    SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
                    codeSource2 = new SubjectCodeSource(subjectCodeSource.getSubject(), subjectCodeSource.getPrincipals(), subjectCodeSource.getLocation(), this.getSignerCertificates(subjectCodeSource));
                }
            } else if (bl2) {
                if (!(codeSource instanceof SubjectCodeSource)) {
                    codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
                } else {
                    SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
                    codeSource2 = new SubjectCodeSource(subjectCodeSource.getSubject(), subjectCodeSource.getPrincipals(), subjectCodeSource.getLocation(), this.getSignerCertificates(subjectCodeSource));
                }
            }
        }
        return codeSource2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PolicyEntry {
        CodeSource codesource;
        Vector permissions;

        PolicyEntry(CodeSource codeSource) {
            this.codesource = codeSource;
            this.permissions = new Vector();
        }

        void add(Permission permission) {
            this.permissions.addElement(permission);
        }

        CodeSource getCodeSource() {
            return this.codesource;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(rb.getString("("));
            stringBuffer.append(this.getCodeSource());
            stringBuffer.append("\n");
            int n2 = 0;
            while (n2 < this.permissions.size()) {
                Permission permission = (Permission)this.permissions.elementAt(n2);
                stringBuffer.append(rb.getString(" "));
                stringBuffer.append(rb.getString(" "));
                stringBuffer.append(permission);
                stringBuffer.append(rb.getString("\n"));
                ++n2;
            }
            stringBuffer.append(rb.getString(")"));
            stringBuffer.append(rb.getString("\n"));
            return stringBuffer.toString();
        }
    }
}

