/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

class PlainDatagramSocketImpl
extends DatagramSocketImpl {
    private int timeout = 0;
    private int trafficClass = 0;
    private boolean connected = false;
    private InetAddress connectedAddress = null;
    private int connectedPort = -1;
    private int multicastInterface = 0;
    private boolean loopbackMode = true;
    private int ttl = -1;

    PlainDatagramSocketImpl() {
    }

    protected synchronized void create() throws SocketException {
        this.fd = new FileDescriptor();
        this.datagramSocketCreate();
    }

    protected synchronized native void bind(int var1, InetAddress var2) throws SocketException;

    protected native void send(DatagramPacket var1) throws IOException;

    protected void connect(InetAddress inetAddress, int n2) throws SocketException {
        this.connect0(inetAddress, n2);
        this.connectedAddress = inetAddress;
        this.connectedPort = n2;
        this.connected = true;
    }

    protected void disconnect() {
        this.disconnect0();
        this.connected = false;
        this.connectedAddress = null;
        this.connectedPort = -1;
    }

    protected synchronized native int peek(InetAddress var1) throws IOException;

    protected synchronized native int peekData(DatagramPacket var1) throws IOException;

    protected synchronized native void receive(DatagramPacket var1) throws IOException;

    protected native void setTimeToLive(int var1) throws IOException;

    protected native int getTimeToLive() throws IOException;

    protected native void setTTL(byte var1) throws IOException;

    protected native byte getTTL() throws IOException;

    protected void join(InetAddress inetAddress) throws IOException {
        this.join(inetAddress, null);
    }

    protected void leave(InetAddress inetAddress) throws IOException {
        this.leave(inetAddress, null);
    }

    protected void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.join(((InetSocketAddress)socketAddress).getAddress(), networkInterface);
    }

    private native void join(InetAddress var1, NetworkInterface var2) throws IOException;

    protected void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.leave(((InetSocketAddress)socketAddress).getAddress(), networkInterface);
    }

    private native void leave(InetAddress var1, NetworkInterface var2) throws IOException;

    protected void close() {
        if (this.fd != null) {
            this.datagramSocketClose();
            this.fd = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void setOption(int n2, Object object) throws SocketException {
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        switch (n2) {
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for SO_TIMEOUT");
                }
                int n3 = (Integer)object;
                if (n3 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n3;
                return;
            }
            case 3: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for IP_TOS");
                }
                this.trafficClass = (Integer)object;
                break;
            }
            case 4: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for SO_REUSEADDR");
            }
            case 32: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for SO_BROADCAST");
            }
            case 15: {
                throw new SocketException("Cannot re-bind Socket");
            }
            case 4097: 
            case 4098: {
                if (object != null && object instanceof Integer && (Integer)object >= 0) break;
                throw new SocketException("bad argument for SO_SNDBUF or SO_RCVBUF");
            }
            case 16: {
                if (object != null && object instanceof InetAddress) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF");
            }
            case 31: {
                if (object != null && object instanceof NetworkInterface) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF2");
            }
            case 18: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for IP_MULTICAST_LOOP");
            }
            default: {
                throw new SocketException("invalid option: " + n2);
            }
        }
        this.socketSetOption(n2, object);
    }

    public Object getOption(int n2) throws SocketException {
        Object object;
        if (this.fd == null) {
            throw new SocketException("Socket Closed");
        }
        switch (n2) {
            case 4102: {
                object = new Integer(this.timeout);
                break;
            }
            case 3: {
                object = this.socketGetOption(n2);
                if ((Integer)object != -1) break;
                object = new Integer(this.trafficClass);
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 18: 
            case 31: 
            case 32: 
            case 4097: 
            case 4098: {
                object = this.socketGetOption(n2);
                break;
            }
            default: {
                throw new SocketException("invalid option: " + n2);
            }
        }
        return object;
    }

    private native void datagramSocketCreate() throws SocketException;

    private native void datagramSocketClose();

    private native void socketSetOption(int var1, Object var2) throws SocketException;

    private native Object socketGetOption(int var1) throws SocketException;

    private native void connect0(InetAddress var1, int var2) throws SocketException;

    private native void disconnect0();

    private static native void init();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        PlainDatagramSocketImpl.init();
    }
}

