/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;

public class LogManager {
    private static LogManager manager;
    private static final Handler[] emptyHandlers;
    private Properties props = new Properties();
    private PropertyChangeSupport changes = new PropertyChangeSupport(class$java$util$logging$LogManager == null ? (class$java$util$logging$LogManager = LogManager.class$("java.util.logging.LogManager")) : class$java$util$logging$LogManager);
    private static final Level defaultLevel;
    private Hashtable loggers = new Hashtable();
    private LogNode root = new LogNode(null);
    private Logger rootLogger;
    private boolean initializedGlobalHandlers = true;
    private boolean deathImminent;
    private Permission ourPermission = new LoggingPermission("control", null);
    static /* synthetic */ Class class$java$util$logging$LogManager;

    protected LogManager() {
        Runtime.getRuntime().addShutdownHook(new Cleaner());
    }

    public static LogManager getLogManager() {
        return manager;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
        this.checkAccess();
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
        this.checkAccess();
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized boolean addLogger(Logger logger) {
        Object object;
        Object object2;
        int n2;
        String string = logger.getName();
        if (string == null) {
            throw new NullPointerException();
        }
        Logger logger2 = (Logger)this.loggers.get(string);
        if (logger2 != null) {
            return false;
        }
        this.loggers.put(string, logger);
        Level level = this.getLevelProperty(string + ".level", null);
        if (level != null) {
            LogManager.doSetLevel(logger, level);
        }
        int n3 = 1;
        while ((n2 = string.indexOf(".", n3)) >= 0) {
            object2 = string.substring(0, n2);
            if (this.getProperty((String)object2 + ".level") != null) {
                object = Logger.getLogger((String)object2);
            }
            n3 = n2 + 1;
        }
        LogNode logNode = this.findNode(string);
        logNode.logger = logger;
        object2 = null;
        object = logNode.parent;
        while (object != null) {
            if (((LogNode)object).logger != null) {
                object2 = ((LogNode)object).logger;
                break;
            }
            object = ((LogNode)object).parent;
        }
        if (object2 != null) {
            LogManager.doSetParent(logger, (Logger)object2);
        }
        logNode.walkAndSetParent(logger);
        return true;
    }

    private static void doSetLevel(final Logger logger, final Level level) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            logger.setLevel(level);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setLevel(level);
                return null;
            }
        });
    }

    private static void doSetParent(final Logger logger, final Logger logger2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            logger.setParent(logger2);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setParent(logger2);
                return null;
            }
        });
    }

    private LogNode findNode(String string) {
        if (string == null || string.equals("")) {
            return this.root;
        }
        LogNode logNode = this.root;
        while (string.length() > 0) {
            LogNode logNode2;
            String string2;
            int n2 = string.indexOf(".");
            if (n2 > 0) {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1);
            } else {
                string2 = string;
                string = "";
            }
            if (logNode.children == null) {
                logNode.children = new HashMap();
            }
            if ((logNode2 = (LogNode)logNode.children.get(string2)) == null) {
                logNode2 = new LogNode(logNode);
                logNode.children.put(string2, logNode2);
            }
            logNode = logNode2;
        }
        return logNode;
    }

    public synchronized Logger getLogger(String string) {
        return (Logger)this.loggers.get(string);
    }

    public synchronized Enumeration getLoggerNames() {
        return this.loggers.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readConfiguration() throws IOException, SecurityException {
        Object object;
        String string;
        this.checkAccess();
        String string2 = System.getProperty("java.util.logging.config.class");
        if (string2 != null) {
            try {
                Class clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                clazz.newInstance();
                return;
            }
            catch (Exception exception) {
                System.err.println("Logging configuration class \"" + string2 + "\" failed");
                System.err.println("" + exception);
            }
        }
        if ((string = System.getProperty("java.util.logging.config.file")) == null) {
            string = System.getProperty("java.home");
            if (string == null) {
                throw new Error("Can't find java.home ??");
            }
            object = new File(string, "lib");
            object = new File((File)object, "logging.properties");
            string = ((File)object).getCanonicalPath();
        }
        object = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
        try {
            this.readConfiguration(bufferedInputStream);
            Object var6_7 = null;
            if (object == null) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (object == null) throw throwable;
            ((InputStream)object).close();
            throw throwable;
        }
        ((InputStream)object).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SecurityException {
        this.checkAccess();
        LogManager logManager = this;
        synchronized (logManager) {
            this.props = new Properties();
            this.initializedGlobalHandlers = true;
        }
        Enumeration enumeration = this.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.resetLogger(string);
        }
    }

    private void resetLogger(String string) {
        Logger logger = this.getLogger(string);
        if (logger == null) {
            return;
        }
        Handler[] handlerArray = logger.getHandlers();
        int n2 = 0;
        while (n2 < handlerArray.length) {
            Handler handler = handlerArray[n2];
            logger.removeHandler(handler);
            try {
                handler.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        if (string != null && string.equals("")) {
            logger.setLevel(defaultLevel);
        } else {
            logger.setLevel(null);
        }
    }

    private String[] parseClassNames(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return new String[0];
        }
        string2 = string2.trim();
        int n2 = 0;
        Vector vector = new Vector();
        while (n2 < string2.length()) {
            int n3 = n2;
            while (n3 < string2.length()) {
                if (Character.isWhitespace(string2.charAt(n3)) || string2.charAt(n3) == ',') break;
                ++n3;
            }
            String string3 = string2.substring(n2, n3);
            n2 = n3 + 1;
            if ((string3 = string3.trim()).length() == 0) continue;
            vector.add(string3);
        }
        return (String[])vector.toArray(new String[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        Object object;
        this.checkAccess();
        this.reset();
        this.props.load(inputStream);
        String[] stringArray = this.parseClassNames("config");
        int n2 = 0;
        while (n2 < stringArray.length) {
            object = stringArray[n2];
            try {
                Class clazz = ClassLoader.getSystemClassLoader().loadClass((String)object);
                clazz.newInstance();
            }
            catch (Exception exception) {
                System.err.println("Can't load config class \"" + (String)object + "\"");
                System.err.println("" + exception);
            }
            ++n2;
        }
        this.setLevelsOnExistingLoggers();
        this.changes.firePropertyChange(null, null, null);
        object = this;
        synchronized (object) {
            this.initializedGlobalHandlers = false;
        }
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    String getStringProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3.trim();
    }

    int getIntProperty(String string, int n2) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (Exception exception) {
            return n2;
        }
    }

    boolean getBooleanProperty(String string, boolean bl2) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return bl2;
        }
        if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("1")) {
            return true;
        }
        if (string2.equals("false") || string2.equals("0")) {
            return false;
        }
        return bl2;
    }

    Level getLevelProperty(String string, Level level) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return level;
        }
        try {
            return Level.parse(string2.trim());
        }
        catch (Exception exception) {
            return level;
        }
    }

    Filter getFilterProperty(String string, Filter filter) {
        String string2 = this.getProperty(string);
        try {
            if (string2 != null) {
                Class clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Filter)clazz.newInstance();
            }
        }
        catch (Exception exception) {}
        return filter;
    }

    Formatter getFormatterProperty(String string, Formatter formatter) {
        String string2 = this.getProperty(string);
        try {
            if (string2 != null) {
                Class clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Formatter)clazz.newInstance();
            }
        }
        catch (Exception exception) {}
        return formatter;
    }

    private synchronized void initializeGlobalHandlers() {
        if (this.initializedGlobalHandlers) {
            return;
        }
        this.initializedGlobalHandlers = true;
        if (this.deathImminent) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] stringArray = LogManager.this.parseClassNames("handlers");
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string = stringArray[n2];
                    try {
                        Class clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                        Handler handler = (Handler)clazz.newInstance();
                        try {
                            String string2 = LogManager.this.getProperty(string + ".level");
                            if (string2 != null) {
                                handler.setLevel(Level.parse(string2));
                            }
                        }
                        catch (Exception exception) {
                            System.err.println("Can't set level for " + string);
                        }
                        LogManager.this.rootLogger.addHandler(handler);
                    }
                    catch (Exception exception) {
                        System.err.println("Can't load log handler \"" + string + "\"");
                        System.err.println("" + exception);
                        exception.printStackTrace();
                    }
                    ++n2;
                }
                return null;
            }
        });
    }

    public void checkAccess() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        securityManager.checkPermission(this.ourPermission);
    }

    private synchronized void setLevelsOnExistingLoggers() {
        Enumeration enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.endsWith(".level")) continue;
            int n2 = string.length() - 6;
            String string2 = string.substring(0, n2);
            Level level = this.getLevelProperty(string, null);
            if (level == null) {
                System.err.println("Bad level value for property: " + string);
                continue;
            }
            Logger logger = this.getLogger(string2);
            if (logger == null) continue;
            logger.setLevel(level);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        emptyHandlers = new Handler[0];
        defaultLevel = Level.INFO;
        String string = null;
        try {
            string = System.getProperty("java.util.logging.manager");
            if (string != null) {
                Class clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                manager = (LogManager)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("Could not load Logmanager \"" + string + "\"");
            exception.printStackTrace();
        }
        if (manager == null) {
            manager = new LogManager();
        }
        LogManager logManager = manager;
        logManager.getClass();
        LogManager.manager.rootLogger = logManager.new RootLogger();
        manager.addLogger(LogManager.manager.rootLogger);
    }

    private class RootLogger
    extends Logger {
        private RootLogger() {
            super("", null);
            this.setLevel(defaultLevel);
        }

        public void log(LogRecord logRecord) {
            LogManager.this.initializeGlobalHandlers();
            super.log(logRecord);
        }

        public void addHandler(Handler handler) {
            LogManager.this.initializeGlobalHandlers();
            super.addHandler(handler);
        }

        public void removeHandler(Handler handler) {
            LogManager.this.initializeGlobalHandlers();
            super.removeHandler(handler);
        }

        public Handler[] getHandlers() {
            LogManager.this.initializeGlobalHandlers();
            return super.getHandlers();
        }
    }

    private static class LogNode {
        HashMap children;
        Logger logger;
        LogNode parent;

        LogNode(LogNode logNode) {
            this.parent = logNode;
        }

        void walkAndSetParent(Logger logger) {
            if (this.children == null) {
                return;
            }
            Iterator iterator = this.children.values().iterator();
            while (iterator.hasNext()) {
                LogNode logNode = (LogNode)iterator.next();
                if (logNode.logger == null) {
                    logNode.walkAndSetParent(logger);
                    continue;
                }
                LogManager.doSetParent(logNode.logger, logger);
            }
        }
    }

    private class Cleaner
    extends Thread {
        private Cleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LogManager logManager = LogManager.this;
            synchronized (logManager) {
                LogManager.this.deathImminent = true;
                LogManager.this.initializedGlobalHandlers = true;
            }
            LogManager.this.reset();
        }
    }
}

