/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();
    private static final int GZIP_MAGIC = 35615;
    private static final int TRAILER_SIZE = 8;
    private static final byte[] header = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};

    public GZIPOutputStream(OutputStream outputStream, int n2) throws IOException {
        super(outputStream, new Deflater(-1, true), n2);
        this.usesDefaultDeflater = true;
        this.writeHeader();
        this.crc.reset();
    }

    public GZIPOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 512);
    }

    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        super.write(byArray, n2, n3);
        this.crc.update(byArray, n2, n3);
    }

    public void finish() throws IOException {
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                int n2 = this.def.deflate(this.buf, 0, this.buf.length);
                if (this.def.finished() && n2 <= this.buf.length - 8) {
                    this.writeTrailer(this.buf, n2);
                    this.out.write(this.buf, 0, n2 += 8);
                    return;
                }
                if (n2 <= 0) continue;
                this.out.write(this.buf, 0, n2);
            }
            byte[] byArray = new byte[8];
            this.writeTrailer(byArray, 0);
            this.out.write(byArray);
        }
    }

    private void writeHeader() throws IOException {
        this.out.write(header);
    }

    private void writeTrailer(byte[] byArray, int n2) throws IOException {
        this.writeInt((int)this.crc.getValue(), byArray, n2);
        this.writeInt(this.def.getTotalIn(), byArray, n2 + 4);
    }

    private void writeInt(int n2, byte[] byArray, int n3) throws IOException {
        this.writeShort(n2 & 0xFFFF, byArray, n3);
        this.writeShort(n2 >> 16 & 0xFFFF, byArray, n3 + 2);
    }

    private void writeShort(int n2, byte[] byArray, int n3) throws IOException {
        byArray[n3] = (byte)(n2 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >> 8 & 0xFF);
    }
}

