/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ComponentInputMap
extends InputMap {
    private JComponent component;

    public ComponentInputMap(JComponent jComponent) {
        this.component = jComponent;
        if (jComponent == null) {
            throw new IllegalArgumentException("ComponentInputMaps must be associated with a non-null JComponent");
        }
    }

    public void setParent(InputMap inputMap) {
        if (this.getParent() == inputMap) {
            return;
        }
        if (!(inputMap == null || inputMap instanceof ComponentInputMap && ((ComponentInputMap)inputMap).getComponent() == this.getComponent())) {
            throw new IllegalArgumentException("ComponentInputMaps must have a parent ComponentInputMap associated with the same component");
        }
        super.setParent(inputMap);
        this.getComponent().componentInputMapChanged(this);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void put(KeyStroke keyStroke, Object object) {
        super.put(keyStroke, object);
        if (this.getComponent() != null) {
            this.getComponent().componentInputMapChanged(this);
        }
    }

    public void remove(KeyStroke keyStroke) {
        super.remove(keyStroke);
        if (this.getComponent() != null) {
            this.getComponent().componentInputMapChanged(this);
        }
    }

    public void clear() {
        int n2 = this.size();
        super.clear();
        if (n2 > 0 && this.getComponent() != null) {
            this.getComponent().componentInputMapChanged(this);
        }
    }
}

