/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.text.InternationalFormatter;

public class BasicSpinnerUI
extends SpinnerUI {
    protected JSpinner spinner;
    private static final PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    private static final ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler("increment", true);
    private static final ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler("decrement", false);
    private static final Dimension zeroSize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSpinnerUI();
    }

    private void maybeAdd(Component component, String string) {
        if (component != null) {
            this.spinner.add(component, string);
        }
    }

    public void installUI(JComponent jComponent) {
        this.spinner = (JSpinner)jComponent;
        this.installDefaults();
        this.installListeners();
        this.maybeAdd(this.createNextButton(), "Next");
        this.maybeAdd(this.createPreviousButton(), "Previous");
        this.maybeAdd(this.createEditor(), "Editor");
        this.updateEnabledState();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.spinner = null;
        jComponent.removeAll();
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(propertyChangeListener);
    }

    protected void installDefaults() {
        this.spinner.setLayout(this.createLayout());
        LookAndFeel.installBorder(this.spinner, "Spinner.border");
        LookAndFeel.installColorsAndFont(this.spinner, "Spinner.background", "Spinner.foreground", "Spinner.font");
    }

    protected void uninstallDefaults() {
        this.spinner.setLayout(null);
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected Component createPreviousButton() {
        BasicArrowButton basicArrowButton = new BasicArrowButton(5);
        basicArrowButton.addActionListener(previousButtonHandler);
        basicArrowButton.addMouseListener(previousButtonHandler);
        return basicArrowButton;
    }

    protected Component createNextButton() {
        BasicArrowButton basicArrowButton = new BasicArrowButton(1);
        basicArrowButton.addActionListener(nextButtonHandler);
        basicArrowButton.addMouseListener(nextButtonHandler);
        return basicArrowButton;
    }

    protected JComponent createEditor() {
        return this.spinner.getEditor();
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private void updateEnabledState() {
        this.updateEnabledState(this.spinner, this.spinner.isEnabled());
    }

    private void updateEnabledState(Container container, boolean bl2) {
        int n2 = container.getComponentCount() - 1;
        while (n2 >= 0) {
            Component component = container.getComponent(n2);
            component.setEnabled(bl2);
            if (component instanceof Container) {
                this.updateEnabledState((Container)component, bl2);
            }
            --n2;
        }
    }

    private void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.spinner, 1, inputMap);
        SwingUtilities.replaceUIActionMap(this.spinner, this.getActionMap());
    }

    private InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)UIManager.get("Spinner.ancestorInputMap");
        }
        return null;
    }

    private ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Spinner.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Spinner.actionMap", actionMap);
        }
        return actionMap;
    }

    private ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("increment", nextButtonHandler);
        actionMapUIResource.put("decrement", previousButtonHandler);
        return actionMapUIResource;
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JSpinner jSpinner = (JSpinner)propertyChangeEvent.getSource();
            SpinnerUI spinnerUI = jSpinner.getUI();
            if (spinnerUI instanceof BasicSpinnerUI) {
                BasicSpinnerUI basicSpinnerUI = (BasicSpinnerUI)spinnerUI;
                if ("editor".equals(string)) {
                    JComponent jComponent = (JComponent)propertyChangeEvent.getOldValue();
                    JComponent jComponent2 = (JComponent)propertyChangeEvent.getNewValue();
                    basicSpinnerUI.replaceEditor(jComponent, jComponent2);
                    basicSpinnerUI.updateEnabledState();
                } else if ("enabled".equals(string)) {
                    basicSpinnerUI.updateEnabledState();
                }
            }
        }
    }

    private static class SpinnerLayout
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if ("Next".equals(string)) {
                this.nextButton = component;
            } else if ("Previous".equals(string)) {
                this.previousButton = component;
            } else if ("Editor".equals(string)) {
                this.editor = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (component == this.nextButton) {
                component = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            } else if (component == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component component) {
            return component == null ? zeroSize : component.getPreferredSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            Dimension dimension3 = this.preferredSize(this.editor);
            dimension3.height = (dimension3.height + 1) / 2 * 2;
            Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
            dimension4.width += Math.max(dimension.width, dimension2.width);
            Insets insets = container.getInsets();
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
            return dimension4;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private void setBounds(Component component, int n2, int n3, int n4, int n5) {
            if (component != null) {
                component.setBounds(n2, n3, n4, n5);
            }
        }

        public void layoutContainer(Container container) {
            int n2;
            int n3;
            Insets insets = container.getInsets();
            int n4 = container.getWidth() - (insets.left + insets.right);
            int n5 = container.getHeight() - (insets.top + insets.bottom);
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            int n6 = n5 / 2;
            int n7 = n5 - n6;
            int n8 = Math.max(dimension.width, dimension2.width);
            int n9 = n4 - n8;
            if (container.getComponentOrientation().isLeftToRight()) {
                n3 = insets.left;
                n2 = n3 + n9;
            } else {
                n2 = insets.left;
                n3 = n2 + n8;
            }
            int n10 = insets.top + n6;
            this.setBounds(this.editor, n3, insets.top, n9, n5);
            this.setBounds(this.nextButton, n2, insets.top, n8, n6);
            this.setBounds(this.previousButton, n2, n10, n8, n7);
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        ArrowButtonHandler(String string, boolean bl2) {
            super(string);
            this.isNext = bl2;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            while (object instanceof Component && !(object instanceof JSpinner)) {
                object = ((Component)object).getParent();
            }
            return object instanceof JSpinner ? (JSpinner)object : null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block6: {
                JSpinner jSpinner = this.spinner;
                if (!(actionEvent.getSource() instanceof Timer)) {
                    jSpinner = this.eventToSpinner(actionEvent);
                }
                if (jSpinner == null) break block6;
                try {
                    Object object;
                    int n2 = this.getCalendarField(jSpinner);
                    jSpinner.commitEdit();
                    if (n2 != -1) {
                        ((SpinnerDateModel)jSpinner.getModel()).setCalendarField(n2);
                    }
                    Object object2 = object = this.isNext ? jSpinner.getNextValue() : jSpinner.getPreviousValue();
                    if (object != null) {
                        jSpinner.setValue(object);
                        this.select(jSpinner);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
                catch (ParseException parseException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
            }
        }

        private void select(JSpinner jSpinner) {
            block4: {
                SpinnerDateModel spinnerDateModel;
                DateFormat.Field field;
                Object object;
                JComponent jComponent = jSpinner.getEditor();
                if (!(jComponent instanceof JSpinner.DateEditor)) break block4;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
                JFormattedTextField jFormattedTextField = dateEditor.getTextField();
                SimpleDateFormat simpleDateFormat = dateEditor.getFormat();
                if (simpleDateFormat != null && (object = jSpinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((spinnerDateModel = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator attributedCharacterIterator = ((Format)simpleDateFormat).formatToCharacterIterator(object);
                        if (!this.select(jFormattedTextField, attributedCharacterIterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(jFormattedTextField, attributedCharacterIterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }

        private boolean select(JFormattedTextField jFormattedTextField, AttributedCharacterIterator attributedCharacterIterator, DateFormat.Field field) {
            int n2 = jFormattedTextField.getDocument().getLength();
            attributedCharacterIterator.first();
            do {
                Map map;
                if ((map = attributedCharacterIterator.getAttributes()) == null || !map.containsKey(field)) continue;
                int n3 = attributedCharacterIterator.getRunStart(field);
                int n4 = attributedCharacterIterator.getRunLimit(field);
                if (n3 != -1 && n4 != -1 && n3 <= n2 && n4 <= n2) {
                    jFormattedTextField.select(n3, n4);
                }
                return true;
            } while (attributedCharacterIterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner jSpinner) {
            JComponent jComponent = jSpinner.getEditor();
            if (jComponent instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
                JFormattedTextField jFormattedTextField = dateEditor.getTextField();
                int n2 = jFormattedTextField.getSelectionStart();
                JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
                if (abstractFormatter instanceof InternationalFormatter) {
                    Format.Field[] fieldArray = ((InternationalFormatter)abstractFormatter).getFields(n2);
                    int n3 = 0;
                    while (n3 < fieldArray.length) {
                        int n4;
                        if (fieldArray[n3] instanceof DateFormat.Field && (n4 = fieldArray[n3] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fieldArray[n3]).getCalendarField()) != -1) {
                            return n4;
                        }
                        ++n3;
                    }
                }
            }
            return -1;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(mouseEvent);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void focusSpinnerIfNecessary() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (component == null || !SwingUtilities.isDescendingFrom(component, this.spinner))) {
                FocusTraversalPolicy focusTraversalPolicy;
                Component component2;
                Container container = this.spinner;
                if (!container.isFocusCycleRoot()) {
                    container = container.getFocusCycleRootAncestor();
                }
                if (container != null && (component2 = (focusTraversalPolicy = container.getFocusTraversalPolicy()).getComponentAfter(container, this.spinner)) != null && SwingUtilities.isDescendingFrom(component2, this.spinner)) {
                    component2.requestFocus();
                }
            }
        }
    }
}

