/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public final class StringContent
implements AbstractDocument.Content,
Serializable {
    private static final char[] empty = new char[0];
    private char[] data;
    private int count;
    transient Vector marks;

    public StringContent() {
        this(10);
    }

    public StringContent(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.data = new char[n2];
        this.data[0] = 10;
        this.count = 1;
    }

    public int length() {
        return this.count;
    }

    public UndoableEdit insertString(int n2, String string) throws BadLocationException {
        if (n2 >= this.count || n2 < 0) {
            throw new BadLocationException("Invalid location", this.count);
        }
        char[] cArray = string.toCharArray();
        this.replace(n2, 0, cArray, 0, cArray.length);
        if (this.marks != null) {
            this.updateMarksForInsert(n2, string.length());
        }
        return new InsertUndo(n2, string.length());
    }

    public UndoableEdit remove(int n2, int n3) throws BadLocationException {
        if (n2 + n3 >= this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
        String string = this.getString(n2, n3);
        RemoveUndo removeUndo = new RemoveUndo(n2, string);
        this.replace(n2, n3, empty, 0, 0);
        if (this.marks != null) {
            this.updateMarksForRemove(n2, n3);
        }
        return removeUndo;
    }

    public String getString(int n2, int n3) throws BadLocationException {
        if (n2 + n3 > this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
        return new String(this.data, n2, n3);
    }

    public void getChars(int n2, int n3, Segment segment) throws BadLocationException {
        if (n2 + n3 > this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        segment.array = this.data;
        segment.offset = n2;
        segment.count = n3;
    }

    public Position createPosition(int n2) throws BadLocationException {
        if (this.marks == null) {
            this.marks = new Vector();
        }
        return new StickyPosition(n2);
    }

    void replace(int n2, int n3, char[] cArray, int n4, int n5) {
        int n6 = n5 - n3;
        int n7 = n2 + n3;
        int n8 = this.count - n7;
        int n9 = n7 + n6;
        if (this.count + n6 >= this.data.length) {
            int n10 = Math.max(2 * this.data.length, this.count + n6);
            char[] cArray2 = new char[n10];
            System.arraycopy(this.data, 0, cArray2, 0, n2);
            System.arraycopy(cArray, n4, cArray2, n2, n5);
            System.arraycopy(this.data, n7, cArray2, n9, n8);
            this.data = cArray2;
        } else {
            System.arraycopy(this.data, n7, this.data, n9, n8);
            System.arraycopy(cArray, n4, this.data, n2, n5);
        }
        this.count += n6;
    }

    void resize(int n2) {
        char[] cArray = new char[n2];
        System.arraycopy(this.data, 0, cArray, 0, Math.min(n2, this.count));
        this.data = cArray;
    }

    synchronized void updateMarksForInsert(int n2, int n3) {
        if (n2 == 0) {
            n2 = 1;
        }
        int n4 = this.marks.size();
        int n5 = 0;
        while (n5 < n4) {
            PosRec posRec = (PosRec)this.marks.elementAt(n5);
            if (posRec.unused) {
                this.marks.removeElementAt(n5);
                --n5;
                --n4;
            } else if (posRec.offset >= n2) {
                posRec.offset += n3;
            }
            ++n5;
        }
    }

    synchronized void updateMarksForRemove(int n2, int n3) {
        int n4 = this.marks.size();
        int n5 = 0;
        while (n5 < n4) {
            PosRec posRec = (PosRec)this.marks.elementAt(n5);
            if (posRec.unused) {
                this.marks.removeElementAt(n5);
                --n5;
                --n4;
            } else if (posRec.offset >= n2 + n3) {
                posRec.offset -= n3;
            } else if (posRec.offset >= n2) {
                posRec.offset = n2;
            }
            ++n5;
        }
    }

    protected Vector getPositionsInRange(Vector vector, int n2, int n3) {
        int n4 = this.marks.size();
        int n5 = n2 + n3;
        Vector vector2 = vector == null ? new Vector() : vector;
        int n6 = 0;
        while (n6 < n4) {
            PosRec posRec = (PosRec)this.marks.elementAt(n6);
            if (posRec.unused) {
                this.marks.removeElementAt(n6);
                --n6;
                --n4;
            } else if (posRec.offset >= n2 && posRec.offset <= n5) {
                vector2.addElement(new UndoPosRef(posRec));
            }
            ++n6;
        }
        return vector2;
    }

    protected void updateUndoPositions(Vector vector) {
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            UndoPosRef undoPosRef = (UndoPosRef)vector.elementAt(n2);
            if (undoPosRef.rec.unused) {
                vector.removeElementAt(n2);
            } else {
                undoPosRef.resetLocation();
            }
            --n2;
        }
    }

    class RemoveUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected RemoveUndo(int n2, String string) {
            this.offset = n2;
            this.string = string;
            this.length = string.length();
            if (StringContent.this.marks != null) {
                this.posRefs = StringContent.this.getPositionsInRange(null, n2, this.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    StringContent.this.insertString(this.offset, this.string);
                    if (this.posRefs != null) {
                        StringContent.this.updateUndoPositions(this.posRefs);
                        this.posRefs = null;
                    }
                    this.string = null;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    this.string = StringContent.this.getString(this.offset, this.length);
                    if (StringContent.this.marks != null) {
                        this.posRefs = StringContent.this.getPositionsInRange(null, this.offset, this.length);
                    }
                    StringContent.this.remove(this.offset, this.length);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    class InsertUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected InsertUndo(int n2, int n3) {
            this.offset = n2;
            this.length = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    if (StringContent.this.marks != null) {
                        this.posRefs = StringContent.this.getPositionsInRange(null, this.offset, this.length);
                    }
                    this.string = StringContent.this.getString(this.offset, this.length);
                    StringContent.this.remove(this.offset, this.length);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    StringContent.this.insertString(this.offset, this.string);
                    this.string = null;
                    if (this.posRefs != null) {
                        StringContent.this.updateUndoPositions(this.posRefs);
                        this.posRefs = null;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    final class UndoPosRef {
        protected int undoLocation;
        protected PosRec rec;

        UndoPosRef(PosRec posRec) {
            this.rec = posRec;
            this.undoLocation = posRec.offset;
        }

        protected void resetLocation() {
            this.rec.offset = this.undoLocation;
        }
    }

    final class StickyPosition
    implements Position {
        PosRec rec;

        StickyPosition(int n2) {
            this.rec = new PosRec(n2);
            StringContent.this.marks.addElement(this.rec);
        }

        public int getOffset() {
            return this.rec.offset;
        }

        protected void finalize() throws Throwable {
            this.rec.unused = true;
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }
    }

    final class PosRec {
        int offset;
        boolean unused;

        PosRec(int n2) {
            this.offset = n2;
        }
    }
}

