/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.URL;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.PathMap;

abstract class AuthenticationInfo
implements Cloneable {
    static final char SERVER_AUTHENTICATION = 's';
    static final char PROXY_AUTHENTICATION = 'p';
    private static PathMap cache = new PathMap();
    char type;
    char authType;
    String protocol;
    String host;
    int port;
    String realm;
    String path;

    static void printCache() {
        cache.print();
    }

    AuthenticationInfo(char c2, char c3, String string, int n2, String string2) {
        this.type = c2;
        this.authType = c3;
        this.protocol = "";
        this.host = string.toLowerCase();
        this.port = n2;
        this.realm = string2;
        this.path = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    AuthenticationInfo(char c2, char c3, URL uRL, String string) {
        this.type = c2;
        this.authType = c3;
        this.protocol = uRL.getProtocol().toLowerCase();
        this.host = uRL.getHost().toLowerCase();
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = uRL.getDefaultPort();
        }
        this.realm = string;
        String string2 = uRL.getPath();
        this.path = string2.length() == 0 ? string2 : AuthenticationInfo.reducePath(string2);
    }

    static String reducePath(String string) {
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(46);
        if (n2 != -1) {
            if (n2 < n3) {
                return string.substring(0, n2 + 1);
            }
            return string;
        }
        return string;
    }

    static AuthenticationInfo getServerAuth(URL uRL) {
        int n2 = uRL.getPort();
        if (n2 == -1) {
            n2 = uRL.getDefaultPort();
        }
        String string = "s:" + uRL.getProtocol().toLowerCase() + ":" + uRL.getHost().toLowerCase() + ":" + n2;
        return AuthenticationInfo.getAuth(string, uRL);
    }

    static AuthenticationInfo getServerAuth(URL uRL, String string, char c2) {
        int n2 = uRL.getPort();
        if (n2 == -1) {
            n2 = uRL.getDefaultPort();
        }
        String string2 = "s:" + c2 + ":" + uRL.getProtocol().toLowerCase() + ":" + uRL.getHost().toLowerCase() + ":" + n2 + ":" + string;
        return AuthenticationInfo.getAuth(string2, null);
    }

    static AuthenticationInfo getAuth(String string, URL uRL) {
        if (uRL == null) {
            return cache.get(string, null);
        }
        return cache.get(string, uRL.getPath());
    }

    static AuthenticationInfo getProxyAuth(String string, int n2) {
        String string2 = "p::" + string.toLowerCase() + ":" + n2;
        AuthenticationInfo authenticationInfo = cache.get(string2, null);
        return authenticationInfo;
    }

    static AuthenticationInfo getProxyAuth(String string, int n2, String string2, char c2) {
        String string3 = "p:" + c2 + "::" + string.toLowerCase() + ":" + n2 + ":" + string2;
        AuthenticationInfo authenticationInfo = cache.get(string3, null);
        return authenticationInfo;
    }

    void addToCache() {
        cache.put(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.put(this.cacheKey(false), this);
        }
    }

    void removeFromCache() {
        cache.remove(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.remove(this.cacheKey(false), this);
        }
    }

    abstract boolean supportsPreemptiveAuthorization();

    abstract String getHeaderName();

    abstract String getHeaderValue(URL var1, String var2);

    abstract boolean setHeaders(HttpURLConnection var1, HeaderParser var2);

    abstract boolean isAuthorizationStale(String var1);

    abstract void checkResponse(String var1, String var2, URL var3) throws IOException;

    String cacheKey(boolean bl2) {
        if (bl2) {
            return this.type + ":" + this.authType + ":" + this.protocol + ":" + this.host + ":" + this.port + ":" + this.realm;
        }
        return this.type + ":" + this.protocol + ":" + this.host + ":" + this.port;
    }
}

