/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CRLSelector;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.BasicChecker;
import sun.security.util.Debug;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X509CRLEntryImpl;

class CrlRevocationChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private final PublicKey mInitPubKey;
    private final List mStores;
    private final String mSigProvider;
    private final Date mCurrentTime;
    private PublicKey mPrevPubKey;
    private boolean mCRLSignFlag;
    private HashSet mPossibleCRLs;
    private HashSet mApprovedCRLs;

    public CrlRevocationChecker(PublicKey publicKey, List list, String string, Date date) throws CertPathValidatorException {
        this.mInitPubKey = publicKey;
        this.mStores = list;
        this.mSigProvider = string;
        this.mCurrentTime = date != null ? date : new Date();
        this.init(false);
    }

    public void init(boolean bl2) throws CertPathValidatorException {
        if (bl2) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.mPrevPubKey = this.mInitPubKey;
        this.mCRLSignFlag = true;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        this.verifyRevocationStatus(x509Certificate, this.mPrevPubKey, this.mCRLSignFlag);
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (publicKey instanceof DSAPublicKey && ((DSAPublicKey)publicKey).getParams() == null) {
            publicKey = BasicChecker.makeInheritedParamsKey(publicKey, this.mPrevPubKey);
        }
        this.mPrevPubKey = publicKey;
        this.mCRLSignFlag = this.certCanSignCrl(x509Certificate);
    }

    public boolean check(X509Certificate x509Certificate, PublicKey publicKey, boolean bl2) throws CertPathValidatorException {
        this.verifyRevocationStatus(x509Certificate, publicKey, bl2);
        return this.certCanSignCrl(x509Certificate);
    }

    public boolean certCanSignCrl(X509Certificate x509Certificate) {
        try {
            boolean[] blArray = x509Certificate.getKeyUsage();
            if (blArray != null) {
                KeyUsageExtension keyUsageExtension = new KeyUsageExtension(blArray);
                Boolean bl2 = (Boolean)keyUsageExtension.get("crl_sign");
                return bl2 != false;
            }
            return true;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.certCanSignCRL() unexpected exception");
                exception.printStackTrace();
            }
            return false;
        }
    }

    private void verifyRevocationStatus(X509Certificate x509Certificate, PublicKey publicKey, boolean bl2) throws CertPathValidatorException {
        Object object;
        Object object2;
        String string = "revocation status";
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() ---checking " + string + "...");
        }
        if (!bl2) {
            throw new CertPathValidatorException("cert can't vouch for CRL");
        }
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        this.mPossibleCRLs = new HashSet();
        this.mApprovedCRLs = new HashSet();
        try {
            object2 = new X509CRLSelector();
            ((X509CRLSelector)object2).setCertificateChecking(x509Certificate);
            ((X509CRLSelector)object2).setDateAndTime(this.mCurrentTime);
            ((X509CRLSelector)object2).addIssuerName(x500Principal.getName("RFC2253"));
            object = this.mStores.iterator();
            while (object.hasNext()) {
                this.mPossibleCRLs.addAll(((CertStore)object.next()).getCRLs((CRLSelector)object2));
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus() unexpected exception: " + exception.getMessage());
                exception.printStackTrace();
            }
            throw new CertPathValidatorException(exception);
        }
        if (this.mPossibleCRLs.isEmpty()) {
            throw new CertPathValidatorException(string + " check failed: no CRL found");
        }
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() crls.size() = " + this.mPossibleCRLs.size());
        }
        object2 = this.mPossibleCRLs.iterator();
        while (object2.hasNext()) {
            object = (X509CRL)object2.next();
            if (!this.verifyPossibleCRL((X509CRL)object, x500Principal, publicKey)) continue;
            this.mApprovedCRLs.add(object);
        }
        if (this.mApprovedCRLs.isEmpty()) {
            throw new CertPathValidatorException("no possible CRLs");
        }
        if (debug != null) {
            debug.println("starting the final sweep...");
        }
        object2 = this.mApprovedCRLs.iterator();
        object = x509Certificate.getSerialNumber();
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus cert SN: " + ((BigInteger)object).toString());
        }
        boolean bl3 = false;
        while (object2.hasNext()) {
            Object object3;
            X509CRL x509CRL = (X509CRL)object2.next();
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate((BigInteger)object);
            if (x509CRLEntry == null) continue;
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus CRL entry: " + x509CRLEntry.toString());
            }
            int n2 = 0;
            try {
                object3 = new X509CRLEntryImpl(x509CRLEntry.getEncoded());
                Integer n3 = ((X509CRLEntryImpl)object3).getReasonCode();
                n2 = n3 == null ? 0 : n3;
            }
            catch (Exception exception) {
                throw new CertPathValidatorException(exception);
            }
            bl3 = n2 == 6;
            if (!bl3 && n2 != 8) {
                throw new CertPathValidatorException("Certificate has been revoked, reason: " + CrlRevocationChecker.reasonToString(n2));
            }
            object3 = x509CRLEntry.getCriticalExtensionOIDs();
            if (object3 == null || object3.isEmpty()) continue;
            object3.remove(PKIXExtensions.ReasonCode_Id.toString());
            if (object3.isEmpty()) continue;
            throw new CertPathValidatorException("Unrecognized critical extension(s) in revoked CRL entry");
        }
        if (bl3) {
            throw new CertPathValidatorException("Certificate is on hold");
        }
    }

    private static String reasonToString(int n2) {
        switch (n2) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "key compromise";
            }
            case 2: {
                return "CA compromise";
            }
            case 3: {
                return "affiliation changed";
            }
            case 4: {
                return "superseded";
            }
            case 5: {
                return "cessation of operation";
            }
            case 6: {
                return "certificate hold";
            }
            case 8: {
                return "remove from CRL";
            }
        }
        return "unrecognized reason code";
    }

    private boolean verifyPossibleCRL(X509CRL x509CRL, X500Principal x500Principal, PublicKey publicKey) throws CertPathValidatorException {
        if (!x509CRL.getIssuerX500Principal().equals(x500Principal)) {
            if (debug != null) {
                debug.println("CRL issuer does not match cert issuer");
            }
            return false;
        }
        try {
            x509CRL.verify(publicKey, this.mSigProvider);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CRL signature failed to verify");
                exception.printStackTrace();
            }
            return false;
        }
        Date date = x509CRL.getNextUpdate();
        if (date != null && date.before(this.mCurrentTime)) {
            if (debug != null) {
                debug.println("discarding stale CRL (nextUpdate is before required validation time)");
            }
            return false;
        }
        Set set = x509CRL.getCriticalExtensionOIDs();
        if (set != null && !set.isEmpty()) {
            if (debug != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    debug.println((String)iterator.next());
                }
            }
            throw new CertPathValidatorException("Unrecognized critical extension(s) in CRL");
        }
        return true;
    }
}

