/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpedit_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "config.h"

#include "gimp.h"

/**
 * gimp_edit_cut:
 * @drawable_ID: The drawable to cut from.
 *
 * Cut from the specified drawable.
 *
 * If there is a selection in the image, then the area specified by the
 * selection is cut from the specified drawable and placed in an
 * internal GIMP edit buffer. It can subsequently be retrieved using
 * the 'gimp-edit-paste' command. If there is no selection, then the
 * specified drawable will be removed and its contents stored in the
 * internal GIMP edit buffer. The drawable MUST belong to the specified
 * image, or an error is returned.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_edit_cut (gint32 drawable_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_edit_cut",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_edit_copy:
 * @drawable_ID: The drawable to copy from.
 *
 * Copy from the specified drawable.
 *
 * If there is a selection in the image, then the area specified by the
 * selection is copied from the specified drawable and placed in an
 * internal GIMP edit buffer. It can subsequently be retrieved using
 * the 'gimp-edit-paste' command. If there is no selection, then the
 * specified drawable's contents will be stored in the internal GIMP
 * edit buffer. The drawable MUST belong to the specified image, or an
 * error is returned.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_edit_copy (gint32 drawable_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_edit_copy",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_edit_paste:
 * @drawable_ID: The drawable to paste to.
 * @paste_into: Clear selection, or paste behind it?
 *
 * Paste buffer to the specified drawable.
 *
 * This procedure pastes a copy of the internal GIMP edit buffer to the
 * specified drawable. The GIMP edit buffer will be empty unless a call
 * was previously made to either 'gimp-edit-cut' or 'gimp-edit-copy'.
 * The \"paste_into\" option specifies whether to clear the current
 * image selection, or to paste the buffer \"behind\" the selection.
 * This allows the selection to act as a mask for the pasted buffer.
 * Anywhere that the selection mask is non-zero, the pasted buffer will
 * show through. The pasted buffer will be a new layer in the image
 * which is designated as the image floating selection. If the image
 * has a floating selection at the time of pasting, the old floating
 * selection will be anchored to it's drawable before the new floating
 * selection is added. This procedure returns the new floating layer.
 * The resulting floating selection will already be attached to the
 * specified drawable, and a subsequent call to floating_sel_attach is
 * not needed.
 *
 * Returns: The new floating selection.
 */
gint32
gimp_edit_paste (gint32   drawable_ID,
		 gboolean paste_into)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 floating_sel_ID = -1;

  return_vals = gimp_run_procedure ("gimp_edit_paste",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, paste_into,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    floating_sel_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return floating_sel_ID;
}

/**
 * gimp_edit_clear:
 * @drawable_ID: The drawable to clear from.
 *
 * Clear selected area of drawable.
 *
 * This procedure clears the specified drawable. If the drawable has an
 * alpha channel, the cleared pixels will become transparent. If the
 * drawable does not have an alpha channel, cleared pixels will be set
 * to the background color. This procedure only affects regions within
 * a selection if there is a selection active.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_edit_clear (gint32 drawable_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_edit_clear",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_edit_fill:
 * @drawable_ID: The drawable to fill to.
 * @fill_type: The type of fill.
 *
 * Fill selected area of drawable.
 *
 * This procedure fills the specified drawable with the fill mode. If
 * the fill mode is foreground, the current foreground color is used.
 * If the fill mode is background, the current background color is
 * used. Other fill modes should not be used. This procedure only
 * affects regions within a selection if there is a selection active.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_edit_fill (gint32       drawable_ID,
		GimpFillType fill_type)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_edit_fill",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, fill_type,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_edit_stroke:
 * @drawable_ID: The drawable to stroke to.
 *
 * Stroke the current selection
 *
 * This procedure strokes the current selection, painting along the
 * selection boundary with the active brush and foreground color. The
 * paint is applied to the specified drawable regardless of the active
 * selection.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_edit_stroke (gint32 drawable_ID)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_edit_stroke",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
