/*
	setup.c
	28.3.99 tn@xcdroast.org
*/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "largefile.h"
#include "gettext.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif

#if ENABLE_NLS
# define _(String) gettext (String)
# define N_(String) gettext_noop (String)
#else
# define _(String) (String)
# define N_(String) (String)
#endif

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "xcdrdata.h"
#include "xcdroast.h"
#include "main.h"
#include "language.h"
#include "xpms/scsi_cdrom.xpm"
#include "xpms/scsi_hd.xpm"
#include "xpms/scsi_hdrmb.xpm"
#include "xpms/scsi_misc.xpm"
#include "xpms/scsi_tape.xpm"
#include "xpms/scsi_worm.xpm"
#include "xpms/scsi_scanner.xpm"

extern GtkWidget *toplevel;
extern GtkWidget *sidespace;
extern GtkWidget *workspace;
extern scsi_devices_t **scsidevices;
extern gchar **alt_scsidevices;
extern writer_driver_t **drivers;
extern gchar *language;
extern setup_data_t setupdata;
extern current_set_t curset;
extern gchar configdir[MAXLINE];
extern gchar rootconfig[MAXLINE];
extern gchar xcdroast_version_loaded[MAXLINE];
extern gchar sharedir[MAXLINE];

setup_data_t bak_setupdata;
GtkCList *clist_list;
GtkCList  *users_clist, *hosts_clist;
GtkWidget *clist_entry, *rootusers_entry, *roothosts_entry;
GtkWidget *updatesum_label, *updatebutton;
GtkWidget *cddb_entry1, *cddb_entry2, *log_entry;
GtkWidget *cddb_entry3, *cddb_entry4, *cddb_opt1, *cddb_opt2;
GtkWidget *btn_testdsp, *readslider1, *readslider2, *readspd1, *readspd2;
GtkWidget *prodvdkey_txt;
static GtkWidget *nrs_frame, *nrs_page, *nrs_dialog;
static gint nrs_mode, nrs_fromsetup;
static gint nrs_dialog_done;

static GtkWidget *gen_nonroot_page1(gint act, gint fromsetup);
static GtkWidget *gen_nonroot_page2(gint act);
static GtkWidget *gen_nonroot_page3(gint act, gint status, gint fromsetup);


/* main functions of the setup-menu */
/* called by cancel-button */

void menu_setup_cancel(GtkWidget *widget, gpointer data) {

	dodebug(8, "canceling setup\n");
	dolog(2, "Cancel setup\n");
 
	/* restore the saved data - therefore deletes all changes */
	free_glist(&setupdata.image_dirs);
	memcpy(&setupdata,&bak_setupdata,sizeof(setup_data_t));
	setupdata.image_dirs = NULL;
	copy_glist(&setupdata.image_dirs, bak_setupdata.image_dirs);
	free_glist(&bak_setupdata.image_dirs);

#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	if (isroot()) {
		setupdata.root_users_lists = NULL;
		setupdata.root_hosts_lists = NULL;
		free_glist(&setupdata.root_users_lists);
		free_glist(&setupdata.root_hosts_lists);
		copy_glist(&setupdata.root_users_lists, bak_setupdata.root_users_lists);
		free_glist(&bak_setupdata.root_users_lists);
		copy_glist(&setupdata.root_hosts_lists, bak_setupdata.root_hosts_lists);
		free_glist(&bak_setupdata.root_hosts_lists);
	}
#endif

	setupdata.dsp_device = g_strdup(bak_setupdata.dsp_device);
	g_free(bak_setupdata.dsp_device);
	setupdata.mix_device = g_strdup(bak_setupdata.mix_device);
	g_free(bak_setupdata.mix_device);
	setupdata.cddb_host = g_strdup(bak_setupdata.cddb_host);
	g_free(bak_setupdata.cddb_host);
	setupdata.cddb_proxy_host = g_strdup(bak_setupdata.cddb_proxy_host);
	g_free(bak_setupdata.cddb_proxy_host);
	setupdata.logfile = g_strdup(bak_setupdata.logfile);
	g_free(bak_setupdata.logfile);
	setupdata.ProDVDkey = g_strdup(bak_setupdata.ProDVDkey);
	g_free(bak_setupdata.ProDVDkey);
 
	/* check if cancel and no config-file loaded */
	if (strcmp(xcdroast_version_loaded, "") == 0) {
		/* no config file - continue to lock duplicate and create
		   buttons */
        	create_main(1);
	} else {
		create_main(0);
	}
}


/* calculate all setup-data before leaving setup-menu */

gint menu_setup_ok_work(GtkWidget *widget, gpointer data) {
gint i, n;
gchar *rowdata[2];
gchar tmp[MAXLINE], tmp2[MAXLINE];
gchar *buf, *locreturn;

	dodebug(8, "confirming setup\n");

	/* create glist of image-dirs */
	free_glist(&setupdata.image_dirs);
	for (i = 0; i < clist_list->rows; i++) {
		gtk_clist_get_text(clist_list,i,0,rowdata);	
		setupdata.image_dirs = g_list_append(setupdata.image_dirs,
			g_strdup(rowdata[0]));
	}

	/* no image-dirs? */
	if (i == 0) {
		show_dialog(ICO_ERROR, _("No image-directories defined. You have to define at\nleast one directory for saving image data in order to continue."), T_CANCEL, NULL, NULL, 0);
		return 1;
	}

#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	if (isroot()) {
		/* create glist of nonroot stuff */
		free_glist(&setupdata.root_users_lists);
		for (i = 0; i < users_clist->rows; i++) {
			gtk_clist_get_text(users_clist,i,0,rowdata);	
			setupdata.root_users_lists = g_list_append(setupdata.root_users_lists, g_strdup(rowdata[0]));
		}
		free_glist(&setupdata.root_hosts_lists);
		for (i = 0; i < hosts_clist->rows; i++) {
			gtk_clist_get_text(hosts_clist,i,0,rowdata);	
			setupdata.root_hosts_lists = g_list_append(setupdata.root_hosts_lists, g_strdup(rowdata[0]));
		}
	}
#endif

	/* now fill vendor/model data */
	convert_devnr2vendor(setupdata.writer_devnr,tmp);
	strncpy(setupdata.writer_vendor,tmp,9);
	convert_devnr2model(setupdata.writer_devnr,tmp);
	strncpy(setupdata.writer_model,tmp,17);
	convert_devnr2vendor(setupdata.readdev1_devnr,tmp);
	strncpy(setupdata.readdev1_vendor,tmp,9);
	convert_devnr2model(setupdata.readdev1_devnr,tmp);
	strncpy(setupdata.readdev1_model,tmp,17);
	convert_devnr2vendor(setupdata.readdev2_devnr,tmp);
	strncpy(setupdata.readdev2_vendor,tmp,9);
	convert_devnr2model(setupdata.readdev2_devnr,tmp);
	strncpy(setupdata.readdev2_model,tmp,17);

	if (strcmp(setupdata.language, "") != 0) {
		g_free(language);
		language = g_strdup(setupdata.language);
#ifdef HAVE_SETLOCALE
		locreturn = setlocale(LC_ALL, language);
		if (locreturn == NULL) {
			/* locate not supported? */
			g_snprintf(tmp,MAXLINE,_("The requested language with the locale\n\"%s\" is not available on this system.\nYour language setting will be ignored."), language);
			show_dialog(ICO_WARN, tmp, T_OK, NULL, NULL, 0);
		}
		setlocale (LC_NUMERIC, "C");
#endif 
	} else {
		/* get language from locale */
#ifdef HAVE_SETLOCALE
		setlocale (LC_ALL, "");
		setlocale (LC_NUMERIC, "C");
#endif
	}

	/* now generate mixer-device from dsp-device */
	g_free(setupdata.mix_device);
	if (setupdata.dsp_device != NULL) {
		setupdata.mix_device = g_strdup(
			gen_mix_from_dspdev(setupdata.dsp_device,tmp));
	}

	/* now get cddb/log-entries */
	g_free(setupdata.cddb_host);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(cddb_entry1)));
	strip_string(tmp);
	setupdata.cddb_host = g_strdup(tmp);
	if (setupdata.cddb_use_http == 0) {
		setupdata.cddb_port = atoi(
			gtk_entry_get_text(GTK_ENTRY(cddb_entry2)));
	}
	g_free(setupdata.cddb_proxy_host);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(cddb_entry3)));
	strip_string(tmp);
	setupdata.cddb_proxy_host = g_strdup(tmp);
	setupdata.cddb_proxy_port = atoi(
		gtk_entry_get_text(GTK_ENTRY(cddb_entry4)));

	g_free(setupdata.logfile);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(log_entry)));
	/* check_tilde(tmp); */
	setupdata.logfile = g_strdup(tmp);

	g_free(setupdata.ProDVDkey);
	n = gtk_text_get_length(GTK_TEXT(prodvdkey_txt));
	buf = gtk_editable_get_chars(GTK_EDITABLE(prodvdkey_txt),0,n);
	strncpy(tmp, buf, MAXLINE);
	strip_string(tmp); 
	setupdata.ProDVDkey = g_strdup(tmp);
        g_snprintf(tmp2,MAXLINE,"CDR_SECURITY=%s", setupdata.ProDVDkey);

#if defined(HAVE_SETENV) && HAVE_SETENV == 1
        setenv("CDR_SECURITY", setupdata.ProDVDkey, 1);
#else  
        putenv(tmp2);
#endif

	/* if the writer changed, lets lookup new driver options */
	scanoptions(setupdata.writer_devnr);

	return 0;
}


/* called by ok-button */

void menu_setup_ok(GtkWidget *widget, gpointer data) {

	dolog(2, "Confirm setup\n");

	if (menu_setup_ok_work(widget,data)) 
		return;

	/* free memory of backup-config */
	g_free(bak_setupdata.ProDVDkey);
	g_free(bak_setupdata.logfile);
	g_free(bak_setupdata.cddb_host);
	g_free(bak_setupdata.cddb_proxy_host);
	g_free(bak_setupdata.dsp_device);
	g_free(bak_setupdata.mix_device);
	free_glist(&bak_setupdata.image_dirs);
#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	if (isroot()) {
		free_glist(&bak_setupdata.root_users_lists);
		free_glist(&bak_setupdata.root_hosts_lists);
	}
#endif
	strcpy(xcdroast_version_loaded, XCDROAST_VERSION);

        create_main(0);
}


/* called by save button */

void menu_setup_save(GtkWidget *widget, gpointer data) {
gchar tmp2[MAXLINE];
gint stat;

	if (menu_setup_ok_work(widget,data))
		return;

	dolog(2, "Save setup configuration\n");

#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)

	if (isroot()) {
		/* save special root config */
		stat = save_setup_config("", rootconfig);	

		/* make sure this config got the right permissions */
		/* fix_guid(); */
		/* chown(rootconfig, 0, getegid()); */
		chmod(rootconfig, 0644);
		/* fix_guid(); */
	} else {
#endif
		stat = save_setup_config(configdir, CONFFILE);

#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	}
#endif

	/* write config file */
	if (stat == 1) {
		/* save failed */
		g_snprintf(tmp2,MAXLINE,_("Failed to save configuration file: %s"), CONFFILE);
		show_dialog(ICO_WARN, tmp2, T_OK, NULL, NULL, 0);
	} else {
		/* save ok */
		show_dialog(ICO_INFO,_("Configuration saved"), T_OK, NULL, NULL, 0);
	}
}


/* click on device-list */

void device_select_row(GtkWidget *clist, gint row, gint col,
                     GdkEventButton *event, gpointer data) {

	/* double click? */
	if (event && event->type == GDK_2BUTTON_PRESS) {
		show_device_detail(scsidevices[row]->devnr);
	}	
}


/* draw scsi-scan screen */

void draw_scsi_scan(GtkWidget *win) {
gchar *titles[6];
gchar *data[6];
GtkWidget *list, *vbox, *l1;
GtkCList *clist;
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar tmp3[MAXLINE];
gint count;
gint type;
gint removable;
GdkPixmap *pixmap;
GdkBitmap *mask;
gchar **xpm;
GtkWidget *scrolled_win;
GtkStyle *style;
#ifdef PRIV_COLS 
GdkColor c;
#endif

        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(win),vbox);
        gtk_widget_show(vbox);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_win, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

	titles[0] = _("Type");
	titles[1] = _("Bus,Id");
	titles[2] = _("Vendor");
	titles[3] = _("Model");
	titles[4] = _("Rev.");
	titles[5] = _("Description");

	list = gtk_clist_new_with_titles(6,titles);
	gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	gtk_widget_realize(list);

	clist = GTK_CLIST(list);
	gtk_clist_set_column_auto_resize(clist, 5, TRUE);

	style = gtk_style_copy(gtk_widget_get_style(list));
#ifdef PRIV_COLS 
	gdk_color_parse(GTKLISTCOL,&c);
	gdk_color_alloc(gtk_widget_get_colormap(list),&c);

	style->base[GTK_STATE_NORMAL] = c;
	gtk_widget_set_style(GTK_WIDGET(list),style);
#endif

	gtk_clist_set_row_height(clist, 48);
	gtk_clist_set_column_width(clist, 0, 48);
	gtk_clist_set_column_justification(clist, 0, GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_width(clist, 1, tbf(50));
	gtk_clist_set_column_justification(clist, 1, GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_width(clist, 2, tbf(70));
	gtk_clist_set_column_width(clist, 3, tbf(140));
	gtk_clist_set_column_width(clist, 4, tbf(35));
	gtk_signal_connect(GTK_OBJECT(clist), "select_row",
		GTK_SIGNAL_FUNC(device_select_row), NULL);
	
	count = 0;
	while(scsidevices[count] != NULL) {
		if (scsidevices[count]->alt_dev == -1) {

			get_transport_str(scsidevices[count]->transport, tmp3);
			g_snprintf(tmp,MAXLINE,"[%s%d,%d]",tmp3,
			scsidevices[count]->bus, scsidevices[count]->id);
		} else {
			g_snprintf(tmp,MAXLINE,"[%s]",
			alt_scsidevices[scsidevices[count]->alt_dev]);
		}
		if (strlen(tmp) > 12) {
			/* if long device str, make column wider */
			gtk_clist_set_column_width(clist, 1, tbf(155));
		} else 
		if (strlen(tmp) > 8) {
			/* if long device str, make column wider */
			gtk_clist_set_column_width(clist, 1, tbf(90));
		}
		data[0] = NULL;
		data[1] = tmp;
		data[2] = scsidevices[count]->vendor;
		data[3] = scsidevices[count]->model;
		data[4] = scsidevices[count]->rev;
		removable = scsidevices[count]->removable;
		type = scsidevices[count]->type;
		get_scsi_type_string(tmp2, type, removable);	
		data[5] = tmp2;
		gtk_clist_append(clist,data);

		xpm = scsi_misc_xpm;

		if (type == 0) {
			if (removable == 0) {
				xpm = scsi_hd_xpm;
			} else {
				xpm = scsi_hdrmb_xpm;
			}
		}
		if (type == 1) {
			xpm = scsi_tape_xpm;
		}
		if (type == 3) {
			/* most scanners seem to register themselves as 
			   processor..*/
			xpm = scsi_scanner_xpm;
		}
		if (type == 4) {
			xpm = scsi_worm_xpm;
		}
		if (type == 5) {
			xpm = scsi_cdrom_xpm;
		}
		if (type == 6) {
			xpm = scsi_scanner_xpm;
		}
		if (type == 7) {
			xpm = scsi_hdrmb_xpm;
		}


		pixmap = gdk_pixmap_create_from_xpm_d(clist->clist_window, 
			&mask, &style->bg[GTK_STATE_NORMAL],(gchar **)xpm);
		gtk_clist_set_pixmap(clist,count,0,pixmap,mask);
		
		count++;
	}

	gtk_widget_show(list);
	gtk_widget_show(scrolled_win);

	l1 = gtk_label_new(_("Please see http://www.xcdroast.org/faq when you miss a drive this list."));
	gtk_box_pack_start(GTK_BOX(vbox),l1, FALSE, TRUE, 0);
	gtk_widget_show(l1);
}


/* following functions are the callbacks for the cd-setup-menu */

void speed_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];

	g_snprintf(tmp, MAXLINE,"%dx",(gint)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_writeparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}

	setupdata.writer_speed = (gint)adj->value;
}


void fifo_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];

	g_snprintf(tmp, MAXLINE,"%.1fMB",(gfloat)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_writeparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}
	setupdata.writer_fifo  = (gint)(adj->value * 1024);
}

void audio_speed_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];

	g_snprintf(tmp, MAXLINE,"%dx",(gint)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_readparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}	
	setupdata.audioread_speed = (gint)adj->value;
}

void sectors_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];

	g_snprintf(tmp, MAXLINE,"%d",(gint)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_readparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}	

	setupdata.audioread_overlap = (gint)adj->value;

}

void sectors2_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];

	g_snprintf(tmp, MAXLINE,"%d",(gint)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_readparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}	

	setupdata.audioread_sectorburst = (gint)adj->value;
}

void sectors3_changed(GtkAdjustment *adj, GtkWidget *label) {
gchar tmp[MAXLINE];

	g_snprintf(tmp, MAXLINE,"%d",(gint)adj->value);
	gtk_label_set_text(GTK_LABEL(label),tmp);
	if (!isroot() && !setupdata.root_option_change_readparam) {
		set_labelcolor(label,DISABLEDCOLOR);
	}	

	setupdata.audioread_paranoiaretries = (gint)adj->value;
}

void writer_selected(GtkWidget *item, gpointer devnr) {

	setupdata.writer_devnr = GPOINTER_TO_INT(devnr);
}

void writermode_selected(GtkWidget *item, gpointer mode) {

	setupdata.writer_mode = GPOINTER_TO_INT(mode);
}

void readdev1_selected(GtkWidget *item, gpointer devnr) {

	setupdata.readdev1_devnr = GPOINTER_TO_INT(devnr);
}

void readdev2_selected(GtkWidget *item, gpointer devnr) {

	setupdata.readdev2_devnr = GPOINTER_TO_INT(devnr);
}

void audiointerface_selected(GtkWidget *item, gpointer data) {

	setupdata.audioread_interface = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));
}

void paranoia_selected(GtkWidget *item, gpointer data) {

	setupdata.audioread_useparanoia = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	if (setupdata.audioread_useparanoia == 0) {
		gtk_widget_set_sensitive(readslider2,FALSE);
		set_labelcolor(readspd2,DISABLEDCOLOR);
		if (isroot() || setupdata.root_option_change_readparam) {
			gtk_widget_set_sensitive(readslider1,TRUE);
			set_labelcolor(readspd1,ENABLEDCOLOR);
		}
	} else {
		gtk_widget_set_sensitive(readslider1,FALSE);
		set_labelcolor(readspd1,DISABLEDCOLOR);
		if (isroot() || setupdata.root_option_change_readparam) {
			gtk_widget_set_sensitive(readslider2,TRUE);
			set_labelcolor(readspd2,ENABLEDCOLOR);
		}
	}
}


/* draw cd-setup screen */

void draw_cd_setup(GtkWidget *win) {
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GtkWidget *l1;
GtkWidget *f1;
GtkWidget *vbox;
GtkWidget *tbl;
GtkObject *adj1,*adj2,*adj3,*adj4,*adj5,*adj6;
GtkWidget *scale;
GtkWidget *spdlabel, *fifolabel, *check;
gchar tmp[MAXLINE];
#ifdef WEWANTUSEAUDIOINTERFACESELECTOR
GSList *group;
GtkWidget *btn;
#endif
gint i;
gint menuhistory, menuidx, firstdevnr;

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),10);

	gtk_widget_show(vbox);

	f1 = gtk_frame_new(_("CD Writer Configuration"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,0);
	gtk_widget_show(f1);

	tbl = gtk_table_new(4,32,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),14,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("CD Writer Device:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,0,1);
	gtk_widget_show(l1);
	
	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	menuidx = 0; menuhistory = -1; firstdevnr = -1;
	i = 0;
	while(scsidevices[i] != NULL) {
		if (scsidevices[i]->type == 4 || scsidevices[i]->type == 5 ) {

			if (firstdevnr == -1) {
				firstdevnr = scsidevices[i]->devnr;
			}
			if (convert_devnr2devstring(scsidevices[i]->devnr,tmp) == 0) {
				menu_item = gtk_menu_item_new_with_label(tmp);
				gtk_signal_connect(GTK_OBJECT(menu_item),
					"activate", GTK_SIGNAL_FUNC(writer_selected),
					GINT_TO_POINTER(scsidevices[i]->devnr));
				gtk_menu_append (GTK_MENU (menu), menu_item);
				/* look if this is the currently selected writer */
				if (setupdata.writer_devnr == scsidevices[i]->devnr) { menuhistory = menuidx; }
				menuidx++;
				gtk_widget_show (menu_item);
			}
		}
		i++;
	}

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	/* set the preselected writer */
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	} else {
		/* nothing valid preselected */
		setupdata.writer_devnr = firstdevnr;
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,15,32,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("Select the CD Writer you want to use."));

	if (!isroot() && !setupdata.root_option_change_writer) {
		gtk_widget_set_sensitive(omenu,FALSE);
	}

	l1 = rightjust_gtk_label_new(_("CD Writer Mode:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,1,2);
	gtk_widget_show(l1);

	/* list of cdrecord drivers */
	omenu = gtk_option_menu_new();
	menu = gtk_menu_new();

	menuidx = 0; menuhistory = 0;
	menu_item = gtk_menu_item_new_with_label(_("Autodetect"));
	gtk_signal_connect(GTK_OBJECT(menu_item),
		"activate", GTK_SIGNAL_FUNC(writermode_selected),
		GINT_TO_POINTER(-1));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	if (setupdata.writer_mode == -1) { menuhistory = menuidx; }
	menuidx++;
	gtk_widget_show (menu_item);

	i = 0;
	while(drivers[i] != NULL) {

		menu_item = gtk_menu_item_new_with_label(drivers[i]->desc);
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(writermode_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append (GTK_MENU (menu), menu_item);
		if (setupdata.writer_mode == i) { menuhistory = menuidx; }
		menuidx++;
		gtk_widget_show (menu_item);
		i++;
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,15,32,1,2);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("The write-mode: Leave that at \"autodetect\" unless you really know what you are doing."));

	if (!isroot() && !setupdata.root_option_change_writer) {
		gtk_widget_set_sensitive(omenu,FALSE);
	}

	l1 = rightjust_gtk_label_new(_("CD Writer Speed:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,2,3);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,2,3);
	gtk_widget_show(f1);

	spdlabel = gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(f1),spdlabel);
	gtk_widget_show(spdlabel);

	adj1 = gtk_adjustment_new(0.0,0.0,65.0,1.0,1.0,1.0);
	gtk_signal_connect(GTK_OBJECT(adj1), "value_changed",
		GTK_SIGNAL_FUNC(speed_changed), spdlabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj1));
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,2,3);

	/* set current value. We add 0.1 because otherwise the value of
	   zero is ignored. Very strange */
	gtk_adjustment_set_value(GTK_ADJUSTMENT (adj1),
		(gfloat)setupdata.writer_speed+0.1); 

	gtk_widget_show(scale);
	define_tooltip(scale,_("The default speed to be used for writing."));
	
	if (!isroot() && !setupdata.root_option_change_writeparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}

	l1 = rightjust_gtk_label_new(_("CD Writer FIFO-Buffer-Size:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,3,4);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,3,4);
	gtk_widget_show(f1);

	fifolabel = gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(f1),fifolabel);
	gtk_widget_show(fifolabel);

	adj2 = gtk_adjustment_new(1.0,1.0,16.0,0.5,0.5,0.0);
	gtk_signal_connect(GTK_OBJECT(adj2), "value_changed",
		GTK_SIGNAL_FUNC(fifo_changed), fifolabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj2));
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,3,4);

	/* next line is to fix a bug in adj_set_value */
	gtk_label_set_text(GTK_LABEL(fifolabel),"1.0MB");
	gtk_adjustment_set_value(GTK_ADJUSTMENT (adj2),
		(gfloat)(setupdata.writer_fifo/1024)); 
		 
	gtk_widget_show(scale);
	define_tooltip(scale,_("This is the internal memory-buffer cdrecord allocates to prevent buffer-underruns while burning. This should be set higher than the writer-internal hardware buffer for more performance."));

	if (!isroot() && !setupdata.root_option_change_writeparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}
	
	/* ------------------------------ */

	f1 = gtk_frame_new(_("CD Reader Configuration"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,10);
	gtk_widget_show(f1);

	tbl = gtk_table_new(7,32,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),14,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("Primary Read Device:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	menuidx = 0; menuhistory = -1; firstdevnr = -1;
	i = 0;
	while(scsidevices[i] != NULL) {
		if (scsidevices[i]->type == 4 || scsidevices[i]->type == 5 ) {

			if (firstdevnr == -1) {
				firstdevnr = scsidevices[i]->devnr;
			}
			if (convert_devnr2devstring(scsidevices[i]->devnr,tmp) == 0) {
				menu_item = gtk_menu_item_new_with_label(tmp);
				gtk_signal_connect(GTK_OBJECT(menu_item),
					"activate", GTK_SIGNAL_FUNC(readdev1_selected),
					GINT_TO_POINTER(scsidevices[i]->devnr));
				gtk_menu_append (GTK_MENU (menu), menu_item);

				if (setupdata.readdev1_devnr == scsidevices[i]->devnr) { menuhistory = menuidx; }
				menuidx++;
				gtk_widget_show (menu_item);
			}
		}
		i++;
	}

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	} else {
		setupdata.readdev1_devnr = firstdevnr;
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,15,32,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("The device you want to use to read data or audio from CDs."));

	if (!isroot() && !setupdata.root_option_change_reader) {
		gtk_widget_set_sensitive(omenu,FALSE);
	}

	l1 = rightjust_gtk_label_new(_("Secondary Read Device:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,1,2);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	menuidx = 0; menuhistory = -1; firstdevnr = -1;
	i = 0;
	while(scsidevices[i] != NULL) {
		if (scsidevices[i]->type == 4 || scsidevices[i]->type == 5 ) {

			if (firstdevnr == -1) {
				firstdevnr = scsidevices[i]->devnr;
			}
			if (convert_devnr2devstring(scsidevices[i]->devnr,tmp) == 0) {
				menu_item = gtk_menu_item_new_with_label(tmp);
				gtk_signal_connect(GTK_OBJECT(menu_item),
					"activate", GTK_SIGNAL_FUNC(readdev2_selected),
					GINT_TO_POINTER(scsidevices[i]->devnr));
				gtk_menu_append (GTK_MENU (menu), menu_item);
				if (setupdata.readdev2_devnr == scsidevices[i]->devnr) { menuhistory = menuidx; }
				menuidx++;
				gtk_widget_show (menu_item);
			}
		}
		i++;
	}

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	} else {
		setupdata.readdev2_devnr = firstdevnr;
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,15,32,1,2);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("A second read device. Can be the same as the first if you have only one to choose from."));

	if (!isroot() && !setupdata.root_option_change_reader) {
		gtk_widget_set_sensitive(omenu,FALSE);
	}

	/* audio-interface selector */
#ifdef WEWANTUSEAUDIOINTERFACESELECTOR
	l1 = rightjust_gtk_label_new(_("Audio Read Interface:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,5,6);
	gtk_widget_show(l1);

	btn = gtk_radio_button_new_with_label(NULL,_("generic_scsi"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,15,24,5,6);
	gtk_widget_show(btn);
	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(btn,FALSE);
	}
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,_("cooked_ioctl"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(audiointerface_selected),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,24,32,5,6);
	gtk_widget_show(btn);
	/* set current value */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),setupdata.audioread_interface);

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(btn,FALSE);
	}

#endif

	l1 = rightjust_gtk_label_new(_("Audio Read Speed:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,2,3);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,2,3);
	gtk_widget_show(f1);

	spdlabel = gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(f1),spdlabel);
	gtk_widget_show(spdlabel);

	adj3 = gtk_adjustment_new(0.0,0.0,65.0,1.0,1.0,1.0);
	gtk_signal_connect(GTK_OBJECT(adj3), "value_changed",
		GTK_SIGNAL_FUNC(audio_speed_changed), spdlabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj3));
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,2,3);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adj3),
		(gfloat)setupdata.audioread_speed+0.1);
	gtk_widget_show(scale);
	define_tooltip(scale,_("The speed X-CD-Roast tries to set on reader when reading audio tracks. This setting will be silently ignored by some devices."));

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}
	
	/* -- */

	l1 = rightjust_gtk_label_new(_("Sectors per request:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,3,4);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,3,4);
	gtk_widget_show(f1);

	spdlabel = gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(f1),spdlabel);
	gtk_widget_show(spdlabel);

	adj5 = gtk_adjustment_new(1.0,1.0,151.0,1.0,1.0,1.0);
	gtk_signal_connect(GTK_OBJECT(adj5), "value_changed",
		GTK_SIGNAL_FUNC(sectors2_changed), spdlabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj5));
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,3,4);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adj5),
		(gfloat)setupdata.audioread_sectorburst+0.1);
	gtk_widget_show(scale);
	define_tooltip(scale,_("How many audio sectors are read per request. Higher Settings result in better quality but require more scsi-buffer-memory."));

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}

	/* -- */

	l1 = rightjust_gtk_label_new(_("Sectors for overlap sampling:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,4,5);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,4,5);
	gtk_widget_show(f1);

	spdlabel = gtk_label_new("");
	readspd1 = spdlabel;
	gtk_container_add(GTK_CONTAINER(f1),spdlabel);
	gtk_widget_show(spdlabel);

	adj4 = gtk_adjustment_new(0.0,0.0,31.0,1.0,1.0,1.0);
	gtk_signal_connect(GTK_OBJECT(adj4), "value_changed",
		GTK_SIGNAL_FUNC(sectors_changed), spdlabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj4));
	readslider1 = scale;
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,4,5);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adj4),
		(gfloat)setupdata.audioread_overlap+0.1);
	gtk_widget_show(scale);
	define_tooltip(scale,_("Enables jitter-correction for audio tracks. The higher this setting the slower can the read process be. Set this to 0 for full speed."));

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}

	/* -- */

	l1 = rightjust_gtk_label_new(_("Paranoia retries per sector:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,15,5,6);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_border_width(GTK_CONTAINER(f1),3);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,15,19,5,6);
	gtk_widget_show(f1);

	spdlabel = gtk_label_new("");
	readspd2 = spdlabel;
	gtk_container_add(GTK_CONTAINER(f1),spdlabel);
	gtk_widget_show(spdlabel);

	adj6 = gtk_adjustment_new(0.0,0.0,65.0,1.0,1.0,1.0);
	gtk_signal_connect(GTK_OBJECT(adj6), "value_changed",
		GTK_SIGNAL_FUNC(sectors3_changed), spdlabel);
	scale = gtk_hscale_new(GTK_ADJUSTMENT (adj6));
	readslider2 = scale;
	gtk_scale_set_value_pos (GTK_SCALE(scale), GTK_POS_LEFT);
	gtk_scale_set_digits(GTK_SCALE(scale),0);
	gtk_scale_set_draw_value(GTK_SCALE(scale),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scale,19,32,5,6);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(adj6),
		(gfloat)setupdata.audioread_paranoiaretries+0.1);
	gtk_widget_show(scale);
	define_tooltip(scale,_("How often the paranoia code will try to read a fautly sector before giving up."));

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(scale,FALSE);
	}

	/* paranoia mode? */

	check = gtk_check_button_new_with_label(_("Use paranoia mode for audio"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(paranoia_selected), NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,15,32,6,7);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.audioread_useparanoia);
	gtk_widget_show(check);
	define_tooltip(check, _("Read audio CDs with the enhanced error correction paranoia code."));

	if (!isroot() && !setupdata.root_option_change_readparam) {
		gtk_widget_set_sensitive(check,FALSE);
	}

	paranoia_selected(check, NULL);
}


/* check if the filesystem-device is already in use of another
   image-path. return 1 if yes, 0 if not. returns also the other
   image-path in busypath. return -1 if not yet any path was updated */

gint fs_in_use(GtkCList *clist, gchar *fs, gchar *busypath) {
gint i;
gchar tmp[MAXLINE];
gchar *mnt;
gchar *data[3];

	for (i = 0; i < clist->rows; i++) {
		mnt = (gchar *)gtk_clist_get_row_data(clist,i);
		if (mnt == NULL) {
			return -1;
		}
		strcpy(tmp,mnt);
		if (strcmp(tmp,fs) == 0) {
			if (busypath != NULL) {
				gtk_clist_get_text(clist,i,0,data);
				strcpy(busypath,data[0]);
			}
			return 1;
		}
	}
	return 0;
}


/* check if the filesystem-device is already in use of another
   image-path. Skip the row "skiprow". return 1 if hit found */ 

gint fs_in_use2(GtkCList *clist, gchar *fs, gint skiprow) {
gint i;
gchar *mnt;

	for (i = 0; i < clist->rows; i++) {
		mnt = (gchar *)gtk_clist_get_row_data(clist,i);
		if (mnt == NULL) {
			/* ignore not updated lines */
			continue;
		}
		if (i == skiprow) {
			/* ignore the row marked to skip */
			continue;
		}
		if (strcmp(mnt,fs) == 0) {
			/* we found a match */
			return 1;
		}
	}
	return 0;
}


/* callbacks for hd-setup-menu */

void entry_imagepath_callback(GtkWidget *widget, GtkCList *clist) {
gchar dir[MAXLINE];
gchar *data[3];
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar fs[MAXLINE];
gint free;
gint row;
gint fsuse;

	strcpy(dir,gtk_entry_get_text(GTK_ENTRY(clist_entry)));
	check_tilde(dir);
	gtk_entry_set_text(GTK_ENTRY(clist_entry), dir);

	/* valid directory? */
	if (is_directory(dir) == 0) {
		show_dialog(ICO_INFO,_("No valid path specified"),T_OK,NULL,NULL,0);	
		return;
	}

	/* now run update to get all partitions */
	gtk_button_clicked(GTK_BUTTON(updatebutton));

	/* last character a /? remove */
	if (dir[strlen(dir)-1] == '/') {
		dir[strlen(dir)-1] = '\0';
	}

	free = get_free_space(dir,fs);

	/* now check if this directory is on a filesystem which you 
 	   already added */
	fsuse = fs_in_use(clist,fs,tmp);
	if (fsuse == 1) {
		g_snprintf(tmp2,MAXLINE,_("Invalid path to add because it is on the same\nfilesystem as the already added path:\n%s"),tmp);
		show_dialog(ICO_WARN,tmp2,T_OK,NULL,NULL,0);	
		return;
	} else if (fsuse == -1) {
		/* no updated sizes yet - press update first */
		show_dialog(ICO_INFO,_("Please press \"Update\" once before adding new paths."),T_OK,NULL,NULL,0);
		return;
	}

	data[0] = dir;
	data[1] = "N.A.";

	if (free != -1) {
		convert_kbytes2mbminstring(free,tmp);
		data[1] = tmp;
	}

	if (is_dir_writeable(dir) == 0) {
		data[2] = T_YES;
	} else {
		data[2] = T_NO;
	}
	
	row = gtk_clist_append(clist,data);

	/* save the filesystem-device into row-data */
	gtk_clist_set_row_data(clist,row,g_strdup(fs));

	gtk_entry_set_text(GTK_ENTRY(clist_entry),"");

	/* now update again to have all registered paths updated */
	gtk_button_clicked(GTK_BUTTON(updatebutton));

}

void button_imagepath_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];

	show_dir_tree(tmp);
	if (strcmp(tmp,"") != 0) {
		gtk_entry_set_text(GTK_ENTRY(clist_entry),tmp);
	}
}

void update_imagepath_callback(GtkWidget *widget, GtkCList *clist) {
gchar *data[3];
gchar tmp[MAXLINE];
gchar fs[MAXLINE];
gint free, sum;
gint i;
GdkCursor *cursor,*normal_cursor;
GdkWindowAttr *win_attr;
gchar *mnt;
gint marktodelete;

	/* set watch-cursor */
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
		(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);
	/* give gtk time to update cursor */
	gtk_main_iteration_do(FALSE);

	marktodelete = -1;
	sum = 0;
	/* loop through all rows */
	for (i = 0; i < clist->rows; i++) {
		gtk_clist_get_text(clist,i,0,data);
		mnt = (gchar *)gtk_clist_get_row_data(clist,i);

		free = get_free_space(data[0],fs);

		convert_kbytes2mbminstring(free,tmp);

		gtk_clist_set_text(clist,i,1,tmp);

		if (is_dir_writeable(data[0]) == 0) {
			gtk_clist_set_text(clist,i,2,T_YES);
		} else {
			gtk_clist_set_text(clist,i,2,T_NO);
		}

		/* not yet a filesystem registred (updated) for this path? */
		if (mnt == NULL) {
			/* do it now */
			gtk_clist_set_row_data(clist,i,g_strdup(fs));
		}
		
		/* now check if the new updated filesystem is already
		   in use (should never happen - but may possible if the
		   user repartitioned its drive without telling xcdroast) */
		if (fs_in_use2(clist,fs,i) == 1) {
			/* mark the conflicting entry */
			marktodelete = i;
			continue;
		}

		/* add sizes up */
		sum+=free;
	}	
	convert_kbytes2mbminstring(sum,tmp);
	gtk_label_set_text(GTK_LABEL(updatesum_label),tmp);

	/* normal cursor */
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* if we found a conflicting entry - delete it now */
	if (marktodelete != -1) {	
		g_free(gtk_clist_get_row_data(clist,marktodelete));
		gtk_clist_remove(clist,marktodelete);
		show_dialog(ICO_WARN,_("Removed a conflicting path.\nPlease \"Update\" again."),T_OK,NULL,NULL,0);
	}
}

void remove_imagepath_callback(GtkWidget *widget, GtkCList *clist) {
GList *sel;
gint row;

	sel = clist->selection;

	if (sel != NULL) {
		row = GPOINTER_TO_INT(sel->data);
		g_free(gtk_clist_get_row_data(clist,row));
		gtk_clist_remove(clist,row);
	} else {
		show_dialog(ICO_INFO,_("No path selected to remove"),T_OK,NULL,NULL,0);	
	}
}


/* draw hd-setup screen */

void draw_hd_setup(GtkWidget *win) {
GtkWidget *vbox;
GtkWidget *scrolled_win;
GtkWidget *f1,*l1;
gchar *titles[2];
gchar *data[3];
GtkWidget *list;
GtkCList  *clist;
GList *loop;
GtkWidget *tbl;
GtkWidget *b1;
GtkWidget *e1;
gint row;
#ifdef PRIV_COLS 
GtkStyle *style;
GdkColor c;
#endif

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),10);
	gtk_widget_show(vbox);

	f1 = gtk_frame_new(_("Temporary Image Storage Directories"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_container_add(GTK_CONTAINER(f1),scrolled_win);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolled_win);

	titles[0] = _("Path");
	titles[1] = _("Free space (MB/min.)");
	titles[2] = _("Writeable");

	list = gtk_clist_new_with_titles(3,titles);
	gtk_widget_set_usize(GTK_WIDGET(list),0,tbf(150));
	gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	
	clist = GTK_CLIST(list);
	gtk_clist_set_column_auto_resize(clist, 2, TRUE);
	clist_list = clist;

#ifdef PRIV_COLS 
        gdk_color_parse(GTKLISTCOL,&c);
        gdk_color_alloc(gtk_widget_get_colormap(list),&c);

        style = gtk_style_copy(gtk_widget_get_style(list));
        style->base[GTK_STATE_NORMAL] = c;
        gtk_widget_set_style(GTK_WIDGET(list),style);
#endif
	gtk_clist_set_column_width(clist,0,tbf(270));
	gtk_clist_set_column_width(clist,1,tbf(160));
	gtk_clist_set_column_justification(clist, 1, GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_justification(clist, 2, GTK_JUSTIFY_CENTER);

	/* now fill list with current values */
	loop = g_list_first(setupdata.image_dirs);
	while (loop) {
		data[0] = (gchar *)loop->data;
		data[1] = " -"; 
		if (is_dir_writeable((gchar *)loop->data) == 0) {
			data[2] = T_YES;
		} else {
			data[2] = T_NO;
		}
		row = gtk_clist_append(clist,data);
		gtk_clist_set_row_data(clist,row,NULL);
		loop = loop->next;
	}

	gtk_widget_show(list);

	tbl = gtk_table_new(4,8,TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),1,10);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),2,10);

	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,TRUE,10);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("Total space available:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,3,6,0,1);
	gtk_widget_show(f1);

	l1 = gtk_label_new("");
	updatesum_label = l1;
	gtk_container_add(GTK_CONTAINER(f1),l1);
	gtk_widget_show(l1);

	b1 = gtk_button_new_with_label(_("Update"));
	updatebutton = b1;
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,6,8,0,1);
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(update_imagepath_callback),clist);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Calculates all currently free space in the image directories."));

	l1 = rightjust_gtk_label_new(_("Path:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,2,3);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	clist_entry = e1;
 	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(entry_imagepath_callback),clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,6,2,3);
	gtk_widget_show(e1);

	b1 = gtk_button_new_with_label(_("Browse"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,6,8,2,3);
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(button_imagepath_callback),NULL);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Displays a directory selector to pick a new image directory."));

	if (!isroot() && !setupdata.root_option_change_imagedirs) {
		gtk_widget_set_sensitive(e1,FALSE);
		gtk_widget_set_sensitive(b1,FALSE);
	}

	b1 = gtk_button_new_with_label(_("Add"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,2,4,3,4);
 	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(entry_imagepath_callback),clist);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Adds a new image directory."));

	if (!isroot() && !setupdata.root_option_change_imagedirs) {
		gtk_widget_set_sensitive(b1,FALSE);
	}

	b1 = gtk_button_new_with_label(_("Remove"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,4,6,3,4);
 	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(remove_imagepath_callback),clist);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Removes the selected image directory from the list."));
	if (!isroot() && !setupdata.root_option_change_imagedirs) {
		gtk_widget_set_sensitive(b1,FALSE);
	}
}


/* callbacks for misc-menu */

void dspdevice_selected(GtkWidget *item, gchar *device) {

	g_free(setupdata.dsp_device);
	setupdata.dsp_device = g_strdup(device);

	/* set dsp-test-button to active when we set a dsp-device */
	if (strcmp(setupdata.dsp_device,"") != 0) {
		gtk_widget_set_sensitive(btn_testdsp, TRUE);
	} else {
		gtk_widget_set_sensitive(btn_testdsp, FALSE);
	}
}

void dsptest_callback(GtkWidget *widget, gpointer data) {

	show_setup_dsptest();
}

void notifyvia_selected(GtkWidget *item, gpointer data) {

	setupdata.notify_via = 
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));
}

void notifyat_selected(GtkWidget *item, gpointer data) {

	setupdata.notify_at = GPOINTER_TO_INT(data); 
}

void cddb_entry1_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];
	
	g_free(setupdata.cddb_host);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(widget)));
	strip_string(tmp);

	setupdata.cddb_host = g_strdup(tmp);
	gtk_entry_set_text(GTK_ENTRY(widget), tmp);
	gtk_entry_select_region(GTK_ENTRY(widget), 0, 
			GTK_ENTRY(widget)->text_length);
}

void cddb_entry2_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];
	
	setupdata.cddb_port = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
	g_snprintf(tmp, MAXLINE,"%d",setupdata.cddb_port);
	gtk_entry_set_text(GTK_ENTRY(widget),tmp);
	gtk_entry_select_region(GTK_ENTRY(widget), 0, 
			GTK_ENTRY(widget)->text_length);
}

void cddb_entry3_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];
	
	g_free(setupdata.cddb_proxy_host);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(widget)));
	strip_string(tmp);

	setupdata.cddb_proxy_host = g_strdup(tmp);
	gtk_entry_set_text(GTK_ENTRY(widget), tmp);
	gtk_entry_select_region(GTK_ENTRY(widget), 0, 
			GTK_ENTRY(widget)->text_length);
}

void cddb_entry4_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];
	
	setupdata.cddb_proxy_port = atoi(gtk_entry_get_text(GTK_ENTRY(widget)));
	g_snprintf(tmp, MAXLINE,"%d",setupdata.cddb_proxy_port);
	gtk_entry_set_text(GTK_ENTRY(widget),tmp);
	gtk_entry_select_region(GTK_ENTRY(widget), 0, 
			GTK_ENTRY(widget)->text_length);
}

void cddb_use_http_selected(GtkWidget *item, gpointer data) {
gchar tmp[MAXLINE];
	
	setupdata.cddb_use_http = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	if (setupdata.cddb_use_http == 0) {
		gtk_widget_set_sensitive(cddb_entry3, FALSE);
		gtk_widget_set_sensitive(cddb_entry4, FALSE);
		gtk_widget_set_sensitive(cddb_opt2, FALSE);

		/* no long http mode - restore original port */
		gtk_widget_set_sensitive(cddb_entry2, TRUE);
		g_snprintf(tmp, MAXLINE,"%d",setupdata.cddb_port);
		gtk_entry_set_text(GTK_ENTRY(cddb_entry2),tmp);
	} else {
		if (setupdata.cddb_use_proxy == 1) {
			gtk_widget_set_sensitive(cddb_entry3, TRUE);
			gtk_widget_set_sensitive(cddb_entry4, TRUE);
		}
		gtk_widget_set_sensitive(cddb_opt2, TRUE);

		/* http mode uses always port 80 */
		gtk_entry_set_text(GTK_ENTRY(cddb_entry2),"80");
		gtk_widget_set_sensitive(cddb_entry2, FALSE);
	}
}

void cddb_use_proxy_selected(GtkWidget *item, gpointer data) {
	
	setupdata.cddb_use_proxy = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));
	if (setupdata.cddb_use_http == 1 && setupdata.cddb_use_proxy == 0) {
		gtk_widget_set_sensitive(cddb_entry3, FALSE);
		gtk_widget_set_sensitive(cddb_entry4, FALSE);
	}
	if (setupdata.cddb_use_http == 1 && setupdata.cddb_use_proxy == 1) {
		gtk_widget_set_sensitive(cddb_entry3, TRUE);
		gtk_widget_set_sensitive(cddb_entry4, TRUE);
	}
}

void logfile_entry_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];
	
	g_free(setupdata.logfile);
	strcpy(tmp, gtk_entry_get_text(GTK_ENTRY(widget)));
	/* check_tilde(tmp); */

	setupdata.logfile = g_strdup(tmp);
	gtk_entry_set_text(GTK_ENTRY(widget), tmp);
	gtk_entry_select_region(GTK_ENTRY(widget), 0, 
			GTK_ENTRY(widget)->text_length);
}

void logfile_browse_callback(GtkWidget *widget, GtkEntry *entry) {
char tmp[MAXLINE];

	show_file_selector(_("Select Logfile"),gtk_entry_get_text(entry),tmp);
	if (strcmp(tmp,"") != 0) {
		gtk_entry_set_text(entry,tmp);
		g_free(setupdata.logfile);
		setupdata.logfile = g_strdup(gtk_entry_get_text(entry));
	}
}

void loglevel_selected(GtkWidget *item, gpointer level) {

	setupdata.loglevel = GPOINTER_TO_INT(level);
}

void language_selected(GtkWidget *item, gchar *lang) {

	g_free(setupdata.language);
	setupdata.language = g_strdup(lang);
}


/* draw misc-setup screen */

void draw_misc_setup(GtkWidget *win) {
GtkWidget *vbox;
GtkWidget *f1,*l1,*b1,*e1;
GtkWidget *tbl;
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GSList *group;
GtkWidget *btn, *check;
GList *dsp;
gint i;
gint menuhistory, menuidx, menulang;
gchar tmp[MAXLINE];
static const gchar *lang_array[] = AVAIL_LANG;

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),10);
	gtk_widget_show(vbox);

	f1 = gtk_frame_new(_("Audio"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,0);
	gtk_widget_show(f1);

	tbl = gtk_table_new(4,8,TRUE);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),2,10);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("DSP-Device:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,0,1);
	gtk_widget_show(l1);

	/* get a list of all dsp-devices */
	dsp = get_dsp_devices();

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	menuidx = 0; menuhistory = 0;
	/* "none"-setting */
	menu_item = gtk_menu_item_new_with_label(_("None"));
	gtk_signal_connect(GTK_OBJECT(menu_item),
		"activate", GTK_SIGNAL_FUNC(dspdevice_selected),
		"");
	gtk_menu_append (GTK_MENU (menu), menu_item);
	if (strcmp(setupdata.dsp_device,"") == 0) { menuhistory = menuidx; }
	menuidx++;
	gtk_widget_show (menu_item);

	while (dsp) {
		menu_item = gtk_menu_item_new_with_label((gchar *)dsp->data);
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(dspdevice_selected),
			(gchar *)dsp->data);
		gtk_menu_append (GTK_MENU (menu), menu_item);

		if (setupdata.dsp_device != NULL) {
			if (strcmp(setupdata.dsp_device,(gchar *)dsp->data) == 0) {
				menuhistory = menuidx;
			}
		}
		menuidx++;
		gtk_widget_show (menu_item);

		dsp = dsp->next;
	}
	
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,3,6,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("The soundcard device. Used to play warning sounds or audio tracks."));

	b1 = gtk_button_new_with_label(_("Test"));
	btn_testdsp = b1;
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(dsptest_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,6,7,0,1);
	gtk_widget_show(b1);
	define_tooltip(b1,_("Plays a demo sample on the soundcard to verify if its working correctly."));

	/* only allow test when device is set */
	if (strcmp(setupdata.dsp_device,"") == 0) {
		gtk_widget_set_sensitive(btn_testdsp, FALSE);
	}

	l1 = rightjust_gtk_label_new(_("Notify-Beeps via:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,1,2);
	gtk_widget_show(l1);

	btn = gtk_radio_button_new_with_label(NULL,_("DSP-Device"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,3,5,1,2);
	gtk_widget_show(btn);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,_("internal speaker"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(notifyvia_selected),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,5,7,1,2);
	gtk_widget_show(btn);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),
		setupdata.notify_via);
	
	l1 = rightjust_gtk_label_new(_("at events:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,2,3);
	gtk_widget_show(l1);

	btn = gtk_radio_button_new_with_label(NULL,_("never"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(notifyat_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,3,5,2,3);
	gtk_widget_show(btn);
	if (setupdata.notify_at == 0) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,_("always"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(notifyat_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,5,7,2,3);
	gtk_widget_show(btn);
	if (setupdata.notify_at == 1) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,_("on completion"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(notifyat_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,3,5,3,4);
	gtk_widget_show(btn);
	if (setupdata.notify_at == 2) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,_("on warnings"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,5,7,3,4);
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(notifyat_selected),GINT_TO_POINTER(3));
	gtk_widget_show(btn);
	if (setupdata.notify_at == 3) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);

	/* -- */
	
	f1 = gtk_frame_new(_("Network"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,10);
	gtk_widget_show(f1);

	tbl = gtk_table_new(2,32,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),11,10);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("CDDB-Server:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,12,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cddb_entry1 = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(cddb_entry1_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,12,19,0,1);
	if (setupdata.cddb_host != NULL) {
		gtk_entry_set_text(GTK_ENTRY(e1),setupdata.cddb_host);
	}
	gtk_widget_show(e1);
	define_tooltip(e1,_("The CDDB-Server to connect to in order to download track-titles from the internet."));

	l1 = rightjust_gtk_label_new(_("Port:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,19,22,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cddb_entry2 = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(cddb_entry2_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,22,25,0,1);
	g_snprintf(tmp, MAXLINE,"%d",setupdata.cddb_port);
	gtk_entry_set_text(GTK_ENTRY(e1),tmp);
	gtk_widget_show(e1);

	check = gtk_check_button_new_with_label(_("Use HTTP"));
	cddb_opt1 = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(cddb_use_http_selected), NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,25,32,0,1);
	gtk_widget_show(check);
	define_tooltip(check, _("Use the HTTP protocol rather than the CDDB protocol to access the CDDB-Server."));

	l1 = rightjust_gtk_label_new(_("via HTTP-Proxy:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,12,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cddb_entry3 = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(cddb_entry3_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,12,19,1,2);
	if (setupdata.cddb_proxy_host != NULL) {
		gtk_entry_set_text(GTK_ENTRY(e1),setupdata.cddb_proxy_host);
	}
	gtk_widget_show(e1);
	define_tooltip(e1,_("If you are behind a firewall you may require to use a HTTP-proxy to reach the CDDB-Server. If your proxy requires authentication you can use the following syntax: \"user:password@proxyhost\""));

	l1 = rightjust_gtk_label_new(_("Port:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,19,22,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cddb_entry4 = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(cddb_entry4_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,22,25,1,2);
	g_snprintf(tmp, MAXLINE,"%d",setupdata.cddb_proxy_port);
	gtk_entry_set_text(GTK_ENTRY(e1),tmp);
	gtk_widget_show(e1);

	check = gtk_check_button_new_with_label(_("Use Proxy"));
	cddb_opt2 = check;
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(cddb_use_proxy_selected), NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,25,32,1,2);
	gtk_widget_show(check);
	define_tooltip(check, _("Don't connect directly to the CDDB-Server, but use a HTTP-proxy instead."));

	/* set editable fields according to current settings */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cddb_opt1),
		setupdata.cddb_use_http);
	cddb_use_http_selected(cddb_opt1, NULL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cddb_opt2),
		setupdata.cddb_use_proxy);
	cddb_use_proxy_selected(cddb_opt2, NULL);

	/* -- */

	f1 = gtk_frame_new(_("Logging"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,0);
	gtk_widget_show(f1);

	tbl = gtk_table_new(2,8,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),2,10);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("Logfile:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	log_entry = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(logfile_entry_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,6,0,1);
	if (setupdata.logfile != NULL) {
		gtk_entry_set_text(GTK_ENTRY(e1),setupdata.logfile);
	}
	gtk_widget_show(e1);
	define_tooltip(e1,_("The name of the file that logs all actions of X-CD-Roast."));

	b1 = gtk_button_new_with_label(_("Browse"));
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(logfile_browse_callback),GTK_ENTRY(e1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,6,8,0,1);
	gtk_widget_show(b1);

	if (!isroot() && !setupdata.root_option_change_logoptions) {
		gtk_widget_set_sensitive(e1,FALSE);
		gtk_widget_set_sensitive(b1,FALSE);
	}

	l1 = rightjust_gtk_label_new(_("Loglevel:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,1,2);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	/* loglevels */
	menu_item = gtk_menu_item_new_with_label(_("Off"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(loglevel_selected),GINT_TO_POINTER(0));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);
	menu_item = gtk_menu_item_new_with_label(_("Sparse"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(loglevel_selected),GINT_TO_POINTER(1));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);
	menu_item = gtk_menu_item_new_with_label(_("Medium"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(loglevel_selected),GINT_TO_POINTER(2));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);
	menu_item = gtk_menu_item_new_with_label(_("Verbose"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(loglevel_selected),GINT_TO_POINTER(3));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu), 
		setupdata.loglevel);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,3,6,1,2);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("How much information is logged into the logfile."));

	if (!isroot() && !setupdata.root_option_change_logoptions) {
		gtk_widget_set_sensitive(omenu,FALSE);
	}

	f1 = gtk_frame_new(_("Internationalization"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,10);
	gtk_widget_show(f1);

	tbl = gtk_table_new(1,8,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("Language:"));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,3,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	i = 0; 
	menulang = 0;

	/* add default setting */

#if ENABLE_NLS

	menu_item = gtk_menu_item_new_with_label(_("System default"));
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(language_selected),"");
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);

	while(lang_array[i]) {

		/* count valid languages */
		if (strcmp(setupdata.language, lang_array[i+1]) == 0) 
			menulang = i/2+1;

		menu_item = gtk_menu_item_new_with_label(
			lang_array[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(language_selected),(gpointer)lang_array[i+1]);
		gtk_menu_append (GTK_MENU (menu), menu_item);
		gtk_widget_show (menu_item);
		i+=2;
	}
#else
	menu_item = gtk_menu_item_new_with_label(lang_array[0]);
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);
	gtk_widget_set_sensitive(omenu,FALSE);
#endif

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu), menulang);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,3,6,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,_("Set the language: You have to leave setup to activate this setting. Please note that switching directly to languages that require a different font will not work correctly."));

}


/* callbacks for misc-setup2 */

void options_selected(GtkWidget *item, gpointer nr) {
gint sel;

	sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	switch (GPOINTER_TO_INT(nr)) {
		case 0:
			setupdata.option_tooltips = sel;
			break;
		case 1:
			setupdata.option_autoraise = sel;
			break;
		case 2:
			setupdata.option_savepos = sel;
			break;
		case 3:
			setupdata.option_personimage = sel;
			break;
		case 4:
			setupdata.option_overwritewarn = sel;
			break;
		case 5:
			setupdata.option_autodelete = sel;
			break;
		case 6:
			setupdata.option_titleprogress = sel;
			break;
		case 7:
			setupdata.option_displaycdtext = sel;
			break;
		case 8:
			setupdata.option_selectionmode = sel;
			break;
	}
}


void defwritemode_selected(GtkWidget *item, gpointer level) {

	setupdata.def_write_mode = GPOINTER_TO_INT(level);
	curset.writemode = setupdata.def_write_mode;
}


/* draw misc-setup screen part 2 */

void draw_misc2_setup(GtkWidget *win) {
GtkWidget *vbox, *txt, *scrolled_win;
GtkWidget *f1, *l1;
GtkWidget *tbl;
GtkWidget *check;
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
gint i;
static const gchar *writemodes[] = WRITE_MODES;
static const gchar *helpwritemodes[] = HELP_WRITE_MODES;
gchar tmp[MAXLINE];

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),10);
	gtk_widget_show(vbox);

	f1 = gtk_frame_new(_("Options"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,0);
	gtk_widget_show(f1);

	tbl = gtk_table_new(9,8,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_widget_show(tbl);

	check = gtk_check_button_new_with_label(_("Tooltips help"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,0,1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_tooltips);
	gtk_widget_show(check);
	define_tooltip(check, _("Display help when pausing the mouse pointer over a button."));

	check = gtk_check_button_new_with_label(_("Auto-raise/lower windows"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,1,2);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_autoraise);
	gtk_widget_show(check);
	gtk_widget_set_sensitive(check, FALSE);
	define_tooltip(check, _("Not implemented yet"));

	check = gtk_check_button_new_with_label(_("Save window positions"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,2,3);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_savepos);
	gtk_widget_show(check);
	gtk_widget_set_sensitive(check, FALSE);
	define_tooltip(check, _("Not implemented yet"));

	check = gtk_check_button_new_with_label(_("Personalize image filenames"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(3));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,3,4);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_personimage);
	gtk_widget_show(check);
	gtk_widget_set_sensitive(check, FALSE);
	define_tooltip(check, _("Not implemented yet"));

	check = gtk_check_button_new_with_label(_("Warn before overwriting images"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(4));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,4,5);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_overwritewarn);
	gtk_widget_show(check);
	define_tooltip(check, _("When reading or creating new tracks do warn before overwriting existing tracks on the hard drive."));

	check = gtk_check_button_new_with_label(_("Automatically delete images after burn"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(5));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,5,6);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_autodelete);
	gtk_widget_show(check);
	gtk_widget_set_sensitive(check, FALSE);
	define_tooltip(check, _("Not implemented yet"));

	check = gtk_check_button_new_with_label(_("Progress-indicator in window-title"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(6));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,6,7);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_titleprogress);
	gtk_widget_show(check);
	gtk_widget_set_sensitive(check, FALSE);
	define_tooltip(check, _("Not implemented yet"));

	check = gtk_check_button_new_with_label(_("Display CD-Text if available"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(7));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,7,8);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_displaycdtext);
	gtk_widget_show(check);
	define_tooltip(check, _("Display CD-Text in Info-Screen when available by CD-ROM and CD."));

	check = gtk_check_button_new_with_label(_("Windows style list selections"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(options_selected),GINT_TO_POINTER(8));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,7,8,9);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.option_selectionmode);
	gtk_widget_show(check);
	define_tooltip(check, _("When enabled, then multiple selections in lists are handled like the lists in Windows (hold CTRL-Key to select more than one entry and use SHIFT to select a whole range of entries)."));


	f1 = gtk_frame_new(_("Default Write Options"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,10);
	gtk_widget_show(f1);

	tbl = gtk_table_new(1,8,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),2,10);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("Default Write Mode: "));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	i = 0;
        while (writemodes[i]) {
                menu_item = gtk_menu_item_new_with_label(_(writemodes[i]));
                gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                        GTK_SIGNAL_FUNC(defwritemode_selected),
                        GINT_TO_POINTER(i));
                gtk_menu_append (GTK_MENU (menu), menu_item);
                gtk_widget_show (menu_item);
                if (helpwritemodes[i])
                        define_tooltip(menu_item,(gchar *)_(helpwritemodes[i]));
                i++;
        }

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu), 
		setupdata.def_write_mode);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,3,6,0,1);
	gtk_widget_show(omenu);
        /* concat 2 help strings */
        g_snprintf(tmp,MAXLINE,"%s %s",_("Choose which write mode you want to use with your CD-Writer. Not all modes are supported with all writers. Try \"DAO\" first, because its usually the best option. If the write fails, try one of the \"TAO\" modes."), _("Click an option and hold the button to get additional help for each mode."));
	define_tooltip(omenu, tmp);

	if (!isroot() && !setupdata.root_option_change_writeparam) {
		gtk_widget_set_sensitive(omenu,FALSE);
	}

	f1 = gtk_frame_new(_("cdrecord-ProDVD key"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	tbl = gtk_table_new(1,8,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),2,10);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(_("CDR_SECURITY key: "));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
	gtk_widget_show(l1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_table_attach_defaults(GTK_TABLE(tbl),scrolled_win,3,8,0,1);
	gtk_widget_show(scrolled_win);

	txt = gtk_text_new(NULL,NULL);
	prodvdkey_txt = txt;
	gtk_text_set_editable(GTK_TEXT(txt),TRUE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),FALSE);
	gtk_widget_set_usize(txt,0,tbf(32));
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);
	define_tooltip(txt, _("Cut & Paste your CDR_SECURITY key from cdrecord-ProDVD into this area. Please refer to the FAQ on how to obtain such a key."));

	gtk_text_freeze(GTK_TEXT(txt));
	gtk_text_insert(GTK_TEXT(txt), NULL, NULL, NULL, setupdata.ProDVDkey,
		strlen(setupdata.ProDVDkey));
	gtk_text_set_point(GTK_TEXT(txt),0);
	gtk_text_thaw(GTK_TEXT(txt));
	
	if (curset.isProDVD == 0) {
		gtk_widget_set_sensitive(f1, FALSE);
		gtk_widget_set_sensitive(l1, FALSE);
		gtk_widget_set_sensitive(txt, FALSE);
	}
}


/* callbacks for nonroot */

void root_options_selected(GtkWidget *item, gpointer nr) {
gint sel;

	sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	switch (GPOINTER_TO_INT(nr)) {
		case 0:
			setupdata.root_option_change_writer = sel;
			break;
		case 1:
			setupdata.root_option_change_writeparam = sel;
			break;
		case 2:
			setupdata.root_option_change_reader = sel;
			break;
		case 3:
			setupdata.root_option_change_readparam = sel;
			break;
		case 4:
			setupdata.root_option_change_imagedirs = sel;
			break;
		case 5:
			setupdata.root_option_change_logoptions = sel;
			break;
	}
}


void entry_rootusers_callback(GtkWidget *widget, GtkCList *clist) {
gchar user[MAXLINE], tmp2[MAXLINE];
gchar *data[1];
gint row,i,stat;

	strcpy(user,gtk_entry_get_text(GTK_ENTRY(rootusers_entry)));
	strip_string(user);

	/* ignore empty entry */
	if (strcmp(user,"") == 0) {
		return;
	}

	/* and now if user is already added */
	for (i = 0; i < clist->rows; i++) {
		gtk_clist_get_text(clist,i,0,data);	
		if (strcmp(data[0],user) == 0) {
			g_snprintf(tmp2,MAXLINE,_("User \"%s\" already added"),user);
			show_dialog(ICO_WARN,tmp2,T_OK,NULL,NULL,0);	
			return;
		}
	}

	/* now check if user does exist */
	if (!check_pw_user(user)) {
		g_snprintf(tmp2,MAXLINE,_("User \"%s\" does not exist.\nAdd anyway?"),user);
		stat = show_dialog(ICO_WARN,tmp2,T_NO,T_YES,NULL,0);	
		if (stat == 0) return;
	}

	data[0] = user;
	row = gtk_clist_append(clist,data);
	
	/* scroll to newly added entry */
	gtk_clist_moveto(clist,row,0,0.0,1.0);

	gtk_entry_set_text(GTK_ENTRY(rootusers_entry),"");

}

void remove_rootusers_callback(GtkWidget *widget, GtkCList *clist) {
GList *sel;
gint row;

	sel = clist->selection;

	if (sel == NULL) {
		/* nothing selected to remove */
		show_dialog(ICO_WARN,_("No user selected to remove"),T_OK,NULL,NULL,0);	
	}

	while (sel) {
		row = GPOINTER_TO_INT(sel->data);
		gtk_clist_remove(clist,row);
		sel = clist->selection;
	}
}

void entry_roothosts_callback(GtkWidget *widget, GtkCList *clist) {
gchar host[MAXLINE],tmp2[MAXLINE];
gchar *data[1];
gint row,i;

	strcpy(host,gtk_entry_get_text(GTK_ENTRY(roothosts_entry)));
	strip_string(host);

	/* ignore empty entry */
	if (strcmp(host,"") == 0) {
		return;
	}

	/* and now if user is already added */
	for (i = 0; i < clist->rows; i++) {
		gtk_clist_get_text(clist,i,0,data);	
		if (strcmp(data[0],host) == 0) {
			g_snprintf(tmp2,MAXLINE,_("Host \"%s\" already added"),host);
			show_dialog(ICO_WARN,tmp2,T_OK,NULL,NULL,0);	
			return;
		}
	}

	data[0] = host;
	row = gtk_clist_append(clist,data);
	
	/* scroll to newly added entry */
	gtk_clist_moveto(clist,row,0,0.0,1.0);

	gtk_entry_set_text(GTK_ENTRY(roothosts_entry),"");

}

void remove_roothosts_callback(GtkWidget *widget, GtkCList *clist) {
GList *sel;
gint row;

	sel = clist->selection;

	if (sel == NULL) {
		/* nothing selected to remove */
		show_dialog(ICO_WARN,_("No host selected to remove"),T_OK,NULL,NULL,0);	
	}

	while (sel) {
		row = GPOINTER_TO_INT(sel->data);
		gtk_clist_remove(clist,row);
		sel = clist->selection;
	}
}


void root_users_selected(GtkWidget *item, gpointer data) {

        setupdata.root_users_access = GPOINTER_TO_INT(data); 
}

void root_hosts_selected(GtkWidget *item, gpointer data) {

        setupdata.root_hosts_access = GPOINTER_TO_INT(data); 
}


/* display non-root-mode configurator */

void clicked_nrm_selector(GtkWidget *widget, gpointer data) {
gint nrm;

	nrm = query_nonrootmode();
	create_nonroot_configurator(nrm, 1);
}


/* draw non-root menu */

void draw_nonroot_setup(GtkWidget *win) {
GtkWidget *vbox, *hbox;
GtkWidget *tbl, *tbl2;
GtkWidget *f1, *b1, *e1;
GtkWidget *scrolled_win;
GtkWidget *list;
GtkWidget *btn, *check;
GSList *group;
GList *loop;
gchar *data[1];

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),10);
	gtk_widget_show(vbox);

	/* left and right frame */
	tbl = gtk_table_new(1,2,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),0,5);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

	f1 = gtk_frame_new(_("Access by users:"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,0,1,0,1);
	gtk_widget_show(f1);

	tbl2 = gtk_table_new(5,14,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl2),9,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl2),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl2);
	gtk_widget_show(tbl2);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),scrolled_win,6,14,0,3);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolled_win);

	list = gtk_clist_new(1);
	users_clist = GTK_CLIST(list);
	gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	gtk_clist_set_column_auto_resize(users_clist, 0, TRUE);
	if (setupdata.option_selectionmode == 0) {
		gtk_clist_set_selection_mode (users_clist, GTK_SELECTION_MULTIPLE);
	} else {
		gtk_clist_set_selection_mode (users_clist, GTK_SELECTION_EXTENDED);
	}

	gtk_widget_show(list);

	/* now add current values */
        loop = g_list_first(setupdata.root_users_lists);
	while (loop) {
                data[0] = (gchar *)loop->data;
                gtk_clist_append(users_clist,data);
                loop = loop->next;
        }


	e1 = gtk_entry_new();
	rootusers_entry = e1;
        gtk_signal_connect(GTK_OBJECT(e1), "activate",
                GTK_SIGNAL_FUNC(entry_rootusers_callback),users_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),e1,6,14,3,4);
	gtk_widget_show(e1);
	define_tooltip(e1, _("Enter here an username which should be allowed or denied access for X-CD-Roast. Press Return or click on the \"Add\"-button to put it on the list."));

	/* add button */
	b1 = gtk_button_new_with_label(_("Add"));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(entry_rootusers_callback),users_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),b1,6,10,4,5);
	gtk_widget_show(b1);
	define_tooltip(b1, _("Add the username given in the entry-field to the list."));

	/* remove button */
	b1 = gtk_button_new_with_label(_("Remove"));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(remove_rootusers_callback),users_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),b1,10,14,4,5);
	gtk_widget_show(b1);
	define_tooltip(b1, _("Remove all selected users from the list."));

	btn = gtk_radio_button_new_with_label(NULL,_("Allow all"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_users_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,0,1);
	gtk_widget_show(btn);
	define_tooltip(btn, _("All users are allowed to start X-CD-Roast."));
        if (setupdata.root_users_access == 0) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("None allowed"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_users_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,1,2);
	gtk_widget_show(btn);
	define_tooltip(btn, _("No users are allowed to start X-CD-Roast (except root)."));
        if (setupdata.root_users_access == 1) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("All in list"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_users_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,2,3);
	gtk_widget_show(btn);
	define_tooltip(btn, _("Only the users which were added to the list are allowed to start X-CD-Roast."));
        if (setupdata.root_users_access == 2) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("All, but listed"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_users_selected),GINT_TO_POINTER(3));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,3,4);
	gtk_widget_show(btn);
	define_tooltip(btn, _("All users on the list are not allowed to start X-CD-Roast. All others may use it."));
        if (setupdata.root_users_access == 3) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);

	/* right frame */
	f1 = gtk_frame_new(_("Access by hosts:"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,1,2,0,1);
	gtk_widget_show(f1);

	tbl2 = gtk_table_new(5,14,TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl2),9,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl2),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl2);
	gtk_widget_show(tbl2);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),scrolled_win,6,14,0,3);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolled_win);

	list = gtk_clist_new(1);
	hosts_clist = GTK_CLIST(list);
	gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	gtk_clist_set_column_auto_resize(hosts_clist, 0, TRUE);
	if (setupdata.option_selectionmode == 0) {
		gtk_clist_set_selection_mode (hosts_clist, GTK_SELECTION_MULTIPLE);
	} else {
		gtk_clist_set_selection_mode (hosts_clist, GTK_SELECTION_EXTENDED);
	}
	gtk_widget_show(list);

	/* now add current values */
        loop = g_list_first(setupdata.root_hosts_lists);
	while (loop) {
                data[0] = (gchar *)loop->data;
                gtk_clist_append(hosts_clist,data);
                loop = loop->next;
        }

	e1 = gtk_entry_new();
	roothosts_entry = e1;
        gtk_signal_connect(GTK_OBJECT(e1), "activate",
                GTK_SIGNAL_FUNC(entry_roothosts_callback),hosts_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),e1,6,14,3,4);
	gtk_widget_show(e1);
	define_tooltip(e1, _("Enter here a hostname of a computer which may run X-CD-Roast. This makes sense, when using the same config-file on more than one host (e.g. pool-installations)."));

	/* add button */
	b1 = gtk_button_new_with_label(_("Add"));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(entry_roothosts_callback),hosts_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),b1,6,10,4,5);
	gtk_widget_show(b1);
	define_tooltip(b1, _("Add the hostname given in the entry-field to the list."));

	/* remove button */
	b1 = gtk_button_new_with_label(_("Remove"));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(remove_roothosts_callback),hosts_clist);
	gtk_table_attach_defaults(GTK_TABLE(tbl2),b1,10,14,4,5);
	gtk_widget_show(b1);
	define_tooltip(b1, _("Remove all selected hosts from the list."));

	btn = gtk_radio_button_new_with_label(NULL,_("Allow all"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_hosts_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,0,1);
	gtk_widget_show(btn);
	define_tooltip(btn, _("X-CD-Roast may be started on all hosts."));
        if (setupdata.root_hosts_access == 0) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("None allowed"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_hosts_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,1,2);
	gtk_widget_show(btn);
	define_tooltip(btn, _("X-CD-Roast won't start on any host (except when run by root)."));
        if (setupdata.root_hosts_access == 1) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("All in list"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_hosts_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,2,3);
	gtk_widget_show(btn);
	define_tooltip(btn, _("Only the hosts in the list may start X-CD-Roast."));
        if (setupdata.root_hosts_access == 2) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	btn = gtk_radio_button_new_with_label(group,_("All, but listed"));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(root_hosts_selected),GINT_TO_POINTER(3));
	gtk_table_attach_defaults(GTK_TABLE(tbl2),btn,0,6,3,4);
	gtk_widget_show(btn);
	define_tooltip(btn, _("Only hosts which are not listed can start X-CD-Roast."));
        if (setupdata.root_hosts_access == 3) 
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);

	/* options */

	f1 = gtk_frame_new(_("Users are allowed to:"));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,FALSE,TRUE,10);
	gtk_widget_show(f1);

	tbl = gtk_table_new(4,16,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add (GTK_CONTAINER (f1), tbl);
	gtk_widget_show(tbl);

	check = gtk_check_button_new_with_label(_("change CD Writer Device"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,9,0,1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_writer);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user is allowed to change the settings for the CD Writer. Else the setting given by root must be used."));

	check = gtk_check_button_new_with_label(_("change write parameters"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,9,16,0,1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_writeparam);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user is allowed the change the write parameters for the CD Writer (e.g. Speed and FIFO-Buffer-Size)."));

	check = gtk_check_button_new_with_label(_("change CD Reader Device"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,9,1,2);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_reader);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user is allowed to change the settings for the CD Readers. Else the settings given by root must be used."));

	check = gtk_check_button_new_with_label(_("change read parameters"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(3));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,9,16,1,2);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_readparam);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user is allowed the change the read parameters for the CD Readers (e.g. Speed and overlap sectors)."));

	check = gtk_check_button_new_with_label(_("change Image Storage Directories"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(4));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,9,2,3);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_imagedirs);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user may give his own image-directories (best where he got write permissions). Else the directories specified by root must be used (should be also a directory where any user can write into)."));

	check = gtk_check_button_new_with_label(_("change Logging-Options"));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(root_options_selected),GINT_TO_POINTER(5));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,9,3,4);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		setupdata.root_option_change_logoptions);
	gtk_widget_show(check);
	define_tooltip(check, _("If enabled, then the user may change the logging parameters (the path of the logfile and the loglevel)."));

	hbox = gtk_alignment_new(0.5, 0.5, 0.5, 0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,10);
	gtk_widget_show(hbox);

	/* non root config mode selector */
	b1 = gtk_button_new_with_label(_("Change Non-Root configuration"));
        gtk_signal_connect(GTK_OBJECT(b1), "clicked",
                GTK_SIGNAL_FUNC(clicked_nrm_selector),NULL);
	gtk_container_add(GTK_CONTAINER(hbox),b1);
	gtk_widget_show(b1);
	define_tooltip(b1, _("Choose if you want to enable or disable the Non-Root-Mode of X-CD-Roast. If you enable the Non-Root-Mode then you do not need to become root first in order to use X-CD-Roast."));
}


/* called by the setup-button */

void create_setup() {
GtkWidget *side_t;
GtkWidget *side_t_btn2;
GtkWidget *side_t_btn3;
GtkWidget *side_t_btn4;
GtkWidget *notebook,*f1,*l1;
GtkWidget *head,*head_l;
gint i, found;

	/* backup the current setup-data */
	memcpy(&bak_setupdata,&setupdata,sizeof(setup_data_t)); 
	bak_setupdata.image_dirs = NULL;
	copy_glist(&bak_setupdata.image_dirs, setupdata.image_dirs); 
#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	if (isroot()) {
		bak_setupdata.root_users_lists = NULL;
		copy_glist(&bak_setupdata.root_users_lists, setupdata.root_users_lists); 
		bak_setupdata.root_hosts_lists = NULL;
		copy_glist(&bak_setupdata.root_hosts_lists, setupdata.root_hosts_lists); 
	}
#endif
	bak_setupdata.dsp_device = g_strdup(setupdata.dsp_device);
	bak_setupdata.mix_device = g_strdup(setupdata.mix_device);
	bak_setupdata.cddb_host = g_strdup(setupdata.cddb_host);
	bak_setupdata.cddb_proxy_host = g_strdup(setupdata.cddb_proxy_host);
	bak_setupdata.logfile = g_strdup(setupdata.logfile);
	bak_setupdata.ProDVDkey = g_strdup(setupdata.ProDVDkey);


	clear_sidespace();
	clear_workspace();

        side_t = gtk_table_new(10,10, TRUE);
        gtk_table_set_row_spacings(GTK_TABLE(side_t),10);

        gtk_box_pack_start(GTK_BOX(sidespace), side_t,TRUE,TRUE,0);

        side_t_btn2 = gtk_button_new_with_label (_("Save configuration"));
        side_t_btn3 = gtk_button_new_with_label (T_OK);
        side_t_btn4 = gtk_button_new_with_label (T_CANCEL);

	gtk_signal_connect (GTK_OBJECT (side_t_btn2), "clicked",
                GTK_SIGNAL_FUNC(menu_setup_save),NULL);

	gtk_signal_connect (GTK_OBJECT (side_t_btn3), "clicked",
                GTK_SIGNAL_FUNC(menu_setup_ok),NULL);

	gtk_signal_connect (GTK_OBJECT (side_t_btn4), "clicked",
                GTK_SIGNAL_FUNC(menu_setup_cancel),NULL);


        gtk_table_attach_defaults(GTK_TABLE(side_t), side_t_btn2, 0,10,5,6);
        gtk_widget_show(side_t_btn2);
        define_tooltip(side_t_btn2,_("Saves your current configuration."));

        gtk_table_attach_defaults(GTK_TABLE(side_t), side_t_btn3, 0,10,7,8);
        gtk_widget_show(side_t_btn3);
        define_tooltip(side_t_btn3,_("Accept the current configuration and return to main menu."));

        gtk_table_attach_defaults(GTK_TABLE(side_t), side_t_btn4, 0,10,8,9);
        gtk_widget_show(side_t_btn4);
        define_tooltip(side_t_btn4,_("Cancel all changes and return to main menu."));

        gtk_widget_show(side_t);
	gtk_widget_show(sidespace);

	/* draw workspace */

	head = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(head),GTK_SHADOW_IN);
	gtk_widget_set_usize(head,0,45);
	gtk_box_pack_start(GTK_BOX(workspace), head,FALSE,TRUE,0);
	gtk_widget_show(head);
	head_l = gtk_label_new(_("Setup"));
	set_font_and_color(head_l,BIGFONT,NULL);
	gtk_container_add(GTK_CONTAINER(head),head_l);
	gtk_widget_show(head_l);
	gtk_widget_show(workspace);

	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(workspace), notebook,TRUE,TRUE,10);
	gtk_widget_show(notebook);

	l1 = gtk_label_new(_("Device-Scan"));
	f1 = gtk_frame_new(NULL);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
	gtk_widget_show(f1);
	draw_scsi_scan(f1);

	l1 = gtk_label_new(_("CD Settings"));
	f1 = gtk_frame_new(NULL);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
	gtk_widget_show(f1);
	draw_cd_setup(f1);

	l1 = gtk_label_new(_("HD Settings"));
	f1 = gtk_frame_new(NULL);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
	gtk_widget_show(f1);
	draw_hd_setup(f1);

	l1 = gtk_label_new(_("Miscellaneous"));
	f1 = gtk_frame_new(NULL);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
	gtk_widget_show(f1);
	draw_misc_setup(f1);

	l1 = gtk_label_new(_("Options"));
	f1 = gtk_frame_new(NULL);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
	gtk_widget_show(f1);
	draw_misc2_setup(f1);

#if !(defined(__MACH__) && defined(__APPLE__)) && (USE_NONROOTMODE == 1)
	if (isroot()) {
		/* non root mode? */
		l1 = gtk_label_new(_("Users"));
		f1 = gtk_frame_new(NULL);
		gtk_container_set_border_width (GTK_CONTAINER (f1), 10);
		gtk_notebook_append_page(GTK_NOTEBOOK (notebook),f1,l1);
		gtk_widget_show(f1);
		draw_nonroot_setup(f1);
	}
#endif

	/* check if found any cdrom/writer at all */
	i = 0;
	found = 0;
	while(scsidevices[i] != NULL) {
		if (scsidevices[i]->type == 4 || scsidevices[i]->type == 5 ) {
			found++;
		}
		i++;
	}
	if (found == 0) {
		/* no devices found */
		show_dialog(ICO_WARN, _("No CD-Writer or CD-ROM device detected.\nFor ATAPI/IDE devices under Linux you have to enable\nSCSI-Emulation in the kernel in order to activate them.\nPlease see the X-CD-Roast manual how to do that."), T_OK, NULL, NULL, 0);
	}	
}


/* called on delete event of nrm-configurator */
static gint nrs_dialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {

	nrs_dialog_done = -1;
	return (TRUE);
}


/* show dialog for non-root configurator */

void create_nonroot_configurator(gint nonrootmode, gint fromsetup) {
GtkWidget *dialog, *page, *l1, *f1, *vbox, *xcdroast_logo;
GdkPixbuf *im, *im2;
GdkPixmap *p;
GdkBitmap *m;
gchar tmp[MAXLINE];
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;

	/* if another dialog is running, ignore */
	if (nrs_dialog_done == 999) {
		return;
	}

	dodebug(8, "displaying create_nonroot_configurator\n");

	/* mark our dialog as running */
	nrs_dialog_done = 999;

	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	nrs_dialog = dialog;
	gtk_window_set_title(GTK_WINDOW(dialog),T_XCDROAST);
	gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, TRUE, FALSE);
	gtk_widget_set_usize(dialog,tbf(365),0);

	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (nrs_dialog_delete_event), (gpointer) dialog);

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);
	gtk_widget_show(vbox);

	/* load the half scaled logo */
	g_snprintf(tmp,MAXLINE,"%s/%s", sharedir, XCDRLOGO);
	im=gdk_pixbuf_new_from_file(tmp);
	if (im) {
		im2 = gdk_pixbuf_scale_simple(im, 
			gdk_pixbuf_get_width(im)/2, 
			gdk_pixbuf_get_height(im)/2, 
			GDK_INTERP_TILES);
		gdk_pixbuf_render_pixmap_and_mask(im2, &p, &m, 128);
        	xcdroast_logo = gtk_pixmap_new(p,m);
		gdk_pixbuf_unref(im);
		gdk_pixbuf_unref(im2);
	} else {
		xcdroast_logo = gtk_label_new("[LOGO]");
	}
	gtk_box_pack_start(GTK_BOX(vbox),xcdroast_logo,FALSE,FALSE,0);
	gtk_widget_show(xcdroast_logo);	

	g_snprintf(tmp,MAXLINE,_("Version %s"),XCDROAST_VERSION);
	l1 = gtk_label_new(tmp);	
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	set_font_and_color(l1,NULL,"red");
	gtk_box_pack_start(GTK_BOX(vbox),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	nrs_frame = f1;
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_widget_show(f1);

	/* show first page of configurator */
	page = gen_nonroot_page1(nonrootmode, fromsetup);
	nrs_page = page;
	nrs_mode = nonrootmode;
	nrs_fromsetup = fromsetup;
	gtk_container_add(GTK_CONTAINER(f1),page);
	gtk_widget_show(page);

        /* grab cursor and change to watch */
        if (GTK_WIDGET_MAPPED(toplevel)) {
                gtk_grab_add(dialog);
                gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
                        (gpointer) &win_attr);
                normal_cursor = win_attr->cursor;
                cursor = gdk_cursor_new(GDK_WATCH);
                gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
                gdk_cursor_destroy (cursor);
        }

        /* only center window when toplevel visible */
        if ( GTK_WIDGET_VISIBLE(toplevel)) {
                gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
                gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);                gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);                gtk_widget_size_request(dialog,&rq);
                gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
        } else {
                /* otherwise center in screen */
                gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
                xsize = gdk_screen_width();
                ysize = gdk_screen_height();
                gtk_widget_size_request(dialog,&rq);
                gtk_widget_set_uposition(GTK_WIDGET(dialog),xsize/2-rq.width/2,ysize/2-rq.height/2);

        }

	gtk_widget_show(dialog);

        /* now wait until button is pressed */
        while (nrs_dialog_done == 999) {
                wait_and_process_events();
        }

        if (GTK_WIDGET_MAPPED(toplevel)) {
                gtk_grab_remove(GTK_WIDGET(dialog));
                normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
                gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
                gdk_cursor_destroy (normal_cursor);
        }

        /* remove dialog window */
        gtk_widget_destroy(dialog);
}


/* called by activate/deactivate button */

void change_nonroot_mode(GtkWidget *widget, gpointer data) {
gint act;

	act = GPOINTER_TO_INT(data);

	/* destroy old content of window */
	gtk_widget_destroy(nrs_page);

	/* create new one */
	nrs_page = gen_nonroot_page2(act);
	gtk_container_add(GTK_CONTAINER(nrs_frame),nrs_page);
	gtk_widget_show(nrs_page);

}


/* called by launch button of non-root-configuration */

void launch_nonroot_mode(GtkWidget *widget, gpointer data) {

	/* remove dialog */
	nrs_dialog_done = 0;
}


/* render widget with the first page of non-root-configurator */

static GtkWidget *gen_nonroot_page1(gint act, gint fromsetup) {
GtkWidget *align, *b1, *b2, *sep;
GtkWidget *l1, *vbox2, *hbox;

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER (vbox2),5);

	l1 = gtk_label_new(_("Non-Root-Mode configuration:"));
	set_font_and_color(l1,BOLDFONT,NULL);
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,TRUE,TRUE,0);
	gtk_widget_show(l1);

	l1 = gtk_label_new(_("Welcome to X-CD-Roast!\n\nYou have now the opportunity to configure X-CD-Roast\nso, that not only the root user can start it, but any user\nyou choose. Using the Non-Root-Mode is recommended\nand secure. You can change the mode anytime in the\nUsers-Pane of the Setup-Menu."));
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,TRUE,TRUE,10);
	gtk_widget_show(l1);

	align = gtk_alignment_new(0.5, 0.5, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox2),align,TRUE,TRUE,0);
	gtk_widget_show(align);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(align),hbox);
	gtk_widget_show(hbox);

	l1 = gtk_label_new(_("Current status:"));
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(hbox),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	/* non-root status */
	if (act == 0) {
		l1 = gtk_label_new(_("Non-Root-Mode deactivated"));
	} else {
		l1 = gtk_label_new(_("Non-Root-Mode activated"));
	}
	set_font_and_color(l1,BOLDFONT,"red");
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(hbox),l1,FALSE,FALSE,10);
	gtk_widget_show(l1);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox2),sep,TRUE,TRUE,15);
	gtk_widget_show(sep);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,FALSE,TRUE,5);
	gtk_widget_show(hbox);

	if (act == 0) {
		b1 = gtk_button_new_with_label(_("Activate Non-Root-Mode"));
	} else {
		b1 = gtk_button_new_with_label(_("Deactivate Non-Root-Mode"));
	}
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(change_nonroot_mode),GINT_TO_POINTER(act));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,5);
	gtk_widget_show(b1);

	if (fromsetup) {
		b2 = gtk_button_new_with_label(T_CLOSE);
	} else {
		b2 = gtk_button_new_with_label(_("Launch X-CD-Roast"));
	}
	gtk_signal_connect (GTK_OBJECT (b2), "clicked",
                GTK_SIGNAL_FUNC(launch_nonroot_mode),NULL);
	gtk_box_pack_start(GTK_BOX(hbox),b2,TRUE,TRUE,5);
	gtk_widget_show(b2);

	return vbox2;	
}


/* called by OK button of de/activate-non-root-menu */

void ok_change_nonroot_mode(GtkWidget *widget, GtkWidget *txt) {
gchar cmds[MAXLINE*10];
gchar *p;
gchar cmd[MAXLINE];
gint stat, allok;
gint n;

	allok = 1;
	n = gtk_text_get_length(GTK_TEXT(txt));
	strncpy(cmds, gtk_editable_get_chars(GTK_EDITABLE(txt),0,n), 
			MAXLINE*10);

	/* save now the old flags and owners if we are activating */
	if (nrs_mode == 0) {
		save_current_nonrootvalues(configdir, NONROOTBAK);
	}
	
	/* now extract all the commands one by one */
	p = strtok(cmds, "\n");
	while (p) {
		strncpy(cmd, p, MAXLINE);
		stat = simple_exec(cmd);
		if (stat != 0) {
			g_print("Warning: Command %s failed!\n", cmd);
			allok = 0;
		}
		/* special case..if we just created a group, wait one
		   second before using it */
		if (strncmp(cmd, GROUPADD, strlen(GROUPADD)) == 0) {
			usleep(1000000);
		}
		p = strtok(NULL, "\n");
	}

	
	/* destroy old content of window */
	gtk_widget_destroy(nrs_page);

	/* create new one */
	nrs_page = gen_nonroot_page3(nrs_mode, allok, nrs_fromsetup);
	gtk_container_add(GTK_CONTAINER(nrs_frame),nrs_page);
	gtk_widget_show(nrs_page);

}


/* called by cancel button of activate-non-root-menu */

void cancel_change_nonroot_mode(GtkWidget *widget, gpointer data) {

	/* destroy old content of window */
	gtk_widget_destroy(nrs_page);

	/* create new one */
	nrs_page = gen_nonroot_page1(nrs_mode, nrs_fromsetup);
	gtk_container_add(GTK_CONTAINER(nrs_frame),nrs_page);
	gtk_widget_show(nrs_page);
}


/* render widget with the second page of non-root-configurator */

static GtkWidget *gen_nonroot_page2(gint act) {
GtkWidget *b1, *b2, *sep, *scrolled_win;
GtkWidget *l1, *vbox2, *hbox, *txt;
gchar tmp[MAXLINE*10];
gint stat;

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER (vbox2),5);

	if (act == 0) {
		l1 = gtk_label_new(_("Activate Non-Root-Mode"));
	} else {
		l1 = gtk_label_new(_("Deactivate Non-Root-Mode"));
	}
	set_font_and_color(l1,BOLDFONT,NULL);
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	if (act == 0) {
		l1 = gtk_label_new(_("The following commands will be executed in order\nto activate the Non-Root-Mode.\nPress OK when you are sure you want that."));
	} else {
		l1 = gtk_label_new(_("The following commands will be executed in order\nto deactivate the Non-Root-Mode.\nPress OK when you are sure you want that."));
	}
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,10);
	gtk_widget_show(l1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox2),scrolled_win,TRUE,TRUE,5);
	gtk_widget_show(scrolled_win);

	txt = gtk_text_new(NULL,NULL);
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),FALSE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox2),sep,FALSE,FALSE,5);
	gtk_widget_show(sep);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,FALSE,TRUE,5);
	gtk_widget_show(hbox);

	b1 = gtk_button_new_with_label(T_OK);
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(ok_change_nonroot_mode), txt);
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,5);
	gtk_widget_show(b1);

	b2 = gtk_button_new_with_label(T_CANCEL);
	gtk_box_pack_start(GTK_BOX(hbox),b2,TRUE,TRUE,5);
	gtk_signal_connect (GTK_OBJECT (b2), "clicked",
                GTK_SIGNAL_FUNC(cancel_change_nonroot_mode),NULL);
	gtk_widget_show(b2);

	/* fill textbox */
	stat = get_commands_to_change_nrm(tmp, act);
	gtk_text_insert(GTK_TEXT(txt), NULL, NULL, NULL, tmp, strlen(tmp));
	gtk_text_set_point(GTK_TEXT(txt),0);

	/* error reported? */
	if (stat != 0) {
		/* disable OK button */
		gtk_widget_set_sensitive(b1, FALSE);
	}

	return vbox2;	
}


/* render widget with the third page of non-root-configurator */

static GtkWidget *gen_nonroot_page3(gint act, gint status, gint fromsetup) {
GtkWidget *b1, *sep;
GtkWidget *l1, *vbox2, *hbox;

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER (vbox2),5);

	if (act == 0) {
		l1 = gtk_label_new(_("Activate Non-Root-Mode"));
	} else {
		l1 = gtk_label_new(_("Deactivate Non-Root-Mode"));
	}
	set_font_and_color(l1,BOLDFONT,NULL);
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	/* show message according to success */
	if (act == 0) {
		if (status == 1) {
			/* activation ok */
			l1 = gtk_label_new(_("Activation of the Non-Root-Mode was successful!\n\nEnter now the Setup-Menu to configure\nwhich users may work with X-CD-Roast."));
		} else {
			/* activation failed */
			l1 = gtk_label_new(_("Activation of the Non-Root-Mode failed!\n\nPlease try again with enabled Debug-Mode and report.\n(See the FAQ on http://www.xcdroast.org)"));
		}
	} else {
		if (status == 1) {
			/* deactivation ok */
			l1 = gtk_label_new(_("Deactivation of the Non-Root-Mode was successful!\n\nThe original file permissons have been restored.\nOnly the root user can now use X-CD-Roast."));
		} else {
			/* deactivation failed */
			l1 = gtk_label_new(_("Deactivation of the Non-Root-Mode failed!\n\nPlease try again with enabled Debug-Mode and report.\n(See the FAQ on http://www.xcdroast.org)"));
		}
	}
	gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
	gtk_box_pack_start(GTK_BOX(vbox2),l1,TRUE,TRUE,10);
	gtk_widget_show(l1);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox2),sep,FALSE,FALSE,5);
	gtk_widget_show(sep);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox2),hbox,FALSE,TRUE,5);
	gtk_widget_show(hbox);

	if (fromsetup) {
		b1 = gtk_button_new_with_label(T_CLOSE);
	} else {
		b1 = gtk_button_new_with_label(_("Launch X-CD-Roast"));
	}
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(launch_nonroot_mode),NULL);
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,5);
	gtk_widget_show(b1);

	return vbox2;	
}

