<!--

  Based on the roff and html translations, which are:

  Copyright (C) 1996
       John R. Fieber.  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY JOHN R. FIEBER AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL JOHN R. FIEBER OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

  $XFree86: doctools/sgmlformat/transpec/linuxdoc-index.ts,v 1.5 1999/07/07 11:16:28 dawes Exp $
-->

<!--

  This is an instant(1) translation specification to extract some indexing
  information from an SGML document marked up according to the linuxdoc DTD.
  Currently the <title>, <author> and <date> information is extracted.  The
  output text is in a format that would be suitable for SGML or HTML use
  after some minor post processing of the output tags.

-->

<!DOCTYPE transpec PUBLIC "-//FreeBSD//DTD transpec//EN" [

<!ENTITY r.pass CDATA "1">
<!ENTITY r.passw CDATA "2">
<!ENTITY r.phack CDATA "3">
<!ENTITY r.label CDATA "4">
<!ENTITY r.initr CDATA "5">

<!ENTITY gt CDATA ">">
<!ENTITY lt CDATA "<">
<!ENTITY amp CDATA "&">

<!ENTITY cmap SYSTEM "html.cmap">
<!ENTITY sdata SYSTEM "html.sdata">

<!ENTITY family CDATA "P">

]>

<transpec>

<!-- Character and SDATA entity mapping -->
<cmap>&cmap;</cmap>
<smap>&sdata;</smap>

<!-- Transform rules -->

<!-- Inside a HEADING, all these need to be suppressed or deferred
     to a later time. -->
<rule>
<match>
<gi>EM IT BF SF SL TT CPARAM LABEL REF PAGEREF CITE URL HTMLURL MANREF NCITE EMAIL IDX CDX F X
<relation>ancestor HEADING
</rule>

<rule>
<match>
<gi>LINUXDOC
</rule>

<rule>
<match>
<gi>ARTICLE
</rule>

<rule>
<match>
<gi>REPORT BOOK
</rule>

<rule>
<match>
<gi>NOTES
</rule>

<rule>
<match>
<gi>MANPAGE
</rule>

<rule>
<match>
<gi>TITLEPAG
</rule>

<rule>
<match>
<gi>TITLE
<action>
<start>^&lt;title&gt;</start>
<end>&lt;/title&gt;^</end>
</rule>

<rule>
<match>
<gi>SUBTITLE
</rule>

<rule>
<match>
<gi>DATE
<action>
<start>^&lt;date&gt;</start>
<end>&lt;/date&gt;^</end>
</rule>

<rule>
<match>
<gi>IDENT
<action>
<ignore>all
</rule>

<rule>
<match>
<gi>ABSTRACT
<action>
<ignore>all
</rule>

<rule>
<match>
<gi>AUTHOR
<action>
<start>^&lt;author&gt;</start>
<end>&lt;/author&gt;^</end>
</rule>

<rule>
<match>
<gi>NAME
</rule>

<rule>
<match>
<gi>AND
</rule>

<rule>
<match>
<gi>THANKS
</rule>

<rule>
<match>
<gi>INST
</rule>

<rule>
<match>
<gi>NEWLINE
</rule>

<rule id="&r.label;">
<match>
<gi>LABEL
</rule>

<rule>
<match>
<gi>HEADER
</rule>

<rule>
<match>
<gi>LHEAD
</rule>

<rule>
<match>
<gi>RHEAD
</rule>

<rule>
<match>
<gi>COMMENT
</rule>

<rule>
<match>
<gi>APPENDIX
</rule>

<rule>
<match>
<gi>TOC
<action>
<ignore>all
</rule>

<rule>
<match>
<gi>LOF
</rule>

<rule>
<match>
<gi>LOT
</rule>

<rule>
<match>
<gi>PART
<action>
<ignore>all
</rule>

<rule>
<match>
<gi>CHAPT
</rule>

<rule>
<match>
<gi>SECT
<relation>ancestor BOOK
<action>
<ignore>all
</rule>

<rule>
<match>
<gi>SECT
<action>
<ignore>all
</rule>

<rule>
<match>
<gi>SECT1
<relation>ancestor BOOK
</rule>

<rule>
<match>
<gi>SECT1
</rule>

<rule>
<match>
<gi>SECT2
<relation>ancestor BOOK
</rule>

<rule>
<match>
<gi>SECT2
</rule>

<rule>
<match>
<gi>SECT3
<relation>ancestor BOOK
</rule>

<rule>
<match>
<gi>SECT3
</rule>

<rule>
<match>
<gi>SECT4
<relation>ancestor BOOK
</rule>

<rule>
<match>
<gi>SECT4
</rule>

<rule>
<match>
<gi>HEADING
<context>PART
</rule>

<rule>
<match>
<gi>HEADING
</rule>

<!-- A paragraph immediately following a <tag> in a <descrip>. -->
<rule>
<match>
<gi>P
<relation>sibling-1 TAG
<action>
<ignore>all
</rule>

<rule>
<match>
<gi>P
<action>
<ignore>all
</rule>

<!-- Completely empty paragraphs. -->
<rule id="&r.phack;">
<match>
<gi>_phack
</rule>


<rule>
<match>
<gi>ITEMIZE
</rule>

<rule>
<match>
<gi>ENUM
</rule>

<rule>
<match>
<gi>DESCRIP
</rule>

<rule>
<match>
<gi>ITEM
</rule>

<rule>
<match>
<gi>TAG
</rule>

<rule>
<match>
<gi>CITE
</rule>

<rule>
<match>
<gi>NCITE
</rule>

<rule>
<match>
<gi>FOOTNOTE
</rule>

<rule>
<match>
<gi>SQ
</rule>

<rule>
<match>
<gi>LQ
</rule>

<rule>
<match>
<gi>EM
</rule>

<rule>
<match>
<gi>BF
</rule>

<rule>
<match>
<gi>IT
</rule>

<rule>
<match>
<gi>SF
</rule>

<rule>
<match>
<gi>SL
</rule>

<rule>
<match>
<gi>TT
</rule>

<rule>
<match>
<gi>CPARAM
</rule>

<!-- A URL with a NAME attribute -->
<rule>
<match>
<gi>URL
<attval>NAME .
</rule>

<!-- A URL without a NAME attribute -->
<rule>
<match>
<gi>URL
</rule>

<rule>
<match>
<gi>HTMLURL
</rule>

<rule>
<match>
<gi>MANREF
<attval>SECTION
</rule>

<rule>
<match>
<gi>MANREF
</rule>


<rule>
<match>
<gi>REF
<attval>NAME .
</rule>

<rule>
<match>
<gi>REF
</rule>

<rule>
<match>
<gi>PAGEREF
</rule>

<rule>
<match>
<gi>X
</rule>

<rule>
<match>
<gi>MC
</rule>

<rule>
<match>
<gi>BIBLIO
</rule>

<rule>
<match>
<gi>VERB CODE
</rule>

<rule>
<match>
<gi>TSCREEN
<relation>child VERB
</rule>

<rule>
<match>
<gi>TSCREEN
</rule>

<rule>
<match>
<gi>QUOTE
</rule>

<rule>
<match>
<gi>DEF
</rule>

<rule>
<match>
<gi>PROP
</rule>

<rule>
<match>
<gi>LEMMA
</rule>

<rule>
<match>
<gi>COROLL
</rule>

<rule>
<match>
<gi>PROOF
</rule>

<rule>
<match>
<gi>THEOREM
</rule>

<rule>
<match>
<gi>THTAG
</rule>

<rule>
<match>
<gi>F
</rule>

<rule>
<match>
<gi>DM
</rule>

<rule>
<match>
<gi>EQ
</rule>

<rule>
<match>
<gi>FR
</rule>

<rule>
<match>
<gi>NU
</rule>

<rule>
<match>
<gi>DE
</rule>

<rule>
<match>
<gi>LIM
</rule>

<rule>
<match>
<gi>OP
</rule>

<rule>
<match>
<gi>LL
</rule>

<rule>
<match>
<gi>UL
</rule>

<rule>
<match>
<gi>OPD
</rule>

<rule>
<match>
<gi>PR
</rule>

<rule>
<match>
<gi>IN
</rule>

<rule>
<match>
<gi>SUM
</rule>

<rule>
<match>
<gi>ROOT
</rule>

<rule>
<match>
<gi>AR
</rule>

<rule>
<match>
<gi>ARR
</rule>

<rule>
<match>
<gi>ARC
</rule>

<rule>
<match>
<gi>SUP
</rule>

<rule>
<match>
<gi>INF
</rule>

<rule>
<match>
<gi>UNL
</rule>

<rule>
<match>
<gi>OVL
</rule>

<rule>
<match>
<gi>RF
</rule>

<rule>
<match>
<gi>V
</rule>

<rule>
<match>
<gi>FI
</rule>

<rule>
<match>
<gi>PHR
</rule>

<rule>
<match>
<gi>TU
</rule>

<rule>
<match>
<gi>FIGURE
</rule>

<rule>
<match>
<gi>EPS
</rule>

<rule>
<match>
<gi>PH
</rule>

<rule>
<match>
<gi>CAPTION
</rule>

<rule>
<match>
<gi>TABLE
<attval>BORDER [1-9][0-9]*
</rule>

<rule>
<match>
<gi>TABLE
</rule>

<rule>
<match>
<gi>TABULAR
</rule>

<!-- `<ignore>all' prevents the table data being duplicated -->
<rule id=1>
<match>
<gi>_start_tab
</rule>

<rule id=2>
<match>
<gi>_end_tab
</rule>

<rule>
<match>
<gi>ROWSEP
</rule>

<rule>
<match>
<gi>ROWSTART
</rule>

<rule>
<match>
<gi>TABROW
</rule>

<rule>
<match>
<gi>COLSEP
</rule>

<rule>
<match>
<gi>HLINE
</rule>

<rule>
<match>
<gi>SLIDES
</rule>

<rule>
<match>
<gi>SLIDE
</rule>

<rule>
<match>
<gi>LETTER
</rule>

<rule>
<match>
<gi>FROM
</rule>

<rule>
<match>
<gi>TO
</rule>

<rule>
<match>
<gi>ADDRESS
</rule>

<rule>
<match>
<gi>EMAIL
</rule>

<rule>
<match>
<gi>SUBJECT
</rule>

<rule>
<match>
<gi>SREF
</rule>

<rule>
<match>
<gi>RREF
</rule>

<rule>
<match>
<gi>CC
</rule>

<rule>
<match>
<gi>OPENING
</rule>

<rule>
<match>
<gi>CLOSING
</rule>

<rule>
<match>
<gi>ENCL
</rule>

<rule>
<match>
<gi>PS
</rule>

<!-- Pass the content through -->
<rule id="&r.pass">
<match>
<gi>_pass-text
</rule>

<rule id="&r.passw">
<match>
<gi>_pass-word
</rule>

</transpec>
