#include "Ratios.moc"
#include "AddDlFree.h"
#include "ftpaccess.h"

#include <kapplication.h>
#include <klocale.h>

#include <qlabel.h>
#include <qwhatsthis.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlistbox.h>

Ratios::Ratios(QWidget *parent, const char *name)
 : RatiosBase(parent,name)
{
	ftpxs=0;

	UlDlRatio->setRange(1,9999);
	UlDlRatio->setPrefix("1:");
	QWhatsThis::add(UlDlRatioAnon,i18n("If enabled, an anonymous user can download only [x] bytes per uploaded byte."));
	QWhatsThis::add(UlDlRatioGuest,i18n("If enabled, a guest can download only [x] bytes per uploaded byte."));

	limitTime->setRange(1,99999);
	limitTime->setSuffix(i18n(" min."));

	limitUpload->setRange(1,2147483);
	limitUpload->setSuffix(i18n(" KB."));
	limitUpload->setLineStep(1024);

        limitDownload->setRange(1,2147483);
	limitDownload->setSuffix(i18n(" KB."));
	limitDownload->setLineStep(1024);

	connect(dlFreeAdd,SIGNAL(clicked()),SLOT(dlFreeAddPressed()));
	connect(dlFreeRm,SIGNAL(clicked()),SLOT(dlFreeRmPressed()));

	connect(dlFreeDirAdd,SIGNAL(clicked()),SLOT(dlFreeDirAddPressed()));
	connect(dlFreeDirRm,SIGNAL(clicked()),SLOT(dlFreeDirRmPressed()));
}
Ratios::~Ratios()
{
}
void Ratios::ftpaccessLoaded(ftpaccess *xs)
{
	ftpxs=xs;
	UlDlRatio->setValue(ftpxs->getUlDlRatio());
	UlDlRatioAnon->setChecked((ftpxs->getUlDlRatioWho()&ANONYMOUS)!=0);
	UlDlRatioGuest->setChecked((ftpxs->getUlDlRatioWho()&GUEST)!=0);
	limitTime->setValue(ftpxs->getLimitTime());
	limitTimeAnon->setChecked((ftpxs->getLimitTimeWho()&ANONYMOUS)!=0);
	limitTimeGuest->setChecked((ftpxs->getLimitTimeWho()&GUEST)!=0);
	limitUpload->setValue(ftpxs->getLimitUpload()/1024);
	limitUploadAnon->setChecked((ftpxs->getLimitUploadWho()&ANONYMOUS)!=0);
	limitUploadGuest->setChecked((ftpxs->getLimitUploadWho()&GUEST)!=0);
	limitDownload->setValue(ftpxs->getLimitDownload()/1024);
	limitDownloadAnon->setChecked((ftpxs->getLimitDownloadWho()&ANONYMOUS)!=0);
	limitDownloadGuest->setChecked((ftpxs->getLimitDownloadWho()&GUEST)!=0);
	dlFreeL=ftpxs->getDlFree();
	dlFreeDirL=ftpxs->getDlFreeDir();
	redraw();
}
void Ratios::redraw()
{
	dlFree->clear();
	dlFreeDir->clear();
}
void Ratios::update()
{
	ftpxs->setUlDlRatio(UlDlRatio->value());
	ftpxs->setLimitTime(limitTime->value());
	ftpxs->setLimitUpload(limitUpload->value()*1024);
	ftpxs->setLimitDownload(limitDownload->value()*1024);
	if(UlDlRatioAnon->isChecked())
		ftpxs->setUlDlRatioWho(ftpxs->getUlDlRatioWho()|ANONYMOUS);
	else
		ftpxs->setUlDlRatioWho(ftpxs->getUlDlRatioWho()&~ANONYMOUS);
	if(UlDlRatioGuest->isChecked())
		ftpxs->setUlDlRatioWho(ftpxs->getUlDlRatioWho()|GUEST);
	else
		ftpxs->setUlDlRatioWho(ftpxs->getUlDlRatioWho()&~GUEST);
	if(limitTimeAnon->isChecked())
		ftpxs->setLimitTimeWho(ftpxs->getLimitTimeWho()|ANONYMOUS);
	else
		ftpxs->setLimitTimeWho(ftpxs->getLimitTimeWho()&~ANONYMOUS);
	if(limitTimeGuest->isChecked())
		ftpxs->setLimitTimeWho(ftpxs->getLimitTimeWho()|GUEST);
	else
		ftpxs->setLimitTimeWho(ftpxs->getLimitTimeWho()&~GUEST);
	if(limitUploadAnon->isChecked())
		ftpxs->setLimitUploadWho(ftpxs->getLimitUploadWho()|ANONYMOUS);
	else
		ftpxs->setLimitUploadWho(ftpxs->getLimitUploadWho()&~ANONYMOUS);
	if(limitUploadGuest->isChecked())
		ftpxs->setLimitUploadWho(ftpxs->getLimitUploadWho()|GUEST);
	else
		ftpxs->setLimitUploadWho(ftpxs->getLimitUploadWho()&~GUEST);
	if(limitDownloadAnon->isChecked())
		ftpxs->setLimitDownloadWho(ftpxs->getLimitDownloadWho()|ANONYMOUS);
	else
		ftpxs->setLimitDownloadWho(ftpxs->getLimitDownloadWho()&~ANONYMOUS);
	if(limitDownloadGuest->isChecked())
		ftpxs->setLimitDownloadWho(ftpxs->getLimitDownloadWho()|GUEST);
	else
		ftpxs->setLimitDownloadWho(ftpxs->getLimitDownloadWho()&~GUEST);
}
void Ratios::dlFreeAddPressed()
{
	AddDlFree a;
	connect(&a,SIGNAL(dlFreeAdded(bool, QString)),SLOT(dlFreeAdded(bool, QString)));
	a.exec();
}
void Ratios::dlFreeRmPressed()
{
	for(unsigned int i=0;i<dlFree->count();i++)
		if(dlFree->isSelected(i)) {
			dlFree->removeItem(i);
			dlFreeL->remove(dlFreeL->at(i));
		}
}
void Ratios::dlFreeDirAddPressed()
{
	AddDlFree a(true);
	connect(&a,SIGNAL(dlFreeAdded(bool, QString)),SLOT(dlFreeAdded(bool, QString)));
	a.exec();
}
void Ratios::dlFreeDirRmPressed()
{
	for(unsigned int i=0;i<dlFreeDir->count();i++)
		if(dlFreeDir->isSelected(i)) {
			dlFreeDir->removeItem(i);
			dlFreeDirL->remove(dlFreeDirL->at(i));
		}
}
void Ratios::dlFreeAdded(bool isDir, QString name)
{
	if(isDir) {
		dlFreeDir->insertItem(name);
		dlFreeDirL->append(name);
	} else {
		dlFree->insertItem(name);
		dlFreeL->append(name);
	}
}
