/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __kxfreeconfig_h__
#define __kxfreeconfig_h__

#include "parser.h"
#include "kxdata.h"

class KXFreeConfig
{
public:
    KXFreeConfig( const QString &customXF86Config );
    ~KXFreeConfig();

    bool loadConfig( const QString &file=QString::null );
    bool saveConfig();

    QString configFile() const;

//    static void dumpCurrentMonitor();

private:
    void parseInputDeviceSection( Node::Ptr section );
    void parseServerFlagsSection( Node::Ptr section );
    void parseMonitorSection( Node::Ptr section );
    void parseDeviceSection( Node::Ptr section );
    void parseScreenSection( Node::Ptr section );
    void parseModesSection( Node::Ptr section );

    KXModeData parseModeLine( Node::Ptr node );

    void saveKeyboardConfig();
    void savePointerConfig();
    void saveServerFlagsConfig();
    void saveScreenConfig( const QString &graphicsDeviceName );
    void saveMonitorConfig();
    QString saveDeviceConfig();

    Node::Ptr findOptionNode( Node::Ptr parent, const QString &name, bool createIfMissing = false );

    Node::Ptr createOptionNode( Node::Ptr parent, const QString &name );

    void setOptionValue( Node::Ptr optionNode, const QString &value );

    Node::Ptr sectionByChildNode( Node::Ptr parent,
                                  const QString &sectionName,
                                  const QString &nodeName,
                                  const QString &nodeStringValue,
                                  bool createIfMissing = false );

    Node::Ptr sectionByName( Node::Ptr parent,
                             const QString &sectionName,
                             bool createIfMissing = false );

    Node::Ptr findStringNode( const Node::List &list,
                              const QString &nodeName,
                              const QString &nodeStringValue );

    Node::Ptr findNode( Node::Ptr parent, const QString &name );

    void createNewLine( Node::Ptr parent );

    Node::Ptr createSectionWithNode( Node::Ptr parent,
                                     const QString &sectionName,
                                     const QString &nodeName,
                                     const QString &nodeStringValue );

    Node::Ptr createSection( Node::Ptr parent,
                             const QString &sectionName );

    bool parseBoolOptionValue( const Node::Ptr &node );
    void parseRangeValue( const Node::Ptr &node, float &min, float &max );

    void dumpNode( Node::Ptr n );

    static QString findSuitableConfigFilePath();

    bool isXFree3XFile();

    Node::Ptr m_config;
    QString m_configFile;

    static const char *mNodeNameVideoRam;
    static const char *mNodeNamePixelClock;

    bool mBackupWritten;
};

#endif
