/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "hwdata.h"

#include <qfile.h>
#include <qbuffer.h>
#include <qtextstream.h>

HWData::HWData()
{
}

HWData::~HWData()
{
}

bool HWData::open( const QString &filename )
{
    QFile f( filename );

    if ( !f.open( IO_ReadOnly ) )
        return false;

    QByteArray data = f.readAll();

    QString buffer = QString::fromLatin1( data.data(), data.size() );

    m_keys.clear();
    m_data.clear();

    QStringList lines = QStringList::split( '\n', buffer );
    QStringList::ConstIterator it = lines.begin();
    QString line = *( it++ );

    m_keys = QStringList::split( '\t', line );

    for (; it != lines.end(); ++it )
    {
        QString line = *it;

        m_data.append( QStringList::split( '\t', line, true ) );
    }

    return true;
}

bool HWData::append( const QDomElement &dataset )
{
    QStringList entryset;

    QDomNode entryNode = dataset.firstChild();
    for (; !entryNode.isNull(); entryNode = entryNode.nextSibling() )
    {
        QDomElement entry = entryNode.toElement();

        if ( entry.isNull() )
            continue;

        QString key = entry.attribute( "key" );

        if ( key.isEmpty() )
            return false;

        int index = m_keys.findIndex( key );

        if ( index == -1 )
            return false;

        while ( static_cast<uint>( index ) >= entryset.count() )
            entryset.append( QString::null );

        entryset[ index ] = entry.text();
    }

    m_data.append( entryset );

    return true;
}

/* vim: et sw=4 ts=4
 */
