#ifndef LOCKOUT_H
#define LOCKOUT_H

#include <qevent.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <kpanelapplet.h>


class QBoxLayout;

class TrayButton : public QPushButton
{
    Q_OBJECT

public:
    TrayButton(QWidget* parent, const char* name)
        : QPushButton(parent, name) { }
    virtual ~TrayButton() {}

protected:
    void drawButton(QPainter *p);
};

class Lockout : public KPanelApplet
{
    Q_OBJECT

public:
    Lockout( const QString& configFile,
	     QWidget *parent = 0, const char *name = 0 );
    ~Lockout();

    int widthForHeight(int height) const;
    int heightForWidth(int width) const;

protected:
    virtual void mousePressEvent( QMouseEvent * );
    virtual void mouseMoveEvent( QMouseEvent * );
    virtual void mouseReleaseEvent( QMouseEvent * );
    virtual void mouseDoubleClickEvent( QMouseEvent * );
    
    virtual bool eventFilter( QObject *, QEvent * );
    
private slots:
    void lock();
    void logout();

    void slotLockPrefs();
    void slotLogoutPrefs();

private:
    void propagateMouseEvent( QMouseEvent * );
    
    TrayButton *lockButton, *logoutButton;
    QBoxLayout *layout;
};

#endif // LOCKOUT_H
