/*****************************************************************

Copyright (c) 2002 John Firebaugh <jfirebaugh@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <kglobal.h>
#include <kconfig.h>
#include <kdebug.h>

#include "container_panel.h"
#include "panel.h"

#include "panelmanager.h"
#include "panelmanager.moc"

PanelManager* PanelManager::the()
{
    static PanelManager panelManager;
    return &panelManager;
}

PanelManager::PanelManager()
    : QObject( 0, "PanelManager" )
{
}

void PanelManager::add( PanelContainer* panel )
{
    _panels.prepend( panel );
}

void PanelManager::remove( PanelContainer* panel )
{
    _panels.removeRef( panel );
}

void PanelManager::raise( PanelContainer* panel )
{
    _panels.removeRef( panel );
    _panels.prepend( panel );
    writeConfig();
}

int PanelManager::stackingPosition( PanelContainer* panel )
{
    return _panels.findRef( panel );
}

void PanelManager::readConfig()
{
//    kdDebug(1210) << "PanelManager::readConfig()" << endl;

    // Here we read the "Panels" entry of the config file.
    // All we are going to do now is locate the index of the
    // main panel's entry in this list, and restack the main
    // panel at that index. We could just store the index in
    // the config file, but the idea is that sometime in the
    // future some refactoring should occur that allows us to
    // load _all_ panels (extensions and the main panel) in one
    // place in the code (here, probably) and basically treat
    // the main panel as just a special case.
    // A reworking of the initialization code is desired because
    // right now it is very fragile in terms of what order
    // things have to happen.
    KConfig* config = KGlobal::config();
    config->setGroup("General");

    QStringList panels = config->readListEntry("Panels");

    int mainPanelStackPosition = panels.findIndex( "MainPanel" );

    if( mainPanelStackPosition != -1 ) {
        _panels.removeRef( Panel::the() );

        // Watch out for screwed config files.
        mainPanelStackPosition = QMIN( mainPanelStackPosition, _panels.count() );

        _panels.insert( 0, Panel::the() );
    }

    for( PanelListIterator it(_panels); it.current(); ++it ) {
        (*it)->readConfig();
    }
}

void PanelManager::writeConfig()
{
//    kdDebug(1210) << "PanelManager::writeConfig()" << endl;

    QStringList panels;
    for( PanelListIterator it(_panels); it.current(); ++it ) {
        panels << (*it)->panelId();
    }

    KConfig* config = KGlobal::config();
    config->setGroup( "General" );
    config->writeEntry( "Panels", panels );

    for( PanelListIterator it(_panels); it.current(); ++it ) {
        (*it)->writeConfig();
    }

    config->sync();
}

void PanelManager::showAll()
{
    for( PanelListIterator it(_panels); it.current(); ++it ) {
        (*it)->show();
    }
}

void PanelManager::shutdown()
{
    _panels.setAutoDelete(true);
    _panels.clear();
}
