/***************************************************************************
                            KGlobalSettings.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Access the KDE global configuration.

 @author David Faure <faure@kde.org>

 @version $Id: KGlobalSettings.java,v 1.7 2002/11/26 04:17:32 rdale Exp $
 
 @short *
 Access the KDE global configuration.
*/
public class  KGlobalSettings implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KGlobalSettings(Class dummy){}


/** 
 Returns a threshold in pixels for drag & drop operations.
 As long as the mouse movement has not exceeded this number
 of pixels in either X or Y direction no drag operation may
 be started. This prevents spurious drags when the user intended
 to click on something but moved the mouse a bit while doing so.

 For this to work you must save the position of the mouse (oldPos)
 in the {@link QWidget#mousePressEvent}.
 When the position of the mouse (newPos)
 in a  {@link QWidget#mouseMoveEvent} exceeds this threshold
 you may start a drag
 which should originate from oldPos.

 Example code:
 <pre>
 void KColorCells.mousePressEvent( QMouseEvent e )
 {
    mOldPos = e.pos();
 }

 void KColorCells.mouseMoveEvent( QMouseEvent e )
 {
    if( !(e.state() && LeftButton)) return;

    int delay = KGlobalSettings.dndEventDelay();
    QPoint newPos = e.pos();
    if(newPos.x() > mOldPos.x()+delay || newPos.x() < mOldPos.x()-delay ||
       newPos.y() > mOldPos.y()+delay || newPos.y() < mOldPos.y()-delay)
    {
       // Drag color object
       int cell = posToCell(mOldPos); // Find color at mOldPos
       if ((cell != -1) && colors[cell].isValid())
       {
          KColorDrag d = KColorDrag.makeDrag( colors[cell], this);
          d.dragCopy();
       }
    }
 }
 </pre>

*/
	public static native int dndEventDelay();

/** 
 Returns whether KDE runs in single (default) or double click
 mode.
 see http://developer.kde.org/documentation/standards/kde/style/mouse/index.html

*/
	public static native boolean singleClick();

/** 
 Returns whether tear-off handles are inserted in {@link KPopupMenus}.

*/
	public static native int insertTearOffHandle();

/** 
 Checks whether the cursor changes over icons.

*/
	public static native boolean changeCursorOverIcon();

/** 
 Checks whether to show feedback when in item (specifically an
 icon) is activated.

*/
	public static native boolean visualActivate();

/** 
 Returns the speed of the visual activation feedback.

*/
	public static native int visualActivateSpeed();

/** 
 Returns the KDE setting for the auto-select option.

*/
	public static native int autoSelectDelay();

/** 
 Returns the KDE setting for the shortcut key to open
 context menus.

*/
	public static native int contextMenuKey();

/** 
 Returns the KDE setting for context menus.

*/
	public static native boolean showContextMenusOnPress();

/** 
 Returns the preferred completion mode setting.

*/
	public static native int completionMode();

/** 
 This returns the current mouse settings.

*/
//	public static native KMouseSettings& mouseSettings();

/** 
 The path to the desktop directory of the current user.

*/
	public static native String desktopPath();

/** 
 The path to the autostart directory of the current user.

*/
	public static native String autostartPath();

/** 
 The path to the trash directory of the current user.

*/
	public static native String trashPath();

/** 
 The path where documents are stored of the current user.

*/
	public static native String documentPath();

/** 
 The default color to use when highlighting toolbar buttons.

*/
	public static native QColor toolBarHighlightColor();

/** 
 The default color to use for inactive titles.

*/
	public static native QColor inactiveTitleColor();

/** 
 The default color to use for inactive texts.

*/
	public static native QColor inactiveTextColor();

/** 
 The default color to use for active titles.

*/
	public static native QColor activeTitleColor();

/** 
 The default color to use for active texts.

*/
	public static native QColor activeTextColor();

/** 
 Returns the contrast for borders.

*/
	public static native int contrast();

/** 
 Returns the default base (background) color.

*/
	public static native QColor baseColor();

/** 
 Returns the default text color.

*/
	public static native QColor textColor();

/** 
 Returns the default link color.

*/
	public static native QColor linkColor();

/** 
 Returns the default color for visited links.

*/
	public static native QColor visitedLinkColor();

/** 
 Returns the default color for highlighted text.

*/
	public static native QColor highlightedTextColor();

/** 
 Returns the default color for text highlights.

*/
	public static native QColor highlightColor();

/** 
 Returns the alternate background color used by {@link KListView} with
 {@link KListViewItem}. Any other list that uses alternating background
 colors should use this too, to obey to the user's preferences. Returns
 an invalid color if the user doesn't want alternating backgrounds.

*/
	public static native QColor alternateBackgroundColor();

/** 
 Calculates a color based on <code>base</code> to be used as alternating
 color for e.g. listviews.

*/
	public static native QColor calculateAlternateBackgroundColor( QColor base);

/** 
 Returns the default general font.

*/
	public static native QFont generalFont();

/** 
 Returns the default fixed font.

*/
	public static native QFont fixedFont();

/** 
 Returns the default toolbar font.

*/
	public static native QFont toolBarFont();

/** 
 Returns the default menu font.

*/
	public static native QFont menuFont();

/** 
 Returns the default window title font.

*/
	public static native QFont windowTitleFont();

/** 
 Returns the default taskbar font.

*/
	public static native QFont taskbarFont();

/** 
 Returns a font of approx. 48 pt. capable of showing <code>text.</code>

*/
	public static native QFont largeFont( String text);
	public static native QFont largeFont();

/** 
 Returns if the user specified multihead. In case the display
 has multiple screens, the return value of this function specifies
 if the user wants KDE to run on all of them or just on the primary

*/
	public static native boolean isMultiHead();

/** 
 Typically, QScrollView derived classes can be scrolled fast by
 holding down the Ctrl-button during wheel-scrolling.
 But QTextEdit and derived classes perform zooming instead of fast
 scrolling.

 This value determines whether the user wants to zoom or scroll fast
 with Ctrl-wheelscroll.

*/
	public static native boolean wheelMouseZooms();
	public static final int Disable = 0;
	public static final int ApplicationLevel = 0;
	public static final int Enable = 1;
	public static final int /***Nocompletionisused.*/CompletionNone = 1;
	public static final int /***Textisautomaticallyfilledinwheneverpossible.*/CompletionAuto = 0;
	public static final int /***Sameasautomaticexceptshortestmatchisusedforcompletion.*/CompletionMan = 1;
	public static final int /***Completetextmuchinthesamewayasatypical*nixshellwould.*/CompletionShell = 2;
	public static final int /***Listsallpossiblematchesinapopuplist-boxtochoosefrom.*/CompletionPopup = 3;
	public static final int /***Listsallpossiblematchesinapopuplist-boxtochoosefrom = 4;
	public static final int andautomatically*filltheresultwheneverpossible.*/CompletionPopupAuto = 5;
}
