/***************************************************************************
                            TransferJob.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The transfer job pumps data into and/or out of a Slave.
 Data is sent to the slave on request of the slave ({@link #dataReq}).
 If data coming from the slave can not be handled, the
 reading of data from the slave should be suspended.
     
 See {@link TransferJobSignals} for signals emitted by TransferJob.

 

 @short *
 The transfer job pumps data into and/or out of a Slave.
*/
public class TransferJob extends SimpleJob  {
	protected TransferJob(Class dummy){super((Class) null);}

	private native void newTransferJob( KURL url, int command, byte[] packedArgs, byte[] _staticData, boolean showProgressInfo);
	public TransferJob( KURL url, int command, byte[] packedArgs, byte[] _staticData, boolean showProgressInfo) {
		super((Class) null);
		newTransferJob( url, command, packedArgs, _staticData, showProgressInfo);
	}
	public native void start( Slave slave);

/** 
 Called when m_subJob finishes.
         
*/
	public native void slotResult( Job job);

/** 
 Flow control. Suspend data processing from the slave.
         
*/
	public native void suspend();

/** 
 Flow control. Resume data processing from the slave.
         
*/
	public native void resume();

/** 
 Flow control. Returns true if the job is suspended.
         
*/
	public native boolean isSuspended();

/** 

*/
	public native boolean isErrorPage();
	protected native void virtual_hook( int identifier, int data);
	protected native void slotRedirection( KURL url);
	protected native void slotFinished();
	protected native void slotData( byte[] data);
	protected native void slotDataReq();
	protected native void slotMimetype( String mimetype);
	protected native void slotNeedSubURLData();
	protected native void slotSubURLData( Job arg1, byte[] arg2);
	protected native void slotErrorPage();
	protected native void slotCanResume( int offset);
}
