/***************************************************************************
                            KJavaAppletServer.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KJAVAAPPLETSERVER_H
#define KJAVAAPPLETSERVER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

@class KJavaAppletContext; 
@class KJavaProcess; 

@interface KJavaAppletServer : QObject 

/** 
 Create the applet server.  These shouldn't be used directly,
 use allocateJavaServer instead
     
*/
- init;
- (void) dealloc;

/** 
 Create an applet context with the specified id.
     
*/
- createContext: (int)contextId context: (KJavaAppletContext*)context;

/** 
 Destroy the applet context with the specified id. All the applets in the
 context will be destroyed as well.
     
*/
- destroyContext: (int)contextId;

/** 
 This should be called by the KJavaAppletWidget
     
*/
- initApplet: (int)contextId appletId: (int)appletId;

/** 
 Destroy an applet in the specified context with the specified id.
     
*/
- destroyApplet: (int)contextId appletId: (int)appletId;

/** 
 Start the specified applet.
     
*/
- startApplet: (int)contextId appletId: (int)appletId;

/** 
 Stop the specified applet.
     
*/
- stopApplet: (int)contextId appletId: (int)appletId;

/** 
 Send data we got back from a KJavaDownloader back to the appropriate
 class loader.
 (This is currently unimplemented on the java side.
     
*/
- sendURLData: (NSString *)loaderID url: (NSString *)url data: (QByteArray*)data;

/** 
 Shut down the KJAS server.
     
*/
- quit;
- (NSString *) appletLabel;

/** 
 A factory method that returns the default server. This is the way this
 class is usually instantiated.
     
*/
+ (KJavaAppletServer*) allocateJavaServer;

/** 
 When you are done using your reference to the AppletServer,  you must
 dereference it by calling -freeJavaServer.
     
*/
+ freeJavaServer;

/** 
 This allows the KJavaAppletWidget to display some feedback in a QLabel
 while the applet is being loaded.  If the java process could not be
 started, an error message is displayed instead.
     
*/
+ (NSString *) getAppletLabel;
- setupJava: (KJavaProcess*)p;
- slotJavaRequest: (QByteArray*)qb;
- checkShutdown;
@end

/** Override these methods in subclasses of KJavaAppletServer to customise event handling behaviour */
@protocol KJavaAppletServerEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
