/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "spelldlg.h"

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qvbox.h>
#include <qwhatsthis.h>

#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>

SpellDlg::SpellDlg(bool haveMarkedText,QWidget *parent,const char *name)
		: KDialogBase(parent,name,true,i18n("Caption of dialog","Spelling")
						, Ok|Cancel)
{
	QVBox *vBox = makeVBoxMainWidget();

//	new QLabel(i18n("Choose what you want to spell check:")
//					,vBox);
	
	QButtonGroup *btnGrp = new QButtonGroup( 2,Qt::Horizontal
				,i18n("Choose What You Want to Spell Check"),vBox);
//	btnGrp->setFrameStyle(QFrame::NoFrame);

	allBtn = new QRadioButton(i18n("A&ll messages"),btnGrp);
	QWhatsThis::add(allBtn
			,i18n("Spell check all translated messages of this file."));
	

	currentBtn = new QRadioButton(i18n("C&urrent message"),btnGrp);
	QWhatsThis::add(currentBtn
			,i18n("Spell check only the current message."));

		
	beginBtn = new QRadioButton(i18n("&From beginning to cursor position")
					,btnGrp);
	QWhatsThis::add(beginBtn
			,i18n("Spell check all text from the beginning of\n"
			      "the file to the current cursor position."));



	endBtn = new QRadioButton(i18n("F&rom cursor position to end")
					,btnGrp);
	QWhatsThis::add(endBtn
			,i18n("Spell check all text from the current cursor position\n"
			      "to the end of the file."));


	markedBtn = new QRadioButton(i18n("S&elected text"),btnGrp);
	connect(markedBtn,SIGNAL(toggled(bool)),this,SLOT(markedChecked(bool)));
	QWhatsThis::add(markedBtn,i18n("Spell check only the selected text."));

	defaultBtn = new QCheckBox(i18n("U&se this selection as default"),vBox);
	QWhatsThis::add(defaultBtn
			,i18n("Check this, to store the current selection\n"
			      "as default selection."));
	
	if(haveMarkedText)
	{
		markedBtn->setChecked(true);
		defaultBtn->setChecked(false);
		defaultBtn->setEnabled(false);
	}
	else
	{
		markedBtn->setEnabled(false);

		KConfig *config = KGlobal::config();
		KConfigGroupSaver cs(config,"SpellDlg");
		QString what=config->readEntry("Default","All");
		
		if(what=="All")
			allBtn->setChecked(true);
		else if(what=="Current")
			currentBtn->setChecked(true);
		else if(what=="Begin")
			beginBtn->setChecked(true);
		else if(what=="End")
			endBtn->setChecked(true);
		else
			allBtn->setChecked(true);
			
	}
	
}

SpellDlg::~SpellDlg()
{
	if(defaultBtn->isChecked())
	{
		KConfig *config=KGlobal::config();
		KConfigGroupSaver cs(config,"SpellDlg");

		QString what="All";
		if(endBtn->isChecked())
			what="End";
		else if(beginBtn->isChecked())
			what="Begin";
		else if(currentBtn->isChecked())
			what="Current";

		config->writeEntry("Default",what);
	}
}

bool SpellDlg::all() const
{
	return allBtn->isChecked();
}

bool SpellDlg::current() const
{
	return currentBtn->isChecked();
}

bool SpellDlg::begin() const
{
	return beginBtn->isChecked();
}

bool SpellDlg::end() const
{
	return endBtn->isChecked();
}

bool SpellDlg::marked() const
{
	return markedBtn->isChecked();
}


void SpellDlg::markedChecked(bool on)
{
	if(on)
	{
		defaultBtn->setChecked(false);
	}
	
	defaultBtn->setEnabled(!on);
}


#include "spelldlg.moc"
