/*
 **********************************************************************
 *     audio.c -- /dev/dsp interface for emu10k1 driver
 *     Copyright 1999, 2000 Creative Labs, Inc.
 *
 **********************************************************************
 *
 *     Date                 Author          Summary of changes
 *     ----                 ------          ------------------
 *     October 20, 1999     Bertrand Lee    base code release
 *     November 2, 1999	    Alan Cox        cleaned up types/leaks
 *
 **********************************************************************
 *
 *     This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU General Public License as
 *     published by the Free Software Foundation; either version 2 of
 *     the License, or (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *     USA.
 *
 **********************************************************************
 */

/*
 *	FIXME:
 *		There are some 32bit assumptions here
 *		Cast of pointers to 32bit values is unsafe
 *			- Wave callbacks and elsewhere
 */

#ifndef _AUDIO_H
#define _AUDIO_H


#ifdef MODULE
#define __NO_VERSION__
#include <linux/module.h>
#else
#define MOD_INC_USE_COUNT
#define MOD_DEC_USE_COUNT
#endif


#include "hwaccess.h"
#include "mycommon.h"
#include "mmwave.h"
#include "cardwo.h"
#include "cardwi.h"

#define MINFRAGS	2
#define MINFRAGSHIFT	4

struct sblive_wavedevice 
{
	struct sblive_hw *sb_hw;
	struct wiinst *wiinst;
	struct woinst *woinst;
	u16 enablebits;
};

static int waveOutCallbackFn(unsigned long, unsigned long, unsigned long);
static int waveInCallbackFn(unsigned long, unsigned long, unsigned long);
static void calculate_ofrag(struct woinst *woinst);
static void calculate_ifrag(struct wiinst *wiinst);

#endif /* _AUDIO_H */
