/*     
 **********************************************************************
 *     irq.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

#ifndef _IRQ_H
#define _IRQ_H

struct sblive_irq
{
        u32     	ID;
	u32		status;
	u32 		irq;
	struct sblive_hw *sb_hw;
};

int sblive_irqmgrInit(struct sblive_irq *);
int sblive_irqmgrInstallIrqHandler(struct sblive_hw *, u32, CALLBACKFN, u32);
int sblive_irqmgrUninstallIrqHandler(struct sblive_hw *, u32);
int sblive_irqmgrExit(struct sblive_irq *);
int sblive_irqmgrEnableIrq(struct sblive_hw *, u32);
int sblive_irqmgrDisableIrq(struct sblive_hw *, u32);
int sblive_irqmgrEnableVoiceIrq(struct sblive_hw *, u32);
int sblive_irqmgrDisableVoiceIrq(struct sblive_hw *, u32);

#define EMU10K1_INTERRUPT_ID 0xfeebbeef

#endif /* _IRQ_H */

