//////////////////////////////////////////////////////////////
//      $Id: kissInterface.h,v 1.14 2002/06/07 11:44:59 coolo Exp $
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef KISS_IFACE_H
#define KISS_IFACE_H

#include "../config.h"

#include <qptrlist.h>
#include <qstringlist.h>
#include <kprocess.h>

#include "procbuf.h"
#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

class KISS: public pkgInterface
{
  Q_OBJECT

public:
  KISS();
  ~KISS();

  bool isType(char *buf, const QString &fname);
  param *initinstallOptions();
  param *inituninstallOptions();
  packageInfo *getPackageInfo(char mode, const QString &name, const QString &version);
  QStringList getFileList(packageInfo *p);

  QStringList FindFile(const QString &name);
  bool parseName(const QString& name, QString *n, QString *v);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo* collectInfo(const char *inp);
  void listInstalledPackages(QPtrList<packageInfo> *pki);

  QString install(int installFlags, QPtrList<packageInfo> *plist, bool &test);
  QString uninstall(int uninstallFlags, QPtrList<packageInfo> *plist, bool &test);

  QString doUninstall(int installFlags, QString packs, bool &test);
  QString doInstall(int installFlags, QString packs, bool &test);

};

#endif



