/***************************************************************************
                            KFilterBase.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is the base class for compression filters
 such as gzip and bzip2. It's pretty much internal.
 Don't use directly, use KFilterDev instead.
 
 @short *
 This is the base class for compression filters
 such as gzip and bzip2.
*/
public class KFilterBase extends QObject  {
	protected KFilterBase(Class dummy){super((Class) null);}

	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the device on which the filter will work
 If <code>autodelete</code> is set to true, <code>dev</code> is deleted when the filter is deleted
     
*/
	public native void setDevice( QIODeviceInterface dev, boolean autodelete);
	public native void setDevice( QIODeviceInterface dev);
	public native QIODeviceInterface device();
	public native void init( int mode);
	public native int mode();
	public native void terminate();
	public native void reset();
	public native boolean readHeader();
	public native boolean writeHeader( String filename);
	public native void setOutBuffer( String data, int maxlen);
	public native void setInBuffer( String data, int size);
	public native boolean inBufferEmpty();
	public native int inBufferAvailable();
	public native boolean outBufferFull();
	public native int outBufferAvailable();
	public native int uncompress();
	public native int compress( boolean finish);

/** 
 Call this to create the appropriate filter for the file
 named <code>fileName.</code>
     
*/
	public static native KFilterBase findFilterByFileName( String fileName);

/** 
 Call this to create the appropriate filter for the mimetype
 <code>mimeType.</code> For instance application/x-gzip.
     
*/
	public static native KFilterBase findFilterByMimeType( String mimeType);
	public static final int OK = 0;
	public static final int END = 1;
	public static final int ERROR = 2;
}
