/***************************************************************************
                            HTMLLegendElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLLEGENDELEMENT_H
#define HTMLLEGENDELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Provides a caption for a <code> FIELDSET </code> grouping. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html edef]-LEGEND">
 LEGEND element definition </a> in HTML 4.0.

 
 @short 
 Provides a caption for a <code> FIELDSET </code> grouping.
*/
@class HTMLFormElement; 

@interface HTMLLegendElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
- (HTMLFormElement*) form;

/** 
 A single character access key to give access to the form
 control. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-accesskey">
 accesskey attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) accessKey;

/** 
 see @ref accessKey
     
*/
- setAccessKey: (NSString *)arg1;

/** 
 Text alignment relative to <code> FIELDSET </code> . See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-align-LEGEND">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;
@end

#endif
