/***************************************************************************
                            KProcessRunner.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPROCESSRUNNER_H
#define KPROCESSRUNNER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**


 This class watches a process launched by KRun.
 It sends a notification when the process exits (for the taskbar)
 and it will show an error message if necessary (e.g. "program not found").
 
 @short 

*/
@class KProcess; 

@interface KProcessRunner : QObject 
- (void) dealloc;
- (long) pid;
+ (long) run: (KProcess*)arg1 binName: (NSString *)binName;
//+ (long) run: (KProcess*)arg1 binName: (NSString *)binName identifier: (KStartupInfoId*)identifier;
- slotProcessExited: (KProcess*)arg1;
@end

/** Override these methods in subclasses of KProcessRunner to customise event handling behaviour */
@protocol KProcessRunnerEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
