/***************************************************************************
                            KFontDialog.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KFontDialog provides a dialog for interactive font selection.
 It is basically a thin wrapper around the {@link KFontChooser} widget,
 which can also be used standalone. In most cases, the simplest
 use of this class is the static method {@link KFontDialog#getFont},
 which pops up the dialog, allows the user to select a font, and
 returns when the dialog is closed.

 Example:

 <pre>
      QFont myFont;
      int result = KFontDialog.getFont( myFont );
      if ( result == KFontDialog.Accepted )
            ...
 </pre>

 \image html kfontdialog.png "KDE Font Dialog"

 See {@link KFontDialogSignals} for signals emitted by KFontDialog.

 

 @author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

 @version $Id: KFontDialog.java,v 1.9 2002/11/26 04:17:32 rdale Exp $
 
 @short A font selection dialog.

*/
public class KFontDialog extends KDialogBase  {
	protected KFontDialog(Class dummy){super((Class) null);}

	private native void newKFontDialog( QWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist, boolean makeFrame, boolean diff, int sizeIsRelativeState);

/** 
 Constructs a font selection dialog.

   
*/
	public KFontDialog( QWidget parent, String name, boolean onlyFixed, boolean modal, String[] fontlist, boolean makeFrame, boolean diff, int sizeIsRelativeState) {
		super((Class) null);
		newKFontDialog( parent, name, onlyFixed, modal, fontlist, makeFrame, diff, sizeIsRelativeState);
	}
	private native void newKFontDialog();
	public KFontDialog() {
		super((Class) null);
		newKFontDialog();
	}

/** 
 Sets the currently selected font in the dialog.

*/
	public native void setFont( QFont font, boolean onlyFixed);
	public native void setFont( QFont font);

/** 

*/
	public native QFont font();

/** 
 Sets the state of the checkbox indicating whether the font size
 is to be interpreted as relative size.
 NOTE: If parameter sizeIsRelative was not set in the constructor
       of the dialog this setting will be ignored.
   
*/
	public native void setSizeIsRelative( int relative);

/** 

*/
	public native int sizeIsRelative();

/** 
 Creates a modal font dialog, lets the user choose a font,
 and returns when the dialog is closed.

*/
	public static native int getFont( QFont theFont, boolean onlyFixed, QWidget parent, boolean makeFrame, int[] sizeIsRelativeState);
	public static int getFont( QFont theFont, boolean onlyFixed, QWidget parent) {
		return getFont(theFont, onlyFixed, parent, true, null);
	}
	public static int getFont( QFont theFont, boolean onlyFixed) {
		return getFont(theFont, onlyFixed, null, true, null);
	}
	public static native int getFont( QFont theFont);

/** 
 Creates a modal font difference dialog, lets the user choose a selection
 of changes that should be made to a set of fonts, and returns when the
 dialog is closed. Useful for choosing slight adjustments to the font set
 when the user would otherwise have to manually edit a number of fonts.

*/
	public static native int getFontDiff( QFont theFont, int[] diffFlags, boolean onlyFixed, QWidget parent, boolean makeFrame, int[] sizeIsRelativeState);
	public static int getFontDiff( QFont theFont, int[] diffFlags, boolean onlyFixed, QWidget parent) {
		return getFontDiff(theFont, diffFlags, onlyFixed, parent, true, null);
	}
	public static int getFontDiff( QFont theFont, int[] diffFlags, boolean onlyFixed) {
		return getFontDiff(theFont, diffFlags, onlyFixed, null, true, null);
	}
	public static native int getFontDiff( QFont theFont, int[] diffFlags);

  /**
   When you are not only interested in the font selected, but also
   in the example string typed in, you can call this method.

  */
	public static native int getFontAndText( QFont theFont, StringBuffer theString, boolean onlyFixed, QWidget parent, boolean makeFrame, int[] sizeIsRelativeState);
	public static int getFontAndText( QFont theFont, StringBuffer theString, boolean onlyFixed, QWidget parent) {
		return getFontAndText(theFont, theString, onlyFixed, parent, true, null);
	}
	public static int getFontAndText( QFont theFont, StringBuffer theString, boolean onlyFixed) {
		return getFontAndText(theFont, theString, onlyFixed, null, true, null);
	}
	public static native int getFontAndText( QFont theFont, StringBuffer theString);

	protected native void virtual_hook( int identifier, int data);
}
