/***************************************************************************
                          KDESupport.h  -  description
                             -------------------
    begin                : Wed Aug 15 2001
    copyright            : (C) 2001 by Richard Dale
    email                : Lost_Highway@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDESUPPORT_H
#define KDESUPPORT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <Foundation/NSArray.h>

#include <qtc/qtc_types.h>
#include <kdec/kde_types.h>

/**
  *@author Richard Dale
  */


@interface KDESupport : NSObject
@end 

	/** Convert from an NSString String to DOM::DOMString */


@interface NSString (KDESupport)
- (kde_DOMString *) toDOMString: (kde_DOMString **) string;
- (NSString *) fromDOMString: (kde_DOMString *) string;
@end


/** Convenience methods for converting NSArrays to KDE lists */


@interface NSArray (KDESupport)
- (kde_KURLList *) toKURLList: (kde_KURLList **) urllist;
- (kde_KFileItemList *) toKFileItemList: (kde_KFileItemList **) fileitemlist;
@end

/** Convenience methods for creating NSMutableArrays from KDE lists */


@interface NSMutableArray (KDESupport)
+ (NSArray *) arrayWithQCStringList: (kde_QCStringList *) strlist;
+ (NSArray *) arrayWithOfferList: (kde_OfferList *) offerlist;
+ (NSArray *) arrayWithKMainWindowList: (kde_KMainWindowList *) windowlist;
+ (NSArray *) arrayWithKFileItemList: (kde_KFileItemList *) fileitemlist;
+ (NSArray *) arrayWithKURLList: (kde_KURLList *) urllist;
+ (NSArray *) arrayWithNodeList: (kde_DOMNodeList *) nodelist;
+ (NSArray *) arrayWithStyleSheetList: (kde_StyleSheetList *) styelsheetlist;
@end

#endif
