//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMDENSITY_H
#define PMDENSITY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmtexturebase.h"

/**
 * Class for povray densities
 */
class PMDensity : public PMTextureBase
{
   typedef PMTextureBase Base;
public:
   /** Creates an PMDensity */
   PMDensity( );
   /** Deletes the object */
   virtual ~PMDensity( );
   
   /** */
   virtual PMObject* newObject( ) const { return new PMDensity( ); }
   /** */
   virtual QString className( ) const { return QString( "density" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTDensity; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual int canInsert( const QValueList<PMObjectType>& list,
                          const PMObject* after ) const;
   /** */
   virtual int canInsert( const PMObjectList& list,
                          const PMObject* after ) const;
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;

   /** Returns a new @ref PMDensityEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmdensity" ); }

private:
   void countChild( PMObjectType t,
                    int& color, int& listpattern, int& pattern, int& map,
                    int& warp, int& blend, int& summap, int& sum, 
                    bool& afterPattern, bool& afterMap, bool& afterWarp, 
                    bool& afterBlend, bool& afterTransform, 
                    bool insertPoint ) const;
   bool canInsert( PMObjectType t,
                   int color, int listpattern, int pattern, int map,
                   int warp, int blend, int summap, int sum, bool afterPattern,
                   bool afterMap, bool afterWarp, bool afterBlend,
                   bool afterTransform ) const;

   /** IDs for @ref PMMementoData */
//   enum PMDensityMementoID { };
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};


#endif
