.TH "updmap" "1" "November 2002" "teTeX" "teTeX" 
.PP 
.SH "NAME" 
updmap \- Update font map files for TeX output drivers\&.
.PP 
.SH "SYNOPSIS" 
.PP 
\fBupdmap\fP [ \fIOPTION\fP \&.\&.\&. ]  [
\fICOMMAND\fP  \&.\&.\&. ]
.PP 
.SH "DESCRIPTION" 
.PP 
\fBupdmap\fP is a utility that creates font configuration files for
\fBdvips\fP(1), \fBpdftex\fP(1), \fBxdvi\fP(1),
\fBps2pk\fP(1), \fBgsftopk\fP(1), and (soon) \fBdvipdfm\fP(1)\&.
In an ideal world, updmap would be unnecessary -- each of these
programs would read the same configuration file to learn what fonts
are available and how they should be treated\&.  As things stand,
however, each of these tools has subtly different requirements and
thereby needs its own font configuration file\&.  \fBupdmap\fP creates
font configuration files for all of these programs from a single
source, allowing you to easily keep all the different configuration
files in sync\&.
.PP 
\fBupdmap\fP reads a configuration file, \fBupdmap\&.cfg\fP(5) and,
depending on the options specified in that file and on the command
line, \fBupdmap\fP will write generated map files to a directory of
your choosing (via the \fB--outputdir\fP option), or automatically
determine where to place the files\&.  In the latter case, it uses the
following heuristic: if VARTEXMF is set and the VARTEXMF
tree contains a writable \fBdvips/config\fP directory, that directory
is used\&.  Otherwise \fBupdmap\fP uses the TEXMFMAIN directory\&.
.PP 
.SH "OPTIONS" 
.PP 
The following command-line options are available:
.IP 
.IP "\fB--cnffile\fP \fIfile\fP" 
Specify a configuration file\&.
.IP 
.IP "\fB--outputdir\fP \fIdirectory\fP" 
Specify the output
directory for generated map files\&.
.IP 
.IP "\fB--nohash\fP" 
Do not run \fBtexhash\fP(1)\&.
.IP 
.IP "\fB--nomkmap\fP" 
Do not recreate existing map files\&.
.IP 
.IP "\fB--quiet\fP" 
Reduce verbosity\&.
.IP 
.PP 
The following commands can be substituted for \fICOMMAND\fP:
.IP 
.IP "\fB--edit\fP" 
Edit the \fIupdmap\&.cfg\fP file\&.
.IP 
.IP "\fB--help\fP" 
Show a command and option summary\&.
.IP 
.IP "\fB--showoptions\fP \fIitem\fP" 
Show alternatives for option
\fIitem\fP\&.
.IP 
.IP "\fB--setoption\fP \fIoption\fP \fIvalue\fP" 
Set
\fIoption\fP to \fIvalue\fP, where \fIoption\fP is one of
.IP o 
\fBdvipsPreferOutline\fP
.IP o 
\fBLW35\fP
.IP o 
\fBdvipsDownloadBase35\fP
.IP o 
\fBpdftexDownloadBase14\fP
.IP 
.IP "\fB--enable\fP \fImaptype\fP \fImapfile\fP" 
Add or enable a
Map or MixedMap\&.
.IP 
.IP "\fB--disable\fP \fImapfile\fP" 
Disable Map or MixedMap for
\fImapfile\fP\&.
.IP 
.IP "\fB--listmaps\fP" 
List all active and inactive maps\&.
.PP 
.SH "FILES" 
.PP 
Configuration files:
.IP "\fIupdmap\&.cfg\fP" 
Main configuration file\&.  In
\fItexmf/web2c\fP by default, but may be located elsewhere
depending on your distribution\&.
.IP 
.IP "\fIpdftex35\&.map\fP" 
Map data for basic 35 PostScript files for
use with \fBpdftex\fP(1)\&.
.IP 
.IP "\fIps2pk35\&.map\fP" 
Map data for basic 35 PostScript files for
use with \fBps2pk35\fP(1)\&. 
.IP 
.IP "\fIdvips35\&.map\fP" 
Map data for basic 35 PostScript files for
use with \fBdvips\fP(1)\&. 
.IP 
.PP 
Output files:
.IP 
.IP "\fIpsfonts\&.map\fP" 
For \fBdvips\fP(1)\&.  With
\fBdvipsPreferOutline\fP and \fBdvipsDownloadBase35\fP enabled\&.
.IP 
.IP "\fIpsfonts_pk\&.map\fP" 
As \fIpsfonts\&.map\fP, but without
information from MixedMap files\&.  (Setting of
\fBdvipsPreferOutline\fP ignored\&.)
.IP 
.IP "\fIpsfonts_t1\&.map\fP" 
As \fIpsfonts\&.map\fP, but \fIwith\fP
information from MixedMap files\&.  (Setting of
\fBdvipsPreferOutline\fP ignored\&.)
.IP 
.IP "\fIdownload35\&.map\fP" 
As \fIpsfonts\&.map\fP, but always
downloads the standard 35 fonts\&.  (Setting of
\fBdvipsDownloadBase35\fP ignored\&.)
.IP 
.IP "\fIbuiltin35\&.map\fP" 
As \fIpsfonts\&.map\fP, but never
downloads the standard 35 fonts\&.  (Setting of
\fBdvipsDownloadBase35\fP ignored\&.)
.IP 
.IP "\fIpdftex\&.map\fP" 
Font map file for \fBpdftex\fP(1)\&.  (Set
with \fBpdftexDownloadBase14\fP\&.)
.IP 
.IP "\fIpdftex_dl14\&.map\fP" 
As \fIpdftex\&.map\fP, but always
downloads the standard 14 fonts\&.
.IP 
.IP "\fIpdftex_ndl14\&.map\fP" 
As \fIpdftex\&.map\fP, but never
downloads the standard 14 fonts\&.
.IP 
.IP "\fIps2pk\&.map\fP" 
Similar to \fBdvips\fP(1) map file, but
forces all fonts to be downloaded, so this map file can be used with
\fBxdvi\fP(1) and \fBps2pk\fP(1)\&.
.IP 
.PP 
teTeX configuration files tuned for use with \fBupdmap\fP:
.IP 
.IP "\fIconfig\&.builtin35\fP" 
Loads \fIbuildin35\&.map\fP\&.
.IP 
.IP "\fIconfig\&.download35\fP" 
Loads \fIdownload35\&.map\fP\&.
.IP 
.IP "\fIconfig\&.outline\fP" 
Loads \fIpsfonts_t1\&.map\fP instead
of \fIpsfonts\&.map\fP\&.
.IP 
.IP "\fIconfig\&.pdf\fP" 
Loads \fIpsfonts_t1\&.map\fP instead
of \fIpsfonts\&.map\fP and has additional optimizations for PDF generation\&.
.IP 
.IP "\fIconfig\&.pk\fP" 
Loads \fIpsfonts_pk\&.map\fP instead of
\fIpsfonts\&.map\fP\&.
.IP 
.IP "\fIconfig\&.www\fP" 
Loads \fIpsfonts_t1\&.map\fP instead of
\fIpsfonts\&.map\fP\&.  (For compatibility with previous versions of
teTeX\&.)
.IP 
.IP "\fIconfig\&.gstopk\fP" 
Loads \fIpsfonts_t1\&.map\fP\&.
.IP 
.PP 
.SH "SEE ALSO" 
.PP 
\fBupdmap\&.cfg\fP(5), \fBdvipdfm\fP(1), \fBdvips\fP(1),
\fBgsftopk\fP(1), \fBpdftex\fP(1), \fBps2pk\fP(1),
\fBps2pk35\fP(1), \fBtexhash\fP(1), \fBxdvi\fP(1)\&.
.PP 
Web page: \fI<http://tug\&.cs\&.umb\&.edu/tetex/>\fP
.PP 
.SH "BUGS" 
.PP 
None known, but report any bugs found to <tetex@informatik\&.uni-hannover\&.de> (mailing list)\&.
.PP 
.SH "AUTHOR" 
.PP 
\fBupdmap\fP was written by Thomas Esser 
<te@informatik\&.uni-hannover\&.de> and is in the public domain\&.
.PP 
This manual page was written by C\&.M\&. Connelly
<cmc@debian\&.org>, for
the Debian GNU/Linux system\&.  It may be used by other distributions
without contacting the author\&.  Any mistakes or omissions in the
manual page are my fault; inquiries about or corrections to this
manual page should be directed to me (and not to the primary author)\&.
