/**
 *
 * $Header: /cvsroot/lesstif/lesstif/include/Motif-2.0/Xm/XmIm.h,v 1.3 2000/12/03 01:19:15 dannybackx Exp $
 *
 * Copyright (C) 2000 LessTif Development Team
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef _XM_XMIM_H
#define _XM_XMIM_H

#ifdef __cplusplus
extern "C" {
#endif

void XmImCloseXIM(Widget w);

void XmImFreeXIC(Widget w, XIC xic);

XIC XmImGetXIC(Widget w,
               XmInputPolicy input_policy,
               ArgList args,
               Cardinal num_args);

XIM XmImGetXIM(Widget w);

int XmImMbLookupString(Widget w,
                       XKeyPressedEvent *evp,
                       char *buf,
                       int nbytes,
                       KeySym *keysym,
                       int *status);

void XmImMbResetIC(Widget widget,
                   char **mb);

void XmImRegister(Widget w,
                  unsigned int reserved);

void XmImSetFocusValues(Widget w,
                        ArgList args,
                        Cardinal num_args);

void XmImSetValues(Widget w,
                   ArgList args,
                   Cardinal num_args);

XIC XmImSetXIC(Widget w, XIC xic);

void XmImRegister(Widget w,
                  unsigned int reserved);

void XmImUnregister(Widget w);

void XmImUnsetFocus(Widget w);

void XmImVaSetFocusValues(Widget w, ...);

void XmImVaSetValues(Widget w, ...);

#ifdef __cplusplus
}
#endif

#endif /* _XM_XMIM_H */
