#!/bin/sed -f
#
# gnu2pmake --
#	Convert GNUmakefiles to pmake-files.
#
# Tries to replace GNU make directives with equivalent pmake ones.
# Cleverly uses pmake conditionals, and the fact that pmake directives look
# like comments to other makes, to produce a makefile that can be processed
# by both pmake and (gnu)make.
#
# ifeq conditionals aren't handled yet.
#
# $Id: gnu2pmake.sed,v 1.1 1993/01/07 00:20:26 stolcke Exp $
#
/^[ 	]*include\>/{
i\
\#ifndef .PMAKE
p
i\
\#endif
s/^[ 	]*include[ 	]*<\(.*\)>/#include <\1>/
s/^[ 	]*include[ 	]*\([^ 	]*\)/#include "\1"/
}
/^[ 	]*ifdef\>/{
i\
\#ifndef .PMAKE
p
i\
\#endif
s/^[ 	]*ifdef[ 	]*\([^ 	]*\)/#ifdef \1/
}
/^[ 	]*ifndef[ 	]/{
i\
\#ifndef .PMAKE
p
i\
\#endif
s/^[ 	]*ifndef[ 	]*\([^ 	]*\)/#ifndef \1/
}
/^[ 	]*else\>/{
i\
\#ifndef .PMAKE
p
i\
\#endif
s/^[ 	]*else/#else/
}
/^[ 	]*endif\>/{
i\
\#ifndef .PMAKE
p
i\
\#endif
s/^[ 	]*endif/#endif/
}
