/***************************************************************************
                            KRootProp.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Access KDE desktop resources stored on the root window.

 A companion to the {@link KConfig} class.

 The KRootProp class is used for reading and writing configuration entries
 to properties on the root window.

 All configuration entries are of the form "key=value".

 @author Mark Donohoe (donohe@kde.org)

 @version $Id: KRootProp.java,v 1.7 2002/11/26 04:17:34 rdale Exp $

 @short *
 Access KDE desktop resources stored on the root window.
*/
public class  KRootProp implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KRootProp(Class dummy){}

	private native void newKRootProp( String rProp);

/** 
 Constructs a KRootProp object for the property <code>rProp.</code>

*/
	public KRootProp( String rProp) {
		newKRootProp( rProp);
	}
	private native void newKRootProp();
	public KRootProp() {
		newKRootProp();
	}

/** 
 Destructs the KRootProp object.

 Writes back any dirty configuration entries.

*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the property in which keys will be searched.

*/
	public native void setProp( String rProp);
	public native void setProp();

/** 
 Returns the name of the property under which keys are searched.

*/
	public native String prop();

/** 
 Destroys the property completely.

 I.e. all entries will be cleared
 and the property will be removed from the root window.

*/
	public native void destroy();

/** 
 Reads the value of an entry specified by <code>rKey</code> in the current property.

*/
	public native String readEntry( String rKey, String pDefault);
	public native String readEntry( String rKey);

/** 
 Reads a numerical value.

 Reads the value of an entry specified by <code>rKey</code> in the current property
 and interprets it numerically.

*/
	public native int readNumEntry( String rKey, int nDefault);
	public native int readNumEntry( String rKey);

/** 
 Reads a {@link QFont} value.

 Reads the value of an entry specified by <code>rKey</code> in the current property
 and interpret it as a font object.

*/
	public native QFont readFontEntry( String rKey, QFont pDefault);
	public native QFont readFontEntry( String rKey);

/** 
 Reads a {@link QColor}.

 Reads the value of an entry specified by <code>rKey</code> in the current property
 and interprets it as a color.

*/
	public native QColor readColorEntry( String rKey, QColor pDefault);
	public native QColor readColorEntry( String rKey);

/** 
 Writes a (key/value) pair.

 This is stored to the current property when destroying the
 config object or when calling {@link #sync}.

*/
	public native String writeEntry( String rKey, String rValue);

/** 
 Writes the (key/value) pair.
 Same as above, but writes a numerical value.

*/
	public native String writeEntry( String rKey, int nValue);

/** 
 Writes the (key/value) pair.
 Same as above, but writes a font.

*/
	public native String writeEntry( String rKey, QFont rFont);

/** 
 Writes the (key/value) pair.
 Same as above, but writes a color.

*/
	public native String writeEntry( String rKey, QColor rColor);

/** 
 Removes an entry.

*/
	public native String removeEntry( String rKey);

/** 
 Returns a list of all keys.

*/
	public native ArrayList listEntries();

/** 
 Flushes the entry cache.
 Writes back dirty configuration entries to the current property,
 This is called automatically from the destructor.

*/
	public native void sync();
}
