/***************************************************************************
                            KScanDialog.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is a base class for scanning dialogs. You can derive from this class
 and implement your own dialog. An implementation is available in
 kdegraphics/libkscan.

 Application developers that wish to add scanning support to their program
 can use the static method <code>KScanDialog.getScanDialog</code>() to get an instance
 of the user's preferred scanning dialog.

 Typical usage looks like this (e.g. in a slotShowScanDialog() method):

 <pre>
 if ( !m_scanDialog ) {
     m_scanDialog = KScanDialog.getScanDialog( this, "scandialog" );
     if ( !m_scanDialog ) // no scanning support installed?
         return;

     connect( m_scanDialog, SIGNAL(" finalImage( const QImage&, int )"),
              SLOT(" slotScanned( const QImage&, int )"));
 }

 if ( m_scanDialog.setup() ) // only if scanner configured/available
     m_scanDialog.show();
 </pre>

 This will create and show a non-modal scanning dialog. Connect to more
 signals if you like.

 If you implement an own scan-dialog, you also have to implement a
 KScanDialogFactory.

 See {@link KScanDialogSignals} for signals emitted by KScanDialog.

 

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A baseclass and accessor for Scanning Dialogs.
*/
public class KScanDialog extends KDialogBase  {
	protected KScanDialog(Class dummy){super((Class) null);}


/** 
 Destructs the scan dialog.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Reimplement this if you need to set up some things, before showing the
 dialog, e.g. to ask the user for the scanner device to use. If you 
 return false (e.g. there is no device available or the user aborted
 device selection), the dialog will not be shown.

 Returns true by default.
     
*/
	public native boolean setup();

/** 
 Creates the user's preferred scanning dialog and returns it,
 or null if no scan-support
 is available. Pass a suitable <code>parent</code> widget, if you like. If you
 don't you have to 'delete' the returned pointer yourself.
     
*/
	public static native KScanDialog getScanDialog( QWidget parent, String name, boolean modal);
	public static native KScanDialog getScanDialog();
	private native void newKScanDialog( int dialogFace, int buttonMask, QWidget parent, String name, boolean modal);

/** 
 Constructs the scan dialog. If you implement an own dialog, you can
 customize it with the usual {@link KDialogBase} flags.

*/
	public KScanDialog( int dialogFace, int buttonMask, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKScanDialog( dialogFace, buttonMask, parent, name, modal);
	}
	private native void newKScanDialog();
	public KScanDialog() {
		super((Class) null);
		newKScanDialog();
	}

/** 

*/
	protected native int id();

/** 

     
*/
	protected native int nextId();
	protected native void virtual_hook( int identifier, int data);
}
