/***************************************************************************
                            KShortcut.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

public class  KShortcut implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KShortcut(Class dummy){}

	private native void newKShortcut();

/** 
 Creates a new null shortcut.

*/
	public KShortcut() {
		newKShortcut();
	}
	private native void newKShortcut( int keyQt);

/** 
 Creates a new shortcut with the given Qt key code
 as the only key sequence.

*/
	public KShortcut( int keyQt) {
		newKShortcut( keyQt);
	}
	private native void newKShortcut( QKeySequence keySeq);

/** 
 Creates a new shortcut that contains only the given qt key
 sequence.

*/
	public KShortcut( QKeySequence keySeq) {
		newKShortcut( keySeq);
	}
	private native void newKShortcut( KKey key);

/** 
 Creates a new shortcut that contains only the given key
 in its only sequence.

*/
	public KShortcut( KKey key) {
		newKShortcut( key);
	}
	private native void newKShortcut( KKeySequence keySeq);

/** 
 Creates a new shortcut that contains only the given key
 sequence.

*/
	public KShortcut( KKeySequence keySeq) {
		newKShortcut( keySeq);
	}
	private native void newKShortcut( KShortcut shortcut);

/** 
 Copies the given shortcut.

*/
	public KShortcut( KShortcut shortcut) {
		newKShortcut( shortcut);
	}
	private native void newKShortcut( String shortcut);

/** 
 Creates a new key sequence that contains the given key sequence.
 The description consists of semicolon-separated keys as
 used in {@link KKeySequence#KKeySequence}.

*/
	public KShortcut( String shortcut) {
		newKShortcut( shortcut);
	}
//	private native void newKShortcut( String shortcut);

/** 
 Creates a new key sequence that contains the given key sequence.
 The description consists of semicolon-separated keys as
 used in {@link KKeySequence#KKeySequence}.

*/
//	public KShortcut( String shortcut) {
//		newKShortcut( shortcut);
//	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Clears the shortcut. The shortcut is null after calling this 
 function.

*/
	public native void clear();

/** 
 Initializes the shortcut with the given Qt key code
 as the only key sequence.

*/
	public native boolean init( int keyQt);

/** 
 Initializes the shortcut with the given qt key sequence.

*/
	public native boolean init( QKeySequence keySeq);

/** 
 Initializes the shortcut with the given key as its only sequence.

*/
	public native boolean init( KKey key);

/** 
 Initializes the shortcut with the given qt key sequence.

*/
	public native boolean init( KKeySequence keySeq);

/** 
 Copies the given shortcut.

*/
	public native boolean init( KShortcut shortcut);

/** 
 Initializes the key sequence with the given key sequence.
 The description consists of semicolon-separated keys as
 used in {@link KKeySequence#KKeySequence}.

*/
	public native boolean init( String shortcut);

/** 
 Returns the number of sequences that are in this
 shortcut.

*/
	public native int count();

/** 
 Returns the <code>i</code>'th key sequence of this shortcut.

*/
	public native KKeySequence seq( int i);

/** 
 Returns the key code of the first key sequence, or 
 null if there is no first key sequence.

*/
	public native int keyCodeQt();

/** 
 Returns true if the shortcut is null (after {@link #clear} or empty
 constructor).

*/
	public native boolean isNull();

/** 
 Compares this object with the given shortcut. Returns a negative 
 number if the given shortcut is larger, 0 if they are equal and
 a positive number this shortcut is larger. Shortcuts are
 compared by comparing the individual key sequences, starting from the 
 beginning until an unequal key sequences has been found. If a shortcut
 contains more key sequences, it is considered larger.

*/
	public native int compare( KShortcut shortcut);

/** 
 Checks whether this shortcut contains a sequence that starts
 with the given key.

*/
	public native boolean contains( KKey key);

/** 
 Checks whether this shortcut contains a sequence that starts
 with the given key.

*/
//	public native boolean contains( KKeyNative key);

/** 
 Checks whether this shortcut contains the given sequence.

*/
	public native boolean contains( KKeySequence keySeq);

/** 
 Sets the <code>i</code>'th key sequence of the shortcut. You can not introduce 
 gaps in the list of sequences, so you must use an @i <= {@link #count}. 
 Also note that the maximum number of key sequences is {@link MAX_SEQUENCES}.

*/
	public native boolean setSeq( int i, KKeySequence keySeq);

/** 
 Appends the given key sequence.

*/
	public native boolean append( KKeySequence keySeq);

/** 
 Returns a description of the shortcut as semicolon-separated
 ket sequences, as returned by {@link KKeySequence#toString}.

*/
	public native String toString();

/** 

	 
*/
	public native String toStringInternal( KShortcut pcutDefault);
	public native String toStringInternal();

/** 
 Returns a null shortcut.

*/
	public static native KShortcut nullShortcut();
	public static final int MAX_SEQUENCES = 2;
}
