/***************************************************************************
                            KDataTool.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDATATOOL_H
#define KDATATOOL_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 A generic tool that processes data.

 A data-tool is a "plugin" for an application, that acts (reads/modifies)
 on a portion of the data present in the document (e.g. a text document,
 a single word or paragraph, a KSpread cell, an image, etc.)

 The application has some generic code for presenting the tools in a popupmenu

 @short 
 A generic tool that processes data.
*/
@class KInstance; 

@interface KDataTool : QObject 

/** 

     
*/
- setInstance: (KInstance*)instance;

/** 

*/
- (KInstance*) instance;

/** 
 Interface for 'running' this tool.
 This is the method that the data-tool must implement.

*/
- (BOOL) run: (NSString *)command data: (void*)data datatype: (NSString *)datatype mimetype: (NSString *)mimetype;
@end

/** Override these methods in subclasses of KDataTool to customise event handling behaviour */
@protocol KDataToolEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
