/*
 *   pageSizeDialog, for kviewshell
 *   This file: Copyright (C) 2002 Stefan Kebekus, kebekus@kde.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef _PAGESIZE_DIALOG_H_
#define _PAGESIZE_DIALOG_H_

#include <kdialogbase.h>

class pageSizeWidget;

class pageSizeDialog : public KDialogBase
{
  Q_OBJECT
    
public:
  pageSizeDialog( QWidget *parent=0, const char *name=0, bool modal=true);
  void setPageSize(QString);
  void setOrientation(int);

signals: 
  // Emitted to indicate that the user has chosen a size. The string
  // is suitable to be fed into the setPageSize() method of a pageSize
  // object.
  void sizeSelected(const QString &size, int orientation);

protected slots:
  virtual void slotOk();
  virtual void slotApply();
  
 private:
  pageSizeWidget *pageSizeW;
};


#endif
