#!/bin/sh
# finish up the installation
# this script should be executed using the sudo command
# this file is copied to SDL-devel.post_install and SDL-devel.post_upgrade
# inside the .pkg bundle
echo "Running post-install script"
umask 022

USER=basename ~
echo "User is \"$USER\""

ROOT=/Developer/Documentation/SDL

echo "Moving SDL.framework to ~/Library/Frameworks"
# move SDL to its proper home, so the target stationary works
sudo -u $USER mkdir -p ~/Library/Frameworks
sudo -u $USER /Developer/Tools/CpMac -r $ROOT/SDL.framework ~/Library/Frameworks
rm -rf $ROOT/SDL.framework

echo "Precompiling Header"
# precompile header for speedier compiles
sudo -u $USER /usr/bin/cc -precomp ~/Library/Frameworks/SDL.framework/Headers/SDL.h -o ~/Library/Frameworks/SDL.framework/Headers/SDL.p

echo "Installing Stationary"
# move stationary to its proper home
mkdir -p "/Developer/ProjectBuilder Extras/Project Templates/Application"
mkdir -p "/Developer/ProjectBuilder Extras/Target Templates/SDL"

cp -r "$ROOT/Project Stationary/SDL Application"              "/Developer/ProjectBuilder Extras/Project Templates/Application/"
cp -r "$ROOT/Project Stationary/SDL Cocoa Application"        "/Developer/ProjectBuilder Extras/Project Templates/Application/"
cp -r "$ROOT/Project Stationary/SDL Custom Cocoa Application" "/Developer/ProjectBuilder Extras/Project Templates/Application/"
cp -r "$ROOT/Project Stationary/SDL OpenGL Application"       "/Developer/ProjectBuilder Extras/Project Templates/Application/"
cp "$ROOT/Project Stationary/Application.trgttmpl"            "/Developer/ProjectBuilder Extras/Target Templates/SDL/"

rm -rf "$ROOT/Project Stationary"

echo "Installing Man Pages"
# remove old man pages
rm -rf "/Developer/Documentation/ManPages/man3/SDL"*

# install man pages
mkdir -p "/Developer/Documentation/ManPages/man3"
cp "$ROOT/docs/man3/SDL"* "/Developer/Documentation/ManPages/man3/"
rm -rf "$ROOT/docs/man3"

echo "Rebuilding Apropos Database"
# rebuild apropos database
/usr/libexec/makewhatis

# copy README file to your home directory
sudo -u $USER cp "$ROOT/Readme SDL Developer.txt" ~/

# open up the README file
sudo -u $USER open ~/"Readme SDL Developer.txt"
