/*
 * Copyright (C) 2002-2003 the xine-project
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: playlist.h,v 1.8 2003/02/25 22:13:17 guenter Exp $
 *
 * playlist window for gnome-xine
 */
#ifndef HAVE_PLAYLIST_H
#define HAVE_PLAYLIST_H

#include "play_item.h"

void playlist_init (void);

void playlist_show (void);

void playlist_clear (void);

int  playlist_add     (play_item_t *play_item);
int  playlist_add_mrl (const char *mrl) ;
void playlist_insert  (play_item_t *play_item, int pos);

void playlist_play      (int list_pos);
void playlist_play_from (int list_pos, int pos, int pos_time);

void playlist_logo (void);

play_item_t *playlist_get_item     (int list_pos);
int          playlist_get_list_pos (void); /*of currently played entry*/

int playlist_size (void);

void playlist_save (char *filename);

#endif
