/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *  aRts Driver - Copyright (C) 2000 B. Heath Robinson
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef ARTS_OUT_H
#define ARTS_OUT_H

#include "config.h"

#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <artsc.h>

#include <fcntl.h>
#include <unistd.h>
#include <pthread.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <xmms/plugin.h>
#include <xmms/configfile.h>

extern OutputPlugin op;

typedef struct
{
        gint buffer_size;
        gint prebuffer;
}
aRtsConfig;

extern aRtsConfig arts_cfg;

void artsd_init(void);
void artsd_about(void);
void artsd_configure(void);

void artsd_get_volume(int *l, int *r);
void artsd_set_volume(int l, int r);

int artsd_playing(void);
int artsd_free(void);
void artsd_write(void *ptr, int length);
void artsd_close(void);
void artsd_flush(int time);
void artsd_pause(short p);
int artsd_open(AFormat fmt, int rate, int nch);
int artsd_get_output_time(void);
int artsd_get_written_time(void);
void artsd_set_audio_params(void);

#endif
