.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
glblur - 3D radial blur texture fields
.SH SYNOPSIS
.B menger
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-blursize \fInumber\fP]
[\-no-wander]
[\-no-spin]
[\-spin \fI[XYZ]\fP]
[\-wireframe]
[\-fps]
.SH DESCRIPTION
This program draws a box and a few line segments, and generates a 
radial blur outward from it.  This creates flowing field effects.

This is done by rendering the scene into a small texture, then
repeatedly rendering increasingly-enlarged and increasingly-transparent
versions of that texture onto the frame buffer.  As such, it's quite
graphics intensive: don't bother trying to run this if you don't have
hardware-accelerated texture support.  It will hurt your machine bad.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 10000 (0.01 seconds.).
.TP 8
.B \-blursize \fInumber\fP
How many copies of the scene should be laid down to make the vapor trail.
Default: 15.  Larger numbers create smoother fields, but are slower.
.TP 8
.B \-wander | \-no-wander
Whether the object should wander around the screen.
.TP 8
.B \-spin [XYZ]
Around which axes should the object spin?
.TP 8
.B \-no-spin
None.
.TP 8
.B \-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-fps | \-no-fps
Whether to show a frames-per-second display at the bottom of the screen.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2002 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski, with inspiration from a tutorial by Dario Corno.
