.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
glslideshow - slideshow of images using smooth zooming and fades
.SH SYNOPSIS
.B glslideshow
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-pan \fIseconds\fP]
[\-fade \fIseconds\fP]
[\-zoom \fIpercent\fP]
[\-delay \fIusecs\fP]
[\-cutoff \fIint\fP]
[\-fps]
[\-debug]
[\-wireframe]
.SH DESCRIPTION
Loads a random sequence of images and smoothly scans and zooms around
in each, fading from pan to pan.  

This program requires a good video card capable of supporting large
textures.

To specify the directory that images are loaded from, run
.BR xscreensaver-demo (1)
and click on the "Advanced" tab.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-pan \fIseconds\fP
How long each pan should last.  Default 6 seconds.
.TP 8
.B \-fade \fIseconds\fP
How long each fade (in and out) should last.  Default 2 seconds.
If set to 0, then no cross-fading will be done (all transitions
will be jump-cuts.)

Note that fades are included in the pan, so \fI\-pan\fP should
always be longer than  \fI\-fade\fP (it is auto-corrected if not.)
.TP 8
.B \-zoom \fInumber\fP
Amount to zoom and pan as a percentage. Default: 75, meaning that
75% or more of each image will always be visible.  If set to 100%,
then the images will always fill the screen, and no panning or 
zooming will occur.  Images will still smoothly fade from one
to another, however, assuming \fI\-fade\fP is non-zero.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 20000 (0.02 seconds.).
.TP 8
.B \-cutoff \fInumber\fP
If the frame rate drops below this number of frames per second, then
certain features will be turned off automatically (first zooming, 
then, if the low frame rates persist, fading.)  Default 5.

The idea here is that if your machine can't maintain a decent frame
rate, then it must not have fast 3D hardware, so we might as well
behave in a simpler manner.  Set this to 0 to disable this check.
.TP 8
.B \-fps
Whether to show a frames-per-second display at the bottom of the screen.
.TP 8
.B \-debug
Prints debugging info to stderr.
.TP 8
.B \-wireframe
Instead of loading images, simply animates representative grids instead.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver-demo (1)
.BR xscreensaver-getimage (1)
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2003 by Jamie Zawinski, based on an earlier version that was
Copyright \(co 2002 by Mike Oliphant.  Originally derived from 
.BR flipscreen3d (1) ,
which was Copyright \(co 2001 Ben Buxton. 

Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  No representations are made about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
.SH AUTHOR
Jamie Zawinski and Mike Oliphant.
