.TH XScreenSaver 1 "17-Jun-99" "X Version 11"
.SH NAME
vidwhacker - grab images and apply random filters to them
.SH SYNOPSIS
.B vidwhacker
[\-display \fIhost:display.screen\fP] [\-root] [\-verbose]
[\-stdin] [\-stdout] [\-delay seconds]
[-directory \fIdirectory\fP]
.SH DESCRIPTION
The \fIvidwhacker\fP program grabs an image from disk, or  from the
system's video input, then applies random image filters to it, and
displays the result.  The \fIvidwhacker\fP program does not terminate
until killed.  

It depends heavily on the various PBM tools (e.g.,
.BR ppmrelief (1).)

Selection of random image files is done by running the
.BR xscreensaver-getimage-file (1)
program.  Capture of video frames (if requested) is done by running the
.BR xscreensaver-getimage-video (1)
program.  The options of whether to do video, and which directory to 
search for images, are specified in the \fI~/.xscreensaver\fP file.
.SH OPTIONS
.I vidwhacker
accepts the following options:
.TP 8
.B \-root
Draw on the root window.  This is the default.
.TP 8
.B \-verbose
Print diagnostics.
.TP 8
.B \-stdin
Instead of grabbing an image from disk or video, read an image
to maniupulate from stdin.  This image must be in
.BR ppm (5)
format.  The program will still perform repeated random image 
transformations, but it will always use this one image as its starting point.
.TP 8
.B \-delay \fIseconds\fP
How long to sleep between images.  Default 5 seconds (the actual
elapsed time is significantly longer, due to processing time.)
.TP 8
.B \-stdout
Instead of displaying the image on a window or on the root, write the new
image on stdout, and exit.
.TP 8
.B \-directory \fIdirectory\fP
Use this directory instead of the \fBimageDirectory\fP specified in 
the \fI~/.xscreensaver\fP file.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH BUGS
It's slow.
.SH TO DO
It might be interesting to rewrite this to use
.BR gimp (1)
plugins instead of the pbm tools.  It probably wouldn't be any faster,
but there would be a wider variety of effects available.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR xscreensaver-getimage-file (1),
.BR xscreensaver-getimage-video (1),
.BR xv (1),
.BR ppmtogif (1),
.BR cjpeg (1)
.SH COPYRIGHT
Copyright \(co 1998-2001 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, 18-Jan-98.
